/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.CMCDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.HmmDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMCTablePanel
extends JPanel
implements IImportListener,
UpdateBtnServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(CMCTablePanel.class);
    private static final String CMC_DEVICE_TABLE = "cmcDeviceTable";
    private IsmTable deviceTable;
    private DefaultTableModel tableModel;
    private TaskResult result;
    private List<IImportListener> cmcListenerTables = null;
    private List<AbstractDevice> hwXlsDevs = null;
    private SerDeviTitleLabel titleLabel = null;
    private String[] cmcTableHeader = new String[]{ResourceUtil.getString((String)"devicecenter.ismtable.header.cmc.ip"), ResourceUtil.getString((String)"devicecenter.ismtable.header.cmc.productName"), ResourceUtil.getString((String)"devicecenter.ismtable.header.cmc.sn"), ResourceUtil.getString((String)"devicecenter.ismtable.header.cmc.software"), ResourceUtil.getString((String)"devicecenter.ismtable.header.ibmc.cpld"), ResourceUtil.getString((String)"devicecenter.ismtable.header.cmc.userName")};

    public CMCTablePanel() {
        this.tableModel = new DefaultTableModel(this.cmcTableHeader, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        TableColumn firstColumn = this.deviceTable.getColumnModel().getColumn(0);
        firstColumn.setPreferredWidth(200);
        firstColumn.setMaxWidth(280);
        firstColumn.setMinWidth(200);
        TableScrollPane scrollPanel = new TableScrollPane(this.deviceTable, false, false, true);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.setBackground(Color.WHITE);
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void dealWithException(String mesage) {
    }

    @Override
    public void refreshTable(List<AbstractDevice> abstractDevices) {
        List<AbstractDevice> tableShouldRefreshDevices = LayUtil.getTableShouldRefreshDevices(this.tableModel, abstractDevices);
        DeviceCenterContext.getInstance().setIbmcHmmOsDevs(tableShouldRefreshDevices);
        LayUtil.getTableExistedDevices(this.tableModel);
        LayUtil.clearTable(this.tableModel);
        for (AbstractDevice device : tableShouldRefreshDevices) {
            if (!device.getItDeviceType().equals((Object)ITDeviceType.SERVER_CMC)) continue;
            this.tableModel.addRow(new TableRow[]{this.createCMCRow((CMCDevice)device)});
        }
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
    }

    private TableRow<CMCDevice, String> createCMCRow(CMCDevice cmcDev) {
        DefaultTableRow currentRow = new DefaultTableRow(this.cmcTableHeader.length, (Object)cmcDev, (Object)cmcDev.getIp());
        int num = 0;
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(cmcDev.getIp()));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(cmcDev.getProductName()));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(cmcDev.getSerialNumber()));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(cmcDev.getSoftware()));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(cmcDev.getCpld()));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(cmcDev.getAccount().getUserName()));
        return currentRow;
    }

    public List<CMCDevice> getSelectCmcDevs() {
        ArrayList<CMCDevice> devList = new ArrayList<CMCDevice>();
        List rows = this.getDeviceTable().getMarkedRows();
        for (TableRow row : rows) {
            devList.add((CMCDevice)row.getUserObject());
        }
        return devList;
    }

    @Override
    public void deleteServiceDev() {
        List rows = this.deviceTable.getMarkedRows();
        SmartkitUtils.deleteSceneAddDialogHasedDevices(rows, this);
        for (TableRow row : rows) {
            this.getTableModel().removeRow(new TableRow[]{row});
            LogUtils.addImportLog("devicemanager.server.manager.layout.remove", ((CMCDevice)row.getUserObject()).getIp(), true, "");
            DeviceCenterContext.getInstance().getIbmcHmmOsDevs().remove(row.getUserObject());
            LayUtil.removeDevFromAllTableDevs((AbstractDevice)row.getUserObject());
        }
        DeviceCenterContext.getInstance().notifyDeviceObserver();
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
        this.repaint();
    }

    public void refreshDevicesInfo() {
        List<CMCDevice> cmcDevices = this.getSelectCmcDevs();
        BatchImportInfoDialog importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"));
        this.cmcListenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
        SmartkitUtils.addBatchImportDialog(importDialog, this.cmcListenerTables);
        this.hwXlsDevs = new ArrayList<AbstractDevice>();
        for (CMCDevice dev : cmcDevices) {
            HwServerDevice xlsDev = dev.getHwServerDev();
            xlsDev.setStartIPAddress(dev.getIp());
            xlsDev.setEndIPAddress(dev.getIp());
            this.hwXlsDevs.add(xlsDev);
        }
        Runnable refeshIbmcDev = () -> {
            DeviceControl.getInstance().initDriverFile();
            this.result = DeviceControl.getInstance().importDevices(this.hwXlsDevs, this.cmcListenerTables);
            DeviceControl.getInstance().refreshFile();
            if (TaskResult.Result.SUCCESS.equals((Object)this.result.getResult())) {
                log.info("find the device success.");
            } else {
                log.info("find the device failed.");
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(refeshIbmcDev);
        if (log.isInfoEnabled()) {
            log.info("the result of the task is: " + future.isDone());
        }
    }

    public void modifyDevicesInfo() {
        List<CMCDevice> cmcDevices = this.getSelectCmcDevs();
        if (cmcDevices.size() > 1) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.modifiy.oneOnly"));
            return;
        }
        HmmDeviceAddLayout cmcAddLayout = new HmmDeviceAddLayout(false);
        cmcAddLayout.getStartIp().setText("IP:");
        cmcAddLayout.getSymbolLabel().setText("");
        cmcAddLayout.getStartIpAddress().setEnabled(false);
        if (cmcDevices.isEmpty()) {
            return;
        }
        HwServerDevice hwServer = cmcDevices.get(0).getHwServerDev();
        cmcAddLayout.getStartIpAddress().setText(LayUtil.filterItemInfo(cmcDevices.get(0).getIp()));
        cmcAddLayout.getEndIpField().setText(LayUtil.filterItemInfo(cmcDevices.get(0).getIp()));
        cmcAddLayout.getUserNameField().setText(LayUtil.filterItemInfo(hwServer.getUserName()));
        cmcAddLayout.getSnmpPortField().setText(LayUtil.filterItemInfo(hwServer.getSnmpPort() + ""));
        cmcAddLayout.getIpmiPortField().setText(LayUtil.filterItemInfo(hwServer.getIpmiPort() + ""));
        cmcAddLayout.getSshSfipPortField().setText(LayUtil.filterItemInfo(hwServer.getSshPort() + ""));
        cmcAddLayout.getVMPortField().setText(LayUtil.filterItemInfo(hwServer.getVmmPort() + ""));
        cmcAddLayout.getWriteCommunityPortField().setText(LayUtil.filterItemInfo(hwServer.getCommunity()));
        cmcAddLayout.getRedfishPortPortField().setText(LayUtil.filterItemInfo(hwServer.getRedFishPort()));
        hwServer.setItDeviceType(ITDeviceType.SERVER_HMM);
        HmmDeviceAddDialog addDialog = new HmmDeviceAddDialog(cmcAddLayout);
        hwServer.setStartIPAddress(cmcDevices.get(0).getIp());
        hwServer.setEndIPAddress(cmcDevices.get(0).getIp());
        addDialog.setDevInitHwServer(hwServer);
        SwingUtil.putParentCenter((Window)addDialog, (Window)DeviceCenterContext.getInstance().getParent());
        addDialog.setVisible(true);
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
    }

    @Override
    public int getSelectNum() {
        return this.getDeviceTable().getSelectedRows().length;
    }

    @Override
    public void updateBtn() {
    }

    @Override
    public List<AbstractDevice> getCurrentNeedCheckPortDeviceList() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return CMC_DEVICE_TABLE;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public void setDeviceTable(IsmTable deviceTable) {
        this.deviceTable = deviceTable;
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public SerDeviTitleLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(SerDeviTitleLabel titleLabel) {
        this.titleLabel = titleLabel;
    }
}

