/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.CommonStatus;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.ComputeNodePlate;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.ServerComputeNode;
import com.huawei.ism.tool.devicecenter.entity.SwitchPlate;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.HmmDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.action.OpreationAction;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.ComputeNodeEntity;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmSwitchChoosePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.SwitchChooseContentLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.devicemanager.ui.action.support.MultiInfoDialogParams;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMMTablePanel
extends JPanel
implements IImportListener,
UpdateBtnServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(HMMTablePanel.class);
    private static final String HMM_DIALOG = "hmmDialog";
    private IsmTable deviceTable;
    private DefaultTableModel tableModel;
    private TaskResult result;
    private List<IImportListener> hmmListenerTables = null;
    private List<AbstractDevice> hwXlsDevs = null;
    private SerDeviTitleLabel titleLabel = null;
    private String[] hmmTableHeader = new String[]{ResourceUtil.getString((String)"devicecenter.ismtable.header.hmm.serialnum"), ResourceUtil.getString((String)"devicecenter.ismtable.header.hmm.ip"), ResourceUtil.getString((String)"devicecenter.ismtable.header.hmm.username"), ResourceUtil.getString((String)"devicecenter.ismtable.header.hmm.software"), ResourceUtil.getString((String)"devicecenter.ismtable.header.hmm.compute"), ResourceUtil.getString((String)"devicecenter.ismtable.header.hmm.switch"), ResourceUtil.getString((String)"devicecenter.ismtable.header.status"), ResourceUtil.getString((String)"devicecenter.ismtable.header.suggestion")};

    public HMMTablePanel() {
        this.tableModel = new DefaultTableModel(this.hmmTableHeader, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        TableScrollPane scrollPanel = new TableScrollPane(this.deviceTable, false, false, true);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.setBackground(Color.WHITE);
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
    }

    @Override
    public void dealWithException(String mesage) {
    }

    @Override
    public void refreshTable(List<AbstractDevice> abstractDevices) {
        List<AbstractDevice> tableShouldRefreshDevices = LayUtil.getTableShouldRefreshDevices(this.tableModel, abstractDevices);
        DeviceCenterContext.getInstance().setIbmcHmmOsDevs(tableShouldRefreshDevices);
        LayUtil.getTableExistedDevices(this.tableModel);
        LayUtil.clearTable(this.tableModel);
        for (AbstractDevice device : tableShouldRefreshDevices) {
            if (!device.getItDeviceType().equals((Object)ITDeviceType.SERVER_HMM)) continue;
            this.tableModel.addRow(new TableRow[]{this.createHMMRow((HMMDevice)device)});
        }
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
    }

    private TableRow<HMMDevice, String> createHMMRow(HMMDevice hmmDevice) {
        DefaultTableRow currentRow = new DefaultTableRow(this.hmmTableHeader.length, (Object)hmmDevice, (Object)hmmDevice.getIp());
        int num = 0;
        OpreationAction opAction = new OpreationAction(hmmDevice);
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(hmmDevice.getDeviceSerialNumber()));
        currentRow.setValueAt(num++, (Object)new IsmTableCell.HyperlinkCell(hmmDevice.getIp(), (ActionListener)opAction));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(hmmDevice.getAccount().getUserName()));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(hmmDevice.getDeviceSW()));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(String.valueOf(hmmDevice.getServerComputeNodes().size())));
        currentRow.setValueAt(num++, (Object)LayUtil.createTextCell(String.valueOf(hmmDevice.getServerExchangeModules().size())));
        JSONObject resultDetail = hmmDevice.getResultDetail();
        if (null != resultDetail && resultDetail.has("result")) {
            String nodeResult = resultDetail.getString("result");
            if ("success".equals(nodeResult)) {
                currentRow.setValueAt(num, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"success.png"), CommonStatus.FINISHED.getTitle()));
                this.setResult(num, (TableRow<HMMDevice, String>)currentRow, resultDetail);
            } else if ("partSuccess".equals(nodeResult)) {
                this.refreshTableForPartSuccess(num, (TableRow<HMMDevice, String>)currentRow, resultDetail);
            } else {
                currentRow.setValueAt(num, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"dev_failed.png"), resultDetail.get("errMsg").toString()));
            }
        } else {
            currentRow.setValueAt(num, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"success.png"), CommonStatus.FINISHED.getTitle()));
        }
        return currentRow;
    }

    private void refreshTableForPartSuccess(int num, TableRow<HMMDevice, String> row, JSONObject resultDetail) {
        String partSuccessTip = ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.part.success");
        row.setValueAt(num, (Object)new IsmTableCell.IconCell((Icon)ResourceUtil.getImage((String)"partSuccess.png"), partSuccessTip));
        this.setResult(num, row, resultDetail);
    }

    private void setResult(int num, TableRow<HMMDevice, String> row, JSONObject resultDetail) {
        if (!resultDetail.has("msgType") || "simple".equals(resultDetail.getString("msgType"))) {
            this.setSimpleErrMsg(num, row, resultDetail);
        } else if ("table".equals(resultDetail.getString("msgType"))) {
            this.refreshDetailsOfFailedSlots(num, row, resultDetail);
        } else {
            log.warn("Unsupported error message type:" + resultDetail.getString("msgType") + ", raw message: " + resultDetail.get("errMsg"));
        }
    }

    private void setSimpleErrMsg(int num, TableRow<HMMDevice, String> row, JSONObject resultDetail) {
        String errMsg = "";
        if (resultDetail.has("errMsgZH") && resultDetail.has("errMsgEN")) {
            errMsg = LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? resultDetail.getString("errMsgZH") : resultDetail.getString("errMsgEN");
        } else {
            log.error("Incompatible json key, require:{} or {}", (Object)"errMsgZH", (Object)"errMsgEN");
        }
        row.setValueAt(num + 1, (Object)errMsg);
    }

    private void refreshDetailsOfFailedSlots(int num, TableRow<HMMDevice, String> row, JSONObject resultDetail) {
        JSONArray errMsgs = resultDetail.getJSONArray("errMsg");
        ArrayList<ArrayList<Object>> tableRows = new ArrayList<ArrayList<Object>>();
        this.addErrMsg(errMsgs, tableRows);
        this.refreshHyperLinkOnDetailLine(num, row, tableRows);
    }

    private void addErrMsg(JSONArray errMsgs, List<ArrayList<Object>> tableRows) {
        for (int i = 0; i < errMsgs.length(); ++i) {
            Object slotDetailObj = errMsgs.get(i);
            JSONObject slotDetail = new JSONObject();
            if (slotDetailObj instanceof JSONObject) {
                slotDetail = (JSONObject)slotDetailObj;
            }
            ArrayList<String> tableRow = new ArrayList<String>();
            if (slotDetail.has("objectIdZH") && slotDetail.has("objectIdEN")) {
                tableRow.add(LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? slotDetail.getString("objectIdZH") : slotDetail.getString("objectIdEN"));
            } else {
                log.error("Incompatible json key, require:{} or {}", (Object)"objectIdZH", (Object)"objectIdEN");
            }
            if (slotDetail.has("errMsgZH") && slotDetail.has("errMsgEN")) {
                tableRow.add(LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINESE) || LanguageManager.getInstance().getCurrentLanguage().equals(Locale.CHINA) ? slotDetail.getString("errMsgZH") : slotDetail.getString("errMsgEN"));
            } else {
                log.error("Incompatible json key, require:{} or {}", (Object)"errMsgZH", (Object)"errMsgEN");
            }
            tableRows.add(tableRow);
        }
    }

    private void refreshHyperLinkOnDetailLine(int num, TableRow<HMMDevice, String> row, List<ArrayList<Object>> tableRows) {
        IsmTableCell.HyperlinkCell viewDetails = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.viewdetail"), event -> {
            String[] headers = new String[]{ResourceUtil.getString((String)"partsuccess.header.slot"), ResourceUtil.getString((String)"partsuccess.header.suggestion")};
            int[] tableWidthRatio = new int[]{15, 300};
            SubDialogUtils.showMultiInfoDialog((List)tableRows, (MultiInfoDialogParams)MultiInfoDialogParams.getNewBuilder().setParent((Window)DeviceCenterContext.getInstance().getParent()).setInfoMsg(ResourceUtil.getString((String)"smartkit.devicemanager.layout.manage.info.batchimport.dialog.viewdetail.desc")).setTitles(headers).setPreferredDimension(new Dimension(550, 250)).setTableLinesWidth(tableWidthRatio).build());
        });
        row.setValueAt(num + 1, (Object)viewDetails);
    }

    private List<TableRow> getSelectHmmRows() {
        return this.deviceTable.getMarkedRows();
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
    }

    @Override
    public void deleteServiceDev() {
        List<TableRow> rows = this.getSelectHmmRows();
        SmartkitUtils.deleteSceneAddDialogHasedDevices(rows, this);
        for (TableRow row : rows) {
            this.getTableModel().removeRow(new TableRow[]{row});
            LogUtils.addImportLog("devicemanager.server.manager.layout.remove", ((HMMDevice)row.getUserObject()).getIp(), true, "");
            DeviceCenterContext.getInstance().getIbmcHmmOsDevs().remove(row.getUserObject());
            LayUtil.removeDevFromAllTableDevs((AbstractDevice)row.getUserObject());
        }
        DeviceCenterContext.getInstance().notifyDeviceObserver();
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
        this.repaint();
    }

    public void refreshDevicesInfo(HMMDevice dev) {
        ArrayList<HMMDevice> hmmDevList = new ArrayList<HMMDevice>();
        hmmDevList.add(dev);
        this.refresh(hmmDevList);
    }

    public void refreshDevicesInfo() {
        List<HMMDevice> hmmDevList = this.getSelectHmmDevs();
        this.refresh(hmmDevList);
    }

    private void refresh(List<HMMDevice> hmmDevs) {
        BatchImportInfoDialog importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"));
        this.hmmListenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
        SmartkitUtils.addBatchImportDialog(importDialog, this.hmmListenerTables);
        this.hwXlsDevs = new ArrayList<AbstractDevice>();
        for (HMMDevice dev : hmmDevs) {
            HwServerDevice xlsDev = dev.getHwServerDev();
            xlsDev.setStartIPAddress(dev.getIp());
            xlsDev.setEndIPAddress(dev.getIp());
            this.hwXlsDevs.add(dev.getHwServerDev());
        }
        Runnable refreshHmm = () -> {
            DeviceControl.getInstance().initDriverFile();
            this.result = DeviceControl.getInstance().importDevices(this.hwXlsDevs, this.hmmListenerTables);
            DeviceControl.getInstance().refreshFile();
            if (TaskResult.Result.SUCCESS.equals((Object)this.result.getResult())) {
                log.info("find the device success.");
            } else {
                log.info("find the device failed.");
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(refreshHmm);
        if (log.isInfoEnabled()) {
            log.info("the result of the task is: " + future.isDone());
        }
    }

    public void modifyDevicesInfo() {
        List<HMMDevice> hmmDevs = this.getSelectHmmDevs();
        if (hmmDevs.size() > 1) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.modifiy.oneOnly"));
            return;
        }
        HmmDeviceAddLayout lay = new HmmDeviceAddLayout(false);
        if (hmmDevs.isEmpty()) {
            return;
        }
        HwServerDevice hwServer = hmmDevs.get(0).getHwServerDev();
        this.initDeviceAddLayout(hwServer, lay);
        lay.getStartIpAddress().setText(LayUtil.filterItemInfo(hmmDevs.get(0).getIp()));
        lay.getEndIpField().setText(LayUtil.filterItemInfo(hmmDevs.get(0).getIp()));
        lay.getUserNameField().setText(LayUtil.filterItemInfo(hwServer.getUserName()));
        lay.getSnmpPortField().setText(LayUtil.filterItemInfo(hwServer.getSnmpPort() + ""));
        lay.getIpmiPortField().setText(LayUtil.filterItemInfo(hwServer.getIpmiPort() + ""));
        lay.getSshSfipPortField().setText(LayUtil.filterItemInfo(hwServer.getSshPort() + ""));
        lay.getVMPortField().setText(LayUtil.filterItemInfo(hwServer.getVmmPort() + ""));
        lay.getWriteCommunityPortField().setText(LayUtil.filterItemInfo(hwServer.getCommunity()));
        lay.getRedfishPortPortField().setText(LayUtil.filterItemInfo(hwServer.getRedFishPort()));
        this.initSwPlantContent(hwServer, lay);
        this.initComputeContent(hwServer, lay);
        hwServer.setItDeviceType(ITDeviceType.SERVER_HMM);
        HmmDeviceAddDialog addDialog = new HmmDeviceAddDialog(lay);
        if (hwServer.isBatchImport()) {
            addDialog.refreshCheckBoxNotSelectedForBatch();
        } else {
            addDialog.refreshCheckBoxNotSelected();
        }
        addDialog.refreshComputeNodeFieldEnable();
        hwServer.setStartIPAddress(hmmDevs.get(0).getIp());
        hwServer.setEndIPAddress(hmmDevs.get(0).getIp());
        addDialog.setDevInitHwServer(hwServer);
        SwingUtil.putParentCenter((Window)addDialog, (Window)DeviceCenterContext.getInstance().getParent());
        addDialog.setVisible(true);
    }

    private void initDeviceAddLayout(HwServerDevice hwServerDevice, HmmDeviceAddLayout lay) {
        if (!hwServerDevice.isApplyToOtherNodes()) {
            lay.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().setVisible(false);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getBottomCheckBoxFoldedComp().setVisible(false);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeLayout().setVisible(true);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getBottomCheckBoxUnFoldComp().setVisible(true);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getUseSameAllNodeCbx().setSelected(false);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getUseSameAllNodeCbox().setSelected(false);
        }
        lay.getStartIp().setText("IP:");
        lay.getSymbolLabel().setText("");
        lay.getStartIpAddress().setEnabled(false);
    }

    private void initComputeContent(HwServerDevice hwServer, HmmDeviceAddLayout lay) {
        List<ComputeNodePlate> nodePlate = hwServer.getComputeNodePlateList();
        if (null == nodePlate || 0 == nodePlate.size()) {
            return;
        }
        if (hwServer.isApplyToOtherNodes()) {
            String port = nodePlate.get(0).getSlotSSHPort() + "/" + nodePlate.get(0).getSlotSNMPPort() + "/" + nodePlate.get(0).getSlotHttpsPort() + "/" + nodePlate.get(0).getSlotIPMIPort();
            lay.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getPort().setText(port);
            lay.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeApplyToOtherPanel().getUserName().setText(nodePlate.get(0).getSlotUser());
        } else {
            Map<Integer, ComputeNodeEntity> nodeMap = lay.getComputeNodePanel().getHmmComputeNodePanel().getComputeNodeLayout().getComputeNodeContentLayout().getNodeEntityMap();
            for (ComputeNodePlate plate : nodePlate) {
                int slot = Integer.valueOf(plate.getSlotId());
                nodeMap.get(slot).getPort().setText(plate.getSlotSSHPort() + "/" + plate.getSlotSNMPPort() + "/" + plate.getSlotHttpsPort() + "/" + plate.getSlotIPMIPort());
                nodeMap.get(slot).getUserName().setText(plate.getSlotUser());
            }
        }
    }

    private void initSwPlantContent(HwServerDevice hwXlsServer, HmmDeviceAddLayout lay) {
        Map<String, SwitchPlate> switchPlateMap = hwXlsServer.getSwitchPlateMap();
        for (Map.Entry<String, SwitchPlate> entry : switchPlateMap.entrySet()) {
            String key = entry.getKey().replace("switch_plate", "");
            SwitchPlate swPlate = entry.getValue();
            HmmSwitchChoosePanel swChooseContent = lay.getSwPanel();
            Class<?> swContentClazz = swChooseContent.getClass();
            String getSwContentMethodName = "getSwContent" + key;
            try {
                Method getSwContentMethod = swContentClazz.getMethod(getSwContentMethodName, new Class[0]);
                SwitchChooseContentLayout swPlaneLay = (SwitchChooseContentLayout)getSwContentMethod.invoke((Object)swChooseContent, new Object[0]);
                swPlaneLay.getFbsolUserNameField().setText(swPlate.getFabricUserName());
                swPlaneLay.getBaseSolUserNameField().setText(swPlate.getBaseUserName());
                swPlaneLay.getFcSolUserNameField().setText(swPlate.getFcUserName());
                swPlaneLay.getBmcUserNameField().setText(swPlate.getBmcUserName());
            }
            catch (Exception e) {
                log.error("invoke error.init swPlant");
            }
        }
    }

    @Override
    public int getSelectNum() {
        return this.getDeviceTable().getSelectedRows().length;
    }

    public List<HMMDevice> getSelectHmmDevs() {
        ArrayList<HMMDevice> devList = new ArrayList<HMMDevice>();
        List rows = this.getDeviceTable().getMarkedRows();
        for (TableRow row : rows) {
            devList.add((HMMDevice)row.getUserObject());
        }
        return devList;
    }

    @Override
    public String getName() {
        return HMM_DIALOG;
    }

    @Override
    public void updateBtn() {
    }

    @Override
    public List<AbstractDevice> getCurrentNeedCheckPortDeviceList() {
        ArrayList<AbstractDevice> abstractDevices = new ArrayList<AbstractDevice>();
        for (HMMDevice hmmDevice : this.getSelectHmmDevs()) {
            HwServerDevice hwServerDev = hmmDevice.getHwServerDev();
            abstractDevices.add(hwServerDev);
            List<ServerComputeNode> serverComputeNodes = hmmDevice.getServerComputeNodes();
            for (ServerComputeNode serverComputeNode : serverComputeNodes) {
                HwServerDevice hwServerComputeNode = serverComputeNode.getHwServerDev();
                hwServerComputeNode.setStartIPAddress(serverComputeNode.getIp());
                hwServerComputeNode.setEndIPAddress(serverComputeNode.getIp());
                if (hwServerDev.isApplyToOtherNodes()) {
                    ComputeNodePlate computeNodePlate2 = hwServerDev.getComputeNodePlateList().get(0);
                    this.setSlotInfo(hwServerComputeNode, computeNodePlate2);
                    abstractDevices.add(hwServerComputeNode);
                    continue;
                }
                String slot = serverComputeNode.getSlot();
                hwServerDev.getComputeNodePlateList().stream().filter(computeNodePlate -> computeNodePlate.getSlotId().equals(slot)).findFirst().ifPresent(computeNodePlate -> this.setSlotInfo(hwServerComputeNode, (ComputeNodePlate)computeNodePlate));
                if (StringUtils.isNULLStr((String)hwServerComputeNode.getUserName()) && StringUtils.isNULLStr((String)hwServerComputeNode.getUserPwd())) {
                    hwServerComputeNode.setUserName(hwServerDev.getUserName());
                    hwServerComputeNode.setUserPwd(hwServerDev.getUserPwd());
                    hwServerComputeNode.setSnmpPrivPwd(hwServerDev.getSnmpPrivPwd());
                    hwServerComputeNode.setSshPort(Integer.parseInt(serverComputeNode.getSshPort()));
                    hwServerComputeNode.setSnmpPort(Integer.parseInt(serverComputeNode.getSnmpPort()));
                    hwServerComputeNode.setIpmiPort(Integer.parseInt(serverComputeNode.getIpmiPort()));
                }
                abstractDevices.add(hwServerComputeNode);
            }
        }
        return abstractDevices;
    }

    private void setSlotInfo(HwServerDevice hwServerComputeNode, ComputeNodePlate computeNodePlate) {
        hwServerComputeNode.setUserName(computeNodePlate.getSlotUser());
        hwServerComputeNode.setUserPwd(computeNodePlate.getSlotPasswd());
        hwServerComputeNode.setSnmpPrivPwd(computeNodePlate.getSlotSnmpPrivPwd());
        hwServerComputeNode.setSshPort(Integer.parseInt(computeNodePlate.getSlotSSHPort()));
        hwServerComputeNode.setSnmpPort(Integer.parseInt(computeNodePlate.getSlotSNMPPort()));
        hwServerComputeNode.setIpmiPort(Integer.parseInt(computeNodePlate.getSlotIPMIPort()));
        hwServerComputeNode.setRedFishPort(computeNodePlate.getSlotHttpsPort());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public void setDeviceTable(IsmTable deviceTable) {
        this.deviceTable = deviceTable;
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public SerDeviTitleLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(SerDeviTitleLabel titleLabel) {
        this.titleLabel = titleLabel;
    }
}

