/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.IESDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.HmmDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HmmDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.OsDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.LogUtils;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IesTablePanel
extends JPanel
implements IImportListener,
UpdateBtnServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(IesTablePanel.class);
    private static final String IP_COLON = "IP:";
    private SerDeviTitleLabel titleLabel;
    private List<IImportListener> atlasListenerTables;
    private List<AbstractDevice> hwXlsDevs;
    private TaskResult result;
    private String[] cmcTableHeader = new String[]{ResourceUtil.getString((String)"devicecenter.ismtable.header.atlas.hostname"), ResourceUtil.getString((String)"devicecenter.ismtable.header.atlas.productname"), ResourceUtil.getString((String)"devicecenter.ismtable.header.atlas.snno"), ResourceUtil.getString((String)"devicecenter.ismtable.header.atlas.iesip"), ResourceUtil.getString((String)"devicecenter.ismtable.header.atlas.version")};
    private IsmTable deviceTable;
    private DefaultTableModel tableModel = new DefaultTableModel(this.cmcTableHeader, new int[0]);

    public IesTablePanel() {
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        TableScrollPane scrollPanel = new TableScrollPane(this.deviceTable, false, false, true);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.setBackground(Color.WHITE);
    }

    @Override
    public void finishedImport(TotalDriverResult totalDriverResult) {
        log.info("IES table finishedImport");
    }

    @Override
    public void startCheckImportDevice(List<String> serverIpList) {
        log.info("IES table startCheckImportDevice");
    }

    @Override
    public void refreshProcess(TotalDriverResult totalDriverResult) {
        log.info("IES table refreshProcess");
    }

    @Override
    public void dealWithException(String mesage) {
        log.info("IES table dealWithException");
    }

    @Override
    public void refreshTable(List<AbstractDevice> abstractDevices) {
        List<AbstractDevice> tableShouldRefreshDevices = LayUtil.getTableShouldRefreshDevices(this.tableModel, abstractDevices);
        DeviceCenterContext.getInstance().setIbmcHmmOsDevs(tableShouldRefreshDevices);
        LayUtil.getTableExistedDevices(this.tableModel);
        LayUtil.clearTable(this.tableModel);
        for (AbstractDevice device : tableShouldRefreshDevices) {
            if (!(device instanceof IESDevice) || !device.getItDeviceType().equals((Object)ITDeviceType.IES)) continue;
            this.tableModel.addRow(new TableRow[]{this.createIESRow((IESDevice)device)});
        }
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
    }

    private TableRow<IESDevice, String> createIESRow(IESDevice iesDevice) {
        DefaultTableRow currentRow = new DefaultTableRow(this.cmcTableHeader.length, (Object)iesDevice, (Object)iesDevice.getIp());
        int colNum = 0;
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(iesDevice.getHostName()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(iesDevice.getProductName()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(iesDevice.getSnNo()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(iesDevice.getIp()));
        currentRow.setValueAt(colNum++, (Object)LayUtil.createTextCell(iesDevice.getVersion()));
        return currentRow;
    }

    @Override
    public void deleteServiceDev() {
        List rows = this.deviceTable.getMarkedRows();
        SmartkitUtils.deleteSceneAddDialogHasedDevices(rows, this);
        for (TableRow row : rows) {
            this.getTableModel().removeRow(new TableRow[]{row});
            LogUtils.addImportLog("devicemanager.server.manager.layout.remove", ((IESDevice)row.getUserObject()).getIp(), true, "");
            DeviceCenterContext.getInstance().getIbmcHmmOsDevs().remove(row.getUserObject());
            LayUtil.removeDevFromAllTableDevs((AbstractDevice)row.getUserObject());
        }
        DeviceCenterContext.getInstance().notifyDeviceObserver();
        if (this.titleLabel != null) {
            this.titleLabel.setDevNum(this.getDeviceTable().getAllRows().size());
        }
        this.repaint();
    }

    public void modifyDevicesInfo() {
        List<IESDevice> iesDevices = this.getSelectIesDevices();
        if (iesDevices.isEmpty()) {
            return;
        }
        if (iesDevices.size() > 1) {
            DialogUtils.showInfoDialog((Frame)DeviceCenterContext.getInstance().getParent(), (String)ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.modifiy.oneOnly"));
            return;
        }
        IESDevice seleceDev = iesDevices.get(0);
        HmmDeviceAddDialog dialog = this.createModifyLayout(seleceDev);
        SwingUtil.putParentCenter((Window)dialog, (Window)DeviceCenterContext.getInstance().getParent());
        dialog.setVisible(true);
    }

    private HmmDeviceAddDialog createModifyLayout(IESDevice seleceDev) {
        HwServerDevice hwServer = seleceDev.getHwServerDev();
        hwServer.setItDeviceType(seleceDev.getItDeviceType());
        hwServer.setStartIPAddress(seleceDev.getIp());
        hwServer.setEndIPAddress(seleceDev.getIp());
        hwServer.setItDeviceType(ITDeviceType.SERVER_HMM);
        HmmDeviceAddLayout layout = new HmmDeviceAddLayout(false);
        layout.getStartIp().setText(IP_COLON);
        layout.getSymbolLabel().setText("");
        layout.getStartIpAddress().setEnabled(false);
        layout.getStartIpAddress().setText(LayUtil.filterItemInfo(seleceDev.getIp()));
        layout.getEndIpField().setText(LayUtil.filterItemInfo(seleceDev.getIp()));
        layout.getUserNameField().setText(LayUtil.filterItemInfo(hwServer.getUserName()));
        layout.getSnmpPortField().setText(LayUtil.filterItemInfo(hwServer.getSnmpPort() + ""));
        layout.getIpmiPortField().setText(LayUtil.filterItemInfo(hwServer.getIpmiPort() + ""));
        layout.getSshSfipPortField().setText(LayUtil.filterItemInfo(hwServer.getSshPort() + ""));
        layout.getVMPortField().setText(LayUtil.filterItemInfo(hwServer.getVmmPort() + ""));
        layout.getRedfishPortPortField().setText(LayUtil.filterItemInfo(hwServer.getRedFishPort()));
        layout.getDecouplingSelectRadioBtn().setSelected(hwServer.isSupportAccountSeparation());
        layout.getRedFishUserNameTextField().setText(LayUtil.filterItemInfo(hwServer.getRedFishUserName()));
        if (hwServer.isSupportAccountSeparation()) {
            layout.getRedFishContent().setVisible(true);
        } else {
            layout.getRedFishContent().setVisible(false);
        }
        HmmDeviceAddDialog addDialog = new HmmDeviceAddDialog(layout);
        addDialog.hideSwComputePanel();
        addDialog.setDevInitHwServer(hwServer);
        return addDialog;
    }

    private OsDeviceAddLayout buildOsDeviceAddLayout(IESDevice seleceDev, HwServerDevice hwServer) {
        OsDeviceAddLayout iesModifyLayout = new OsDeviceAddLayout(false, true);
        iesModifyLayout.getStartIp().setText(IP_COLON);
        iesModifyLayout.getSymbolLabel().setText("");
        iesModifyLayout.getStartIpAddress().setEnabled(false);
        iesModifyLayout.getEndIpLabel().setVisible(false);
        iesModifyLayout.getEndIpField().setVisible(false);
        iesModifyLayout.getStartIpAddress().setText(LayUtil.filterItemInfo(seleceDev.getIp()));
        iesModifyLayout.getEndIpField().setText(LayUtil.filterItemInfo(seleceDev.getIp()));
        iesModifyLayout.getUserNameField().setText(LayUtil.filterItemInfo(hwServer.getUserName()));
        iesModifyLayout.getPwdField().setText(LayUtil.filterItemInfo(hwServer.getUserPwd()));
        iesModifyLayout.getRootPwdField().setText(LayUtil.filterItemInfo(hwServer.getRootPwd()));
        return iesModifyLayout;
    }

    @Override
    public int getSelectNum() {
        return this.getDeviceTable().getSelectedRows().length;
    }

    public List<IESDevice> getSelectIesDevices() {
        ArrayList<IESDevice> devList = new ArrayList<IESDevice>();
        List rows = this.getDeviceTable().getMarkedRows();
        for (TableRow row : rows) {
            if (!(row.getUserObject() instanceof IESDevice)) continue;
            devList.add((IESDevice)row.getUserObject());
        }
        return devList;
    }

    public void refreshDevicesInfo() {
        List<IESDevice> iesDevices = this.getSelectIesDevices();
        BatchImportInfoDialog importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"smartkit.devicemanager.layout.device.refresh.dialogTitle"));
        this.atlasListenerTables = DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");
        SmartkitUtils.addBatchImportDialog(importDialog, this.atlasListenerTables);
        this.hwXlsDevs = new ArrayList<AbstractDevice>();
        for (IESDevice dev : iesDevices) {
            HwServerDevice xlsDev = dev.getHwServerDev();
            xlsDev.setStartIPAddress(dev.getIp());
            xlsDev.setEndIPAddress(dev.getIp());
            this.hwXlsDevs.add(xlsDev);
        }
        Runnable refeshIesDev = new Runnable(){

            @Override
            public void run() {
                DeviceControl.getInstance().initDriverFile();
                IesTablePanel.this.result = DeviceControl.getInstance().importDevices(IesTablePanel.this.hwXlsDevs, IesTablePanel.this.atlasListenerTables);
                DeviceControl.getInstance().refreshFile();
                log.info("find the device result = {}", (Object)IesTablePanel.this.result.getResult());
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(refeshIesDev);
        log.info("the result of the task is: {}", (Object)future.isDone());
    }

    @Override
    public void updateBtn() {
        log.info("IES table updateBtn");
    }

    @Override
    public List<AbstractDevice> getCurrentNeedCheckPortDeviceList() {
        return Collections.emptyList();
    }

    public void setTitleLabel(SerDeviTitleLabel titleLabel) {
        this.titleLabel = titleLabel;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    @Override
    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }
}

