/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.ui.dialog.layout;

import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.utils.DeviceAliasMapper;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.listener.CheckPortListener;
import com.huawei.ism.tool.devicecenter.listener.CheckSelectedDevicesPortListener;
import com.huawei.ism.tool.devicecenter.listener.CmcLabelListener;
import com.huawei.ism.tool.devicecenter.listener.DeleteListener;
import com.huawei.ism.tool.devicecenter.listener.ExcelListener;
import com.huawei.ism.tool.devicecenter.listener.HmmLabelListener;
import com.huawei.ism.tool.devicecenter.listener.IbmcLabelListener;
import com.huawei.ism.tool.devicecenter.listener.IesLabelListener;
import com.huawei.ism.tool.devicecenter.listener.ImportListener;
import com.huawei.ism.tool.devicecenter.listener.ModifyListener;
import com.huawei.ism.tool.devicecenter.listener.OsLabelListener;
import com.huawei.ism.tool.devicecenter.listener.RefreshListener;
import com.huawei.ism.tool.devicecenter.listener.SnWhiteListEnableListener;
import com.huawei.ism.tool.devicecenter.listener.SwitchLabelListener;
import com.huawei.ism.tool.devicecenter.listener.TceLabelListener;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.service.UpdateBtnServiceInterface;
import com.huawei.ism.tool.devicecenter.ui.SerDeviTitleLabel;
import com.huawei.ism.tool.devicecenter.ui.dialog.DevWhiteListDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.CMCTablePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.HMMTablePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.IBMCTablePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.IesTablePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.OSTablePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.SWITCHTablePanel;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.TceTablePanel;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import org.apache.commons.lang3.SystemUtils;

public class ServerManagerLayout
extends JPanel
implements UpdateBtnServiceInterface {
    private static final Dimension LABEL_SIZE = SystemUtils.IS_OS_WINDOWS ? new Dimension(60, 35) : new Dimension(30, 35);
    private static final Dimension WIDE_LABEL_SIZE = SystemUtils.IS_OS_WINDOWS ? new Dimension(120, 35) : new Dimension(40, 35);
    private static final int TITLE_FONT = SystemUtils.IS_OS_WINDOWS ? 16 : 12;
    private static final String SWITCH_FONT = "PingFangSC-Regular";
    private static final Color COLOR_GRAY = new Color(153, 153, 153);
    private static final Color COLOR_BLUE = new Color(73, 157, 242);
    private static final String REFRESH_LABEL_NAME = "refresh";
    private static final String DELETE_LABEL_NAME = "delete";
    private static final String BATCH_PORTS_CHECK_LABEL_NAME = "check";
    private static final String IMPORT_LABEL_NAME = "import";
    private static final String EXCEL_LABEL_NAME = "excel";
    private static final long serialVersionUID = 3544465405070954772L;
    private SerDeviTitleLabel ibmcLabel = null;
    private SerDeviTitleLabel switchLabel = null;
    private SerDeviTitleLabel hmmLabel = null;
    private SerDeviTitleLabel osLabel = null;
    private SerDeviTitleLabel cmcLabel = null;
    private SerDeviTitleLabel iesLabel = null;
    private SerDeviTitleLabel tceLabel = null;
    private JButton deleteBtn = new JButton();
    private JButton checkPortBtn = new JButton();
    private JButton refreshBtn = new JButton();
    private JButton addBtn = new JButton();
    private JButton modifyBtn = new JButton();
    private JButton importBtn = new JButton();
    private JButton batchPortsCheckBtn = new JButton();
    private ToolHyperLinkLabel excelHyperLink = new ToolHyperLinkLabel();
    private JPanel cardPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private JButton snWhiteListConfigBtn = new JButton();
    private JCheckBox snWhiteListEnableBox = new JCheckBox();
    private DevWhiteListDialog devWhiteListDialog;
    private HMMTablePanel hmmTable = new HMMTablePanel();
    private SWITCHTablePanel switchTable = new SWITCHTablePanel();
    private IBMCTablePanel ibmcTable = new IBMCTablePanel();
    private OSTablePanel osTable = new OSTablePanel();
    private CMCTablePanel cmcTable = new CMCTablePanel();
    private IesTablePanel atlasTable = new IesTablePanel();
    private TceTablePanel tceTable = new TceTablePanel();
    TableScrollPane ibmcScrollPane = null;
    TableScrollPane hmmScrollPane = null;
    TableScrollPane osScrollPane = null;
    TableScrollPane cmcScrollPane = null;
    TableScrollPane iesScrollPane = null;
    TableScrollPane tceScrollPanel = null;
    TableScrollPane switchScrollPanel = null;
    private List<SerDeviTitleLabel> switchDevLabels = new ArrayList<SerDeviTitleLabel>();
    private List<JLabel> labelList = new ArrayList<JLabel>();
    private List<IImportListener> importListener = new ArrayList<IImportListener>();
    private Map<String, Boolean> ibmcHmmOsShowMap = new HashMap<String, Boolean>();
    private boolean sceneFlag = false;
    private boolean isAddDevFlag = false;
    private boolean singleChooseFlag = false;

    public ServerManagerLayout(boolean isSceneFlag, Map<String, Boolean> labelShowMap, boolean flag) {
        this.ibmcHmmOsShowMap = labelShowMap;
        this.singleChooseFlag = !flag;
        this.sceneFlag = isSceneFlag;
        this.isAddDevFlag = true;
        this.initManageLayout();
    }

    public void refreshSceneAddDevice() {
        if (this.sceneFlag) {
            ArrayList<JPanel> sceneAddTableListener = new ArrayList<JPanel>();
            sceneAddTableListener.add(this.getHmmTable());
            sceneAddTableListener.add(this.getIbmcTable());
            sceneAddTableListener.add(this.getOsTable());
            sceneAddTableListener.add(this.getCmcTable());
            sceneAddTableListener.add(this.getAtlasTable());
            sceneAddTableListener.add(this.getTceTable());
            sceneAddTableListener.add(this.getSwitchTable());
            DeviceCenterContext.getInstance().getSceneDeviceTables().put("sceneTables", sceneAddTableListener);
            for (IImportListener iImportListener : sceneAddTableListener) {
                iImportListener.refreshTable(DeviceCenterContext.getInstance().getIbmcHmmOsDevs());
            }
        }
    }

    public void refreshDevice() {
        Arrays.asList(this.hmmTable, this.switchTable, this.ibmcTable, this.osTable, this.cmcTable, this.atlasTable, this.tceTable).forEach(table -> ((IImportListener)((Object)table)).refreshTable(DeviceCenterContext.getInstance().getIbmcHmmOsDevs()));
    }

    public ServerManagerLayout(boolean isSceneFlag) {
        this.sceneFlag = isSceneFlag;
        this.importListener.clear();
        this.importListener.add(this.getHmmTable());
        this.importListener.add(this.getIbmcTable());
        this.importListener.add(this.getOsTable());
        this.importListener.add(this.getCmcTable());
        this.importListener.add(this.getAtlasTable());
        this.importListener.add(this.getTceTable());
        this.importListener.add(this.getSwitchTable());
        DeviceCenterContext.getInstance().getDeviceTables().put("deviceTables", this.importListener);
        this.initManageLayout();
        if (!this.importListener.isEmpty()) {
            for (IImportListener listener : this.importListener) {
                listener.refreshTable(DeviceCenterContext.getInstance().getIbmcHmmOsDevs());
            }
        }
    }

    private void initManageLayout() {
        this.initUI();
        this.initLayout();
        this.initListener();
        this.setBackground(Color.WHITE);
        this.initLayoutBySceneFlag();
        this.refreshDevice();
    }

    private void initLayoutBySceneFlag() {
        if (this.sceneFlag) {
            this.modifyBtn.setVisible(false);
            this.deleteBtn.setVisible(false);
            this.refreshBtn.setVisible(false);
            this.checkPortBtn.setVisible(false);
            this.batchPortsCheckBtn.setVisible(false);
            this.importBtn.setVisible(false);
            this.excelHyperLink.setVisible(false);
            this.snWhiteListConfigBtn.setVisible(false);
            this.snWhiteListEnableBox.setVisible(false);
        }
    }

    public void initUI() {
        this.ibmcLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.ibmc"), 0);
        this.hmmLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.hmm"), 0);
        this.osLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.os"), 0);
        this.cmcLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.cmc"), 0);
        this.iesLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.atlas"), 0);
        this.tceLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.tce"), 0);
        this.switchLabel = new SerDeviTitleLabel(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.switch"), 0);
        this.devWhiteListDialog = new DevWhiteListDialog((Window)DeviceCenterContext.getInstance().getParent(), ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.white"));
        this.devWhiteListDialog.setSaveCallBack(event -> this.refreshDevice());
        this.devWhiteListDialog.setVisible(false);
        this.excelHyperLink.setIcon((Icon)ResourceUtil.getImage((String)"device_down_template.png"));
        this.excelHyperLink.setText(ResourceUtil.getString((String)"devicecenter.layout.device.import.downloadtemplate"));
        this.initLabelList();
        this.initName();
        this.initLabelSize(LABEL_SIZE, this.ibmcLabel, this.hmmLabel, this.osLabel, this.cmcLabel, this.iesLabel);
        this.initLabelSize(WIDE_LABEL_SIZE, this.tceLabel, this.switchLabel);
        this.initTitleFont(this.ibmcLabel, this.hmmLabel, this.osLabel, this.cmcLabel, this.iesLabel, this.tceLabel, this.switchLabel);
        this.setLabelBorder(this.ibmcLabel);
        this.hmmTable.setTitleLabel(this.hmmLabel);
        this.ibmcTable.setTitleLabel(this.ibmcLabel);
        this.osTable.setTitleLabel(this.osLabel);
        this.cmcTable.setTitleLabel(this.cmcLabel);
        this.atlasTable.setTitleLabel(this.iesLabel);
        this.tceTable.setTitleLabel(this.tceLabel);
        this.switchTable.setTitleLabel(this.switchLabel);
        this.initBtn();
    }

    private void initBtn() {
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.delete"));
        this.deleteBtn.setIcon(ResourceUtil.getImage((String)"removeDev.png"));
        this.deleteBtn.setName("serverDeleteBtn");
        this.checkPortBtn.setEnabled(false);
        this.checkPortBtn.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.check.port"));
        this.checkPortBtn.setName("serverCheckPortBtn");
        this.snWhiteListConfigBtn.setEnabled(true);
        this.snWhiteListConfigBtn.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.white"));
        this.snWhiteListConfigBtn.setName("serverWhiteListBtn");
        this.snWhiteListEnableBox.setText(ResourceUtil.getString((String)"devicecenter.ismtable.header.white.checkbox.label"));
        this.snWhiteListEnableBox.setSelected(DeviceCenterContext.isEnableWhiteList());
        this.snWhiteListEnableBox.setToolTipText(ResourceUtil.getString((String)"devicecenter.ismtable.header.white.checkbox.label.tip"));
        this.refreshBtn.setEnabled(false);
        this.refreshBtn.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.refresh"));
        this.refreshBtn.setIcon(ResourceUtil.getImage((String)"update.png"));
        this.refreshBtn.setName("serverRefreshBtn");
        this.addBtn.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.add"));
        this.addBtn.setIcon(ResourceUtil.getImage((String)"addServeDevice.png"));
        this.addBtn.setName("serverAddBtn");
        this.modifyBtn.setEnabled(false);
        this.modifyBtn.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.modify"));
        this.modifyBtn.setIcon(ResourceUtil.getImage((String)"changeDevInfo.png"));
        this.modifyBtn.setName("serverModifyBtn");
        this.batchPortsCheckBtn.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.import.check.port"));
        this.batchPortsCheckBtn.setIcon(ResourceUtil.getImage((String)"batchImport.png"));
        this.batchPortsCheckBtn.setName("serverImportCheckPortBtn");
        this.importBtn.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.import"));
        this.importBtn.setIcon(ResourceUtil.getImage((String)"batchImport.png"));
        this.importBtn.setName("serverImportBtn");
        this.excelHyperLink.setText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.excel"));
        this.excelHyperLink.setIcon((Icon)ResourceUtil.getImage((String)"getExcelModel.png"));
        this.excelHyperLink.setName("serverGetExcelModelLink");
        this.excelHyperLink.setToolTipText(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.excel"));
    }

    private JComponent buildServerHBox(int compMargin, Component ... components) {
        JPanel box = UCD.createBoxLayoutPane((int)0);
        Component component = null;
        for (int i = 0; i < components.length; ++i) {
            component = components[i];
            String key = "";
            if (component instanceof JLabel) {
                JLabel s = (JLabel)component;
                key = s.getText().toLowerCase(Locale.ENGLISH);
                if (!this.ibmcHmmOsShowMap.containsKey(DeviceAliasMapper.getDeviceIdByAlias(key))) continue;
                if (this.ibmcHmmOsShowMap.get(DeviceAliasMapper.getDeviceIdByAlias(key)).booleanValue()) {
                    box.add(component);
                }
            } else {
                box.add(component);
            }
            if (i >= components.length - 1) continue;
            box.add(Box.createHorizontalStrut(compMargin));
        }
        return box;
    }

    private JComponent layByScene() {
        JComponent labelComp = null;
        if (this.sceneFlag) {
            this.initScrollPanelSceneFlagTrue();
            labelComp = this.createLabelComp();
            this.cardPanel.setLayout(this.cardLayout);
            boolean isSelectFlag = false;
            boolean hasIbmcFlag = false;
            this.setLabelBorderBySelect(isSelectFlag, hasIbmcFlag);
        } else {
            this.initScrollPanelSceneFlagFalse();
            labelComp = UCD.buildHorizotalBox(null, (int)12, (Component[])new Component[]{this.ibmcLabel, this.hmmLabel, this.osLabel, this.cmcLabel, this.iesLabel, this.tceLabel, this.switchLabel, Box.createHorizontalGlue(), UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxRight((Component[])new Component[]{this.batchPortsCheckBtn, this.addBtn, this.importBtn, this.excelHyperLink})})});
            this.addCardPanel();
        }
        return labelComp;
    }

    private void setLabelBorderBySelect(boolean isSelectFlag, boolean hasIbmcFlag) {
        boolean actualIbmcFlag = hasIbmcFlag;
        if (this.ibmcHmmOsShowMap.containsKey("ibmc")) {
            actualIbmcFlag = true;
            this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.ibmc"), (Component)this.ibmcScrollPane);
        }
        boolean actualSelectFlag = isSelectFlag;
        if (this.ibmcHmmOsShowMap.containsKey("hmm")) {
            if (!actualSelectFlag && !actualIbmcFlag) {
                this.setLabelBorder(this.hmmLabel);
                actualSelectFlag = true;
            }
            this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.hmm"), (Component)this.hmmScrollPane);
        }
        if (this.ibmcHmmOsShowMap.containsKey("os")) {
            if (!actualSelectFlag && !actualIbmcFlag) {
                this.setLabelBorder(this.osLabel);
                actualSelectFlag = true;
            }
            this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.os"), (Component)this.osScrollPane);
        }
        if (this.ibmcHmmOsShowMap.containsKey("cmc")) {
            if (!actualSelectFlag && !actualIbmcFlag) {
                this.setLabelBorder(this.cmcLabel);
                actualSelectFlag = true;
            }
            this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.cmc"), (Component)this.cmcScrollPane);
        }
        if (this.ibmcHmmOsShowMap.containsKey("ies")) {
            if (!actualSelectFlag && !actualIbmcFlag) {
                this.setLabelBorder(this.iesLabel);
                actualSelectFlag = true;
            }
            this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.atlas"), (Component)this.iesScrollPane);
        }
        if (DeviceAliasMapper.TCE.hasMatchedAlias(this.ibmcHmmOsShowMap.keySet())) {
            if (!actualSelectFlag && !actualIbmcFlag) {
                this.setLabelBorder(this.tceLabel);
                actualSelectFlag = true;
            }
            this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.tce"), (Component)this.tceScrollPanel);
        }
        this.setSwitchBoard(actualSelectFlag, actualIbmcFlag);
    }

    private void setSwitchBoard(boolean isSelectFlag, boolean hasIbmcFlag) {
        if (DeviceAliasMapper.SWITCH.hasMatchedAlias(this.ibmcHmmOsShowMap.keySet())) {
            if (!isSelectFlag && !hasIbmcFlag) {
                this.setLabelBorder(this.switchLabel);
            }
            this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.switch"), (Component)this.switchScrollPanel);
        }
    }

    private void initScrollPanelSceneFlagTrue() {
        this.ibmcScrollPane = new TableScrollPane(this.ibmcTable.getDeviceTable(), true, this.singleChooseFlag);
        this.hmmScrollPane = new TableScrollPane(this.hmmTable.getDeviceTable(), true, this.singleChooseFlag);
        this.osScrollPane = new TableScrollPane(this.osTable.getDeviceTable(), true, this.singleChooseFlag);
        this.cmcScrollPane = new TableScrollPane(this.cmcTable.getDeviceTable(), true, this.singleChooseFlag);
        this.iesScrollPane = new TableScrollPane(this.atlasTable.getDeviceTable(), true, this.singleChooseFlag);
        this.tceScrollPanel = new TableScrollPane(this.tceTable.getDeviceTable(), true, this.singleChooseFlag);
        this.switchScrollPanel = new TableScrollPane(this.switchTable.getDeviceTable(), true, this.singleChooseFlag);
    }

    private void initScrollPanelSceneFlagFalse() {
        this.ibmcScrollPane = new TableScrollPane(this.ibmcTable.getDeviceTable(), true, true);
        this.hmmScrollPane = new TableScrollPane(this.hmmTable.getDeviceTable(), true, true);
        this.osScrollPane = new TableScrollPane(this.osTable.getDeviceTable(), true, true);
        this.cmcScrollPane = new TableScrollPane(this.cmcTable.getDeviceTable(), true, true);
        this.iesScrollPane = new TableScrollPane(this.atlasTable.getDeviceTable(), true, true);
        this.tceScrollPanel = new TableScrollPane(this.tceTable.getDeviceTable(), true, true);
        this.switchScrollPanel = new TableScrollPane(this.switchTable.getDeviceTable(), true, true);
    }

    private void addCardPanel() {
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.ibmc"), (Component)this.ibmcScrollPane);
        this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.hmm"), (Component)this.hmmScrollPane);
        this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.os"), (Component)this.osScrollPane);
        this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.cmc"), (Component)this.cmcScrollPane);
        this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.atlas"), (Component)this.iesScrollPane);
        this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.tce"), (Component)this.tceScrollPanel);
        this.cardPanel.add(ResourceUtil.getString((String)"devicecenter.server.manager.layout.label.switch"), (Component)this.switchScrollPanel);
    }

    private JComponent createLabelComp() {
        JComponent labelComp = this.isAddDevFlag ? this.buildServerHBox(12, this.ibmcLabel, this.hmmLabel, this.osLabel, this.cmcLabel, this.iesLabel, this.tceLabel, this.switchLabel, Box.createHorizontalGlue(), UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxRight((Component[])new Component[]{this.batchPortsCheckBtn, this.addBtn, this.importBtn, this.excelHyperLink})})) : this.buildServerHBox(12, this.ibmcLabel, this.hmmLabel, this.osLabel, this.cmcLabel, this.iesLabel, this.tceLabel, this.switchLabel, Box.createHorizontalStrut(90), UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxRight((Component[])new Component[]{this.batchPortsCheckBtn, this.addBtn, this.importBtn, this.excelHyperLink})}), Box.createHorizontalGlue());
        return labelComp;
    }

    private void initLayout() {
        JComponent labelComp = this.layByScene();
        labelComp.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, COLOR_GRAY));
        JComponent gap = (JComponent)Box.createHorizontalGlue();
        gap.setBorder(BorderFactory.createLineBorder(Color.RED));
        JComponent operateComp = UCD.buildHorizotalBox(null, (int)4, (Component[])new Component[]{this.modifyBtn, this.deleteBtn, this.refreshBtn, this.checkPortBtn, gap, UCD.buildHBoxRight((Component[])new Component[]{this.snWhiteListConfigBtn, this.snWhiteListEnableBox})});
        JComponent verticalComp = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{labelComp, operateComp});
        this.setLayout(new BorderLayout());
        this.add((Component)verticalComp, "North");
        this.add((Component)this.cardPanel, "Center");
        if (!this.sceneFlag) {
            Component comp = Box.createVerticalStrut(15);
            this.add(comp, "South");
        }
    }

    @Override
    public void updateBtn() {
        UpdateBtnServiceInterface curTable = null;
        int curSelectDevNum = 0;
        for (SerDeviTitleLabel deleteLabel : this.switchDevLabels) {
            if (!deleteLabel.isSelect()) continue;
            curTable = deleteLabel.getCurTable();
            curSelectDevNum = curTable.getSelectNum();
            UpdateBtnServiceInterface curLabel = deleteLabel.getCurTable();
            boolean enableWhiteList = !this.sceneFlag && (curLabel instanceof IBMCTablePanel || curLabel instanceof IesTablePanel || curLabel instanceof OSTablePanel);
            this.snWhiteListConfigBtn.setVisible(enableWhiteList);
            this.snWhiteListEnableBox.setVisible(enableWhiteList);
        }
        if (curSelectDevNum > 0) {
            this.deleteBtn.setEnabled(true);
            this.refreshBtn.setEnabled(true);
            if (1 == curSelectDevNum) {
                this.modifyBtn.setEnabled(true);
            } else {
                this.modifyBtn.setEnabled(false);
            }
            this.checkPortBtn.setEnabled(true);
        } else {
            this.deleteBtn.setEnabled(false);
            this.refreshBtn.setEnabled(false);
            this.modifyBtn.setEnabled(false);
            this.checkPortBtn.setEnabled(false);
        }
    }

    @Override
    public List<AbstractDevice> getCurrentNeedCheckPortDeviceList() {
        return Collections.emptyList();
    }

    private void initLabelList() {
        this.labelList.clear();
        this.labelList.add(this.ibmcLabel);
        this.labelList.add(this.hmmLabel);
        this.labelList.add(this.osLabel);
        this.labelList.add(this.cmcLabel);
        this.labelList.add(this.iesLabel);
        this.labelList.add(this.tceLabel);
        this.labelList.add(this.switchLabel);
    }

    private void initName() {
        this.deleteBtn.setName(DELETE_LABEL_NAME);
        this.refreshBtn.setName(REFRESH_LABEL_NAME);
        this.batchPortsCheckBtn.setName(BATCH_PORTS_CHECK_LABEL_NAME);
        this.importBtn.setName(IMPORT_LABEL_NAME);
        this.excelHyperLink.setName(EXCEL_LABEL_NAME);
    }

    private void initLabelSize(Dimension sizeDemension, JLabel ... labels) {
        for (JLabel label : labels) {
            label.setPreferredSize(sizeDemension);
            label.setMaximumSize(sizeDemension);
            label.setMinimumSize(sizeDemension);
            label.setHorizontalTextPosition(0);
            label.setHorizontalAlignment(0);
        }
    }

    private void setLabelBorder(SerDeviTitleLabel label) {
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, COLOR_BLUE));
        label.setSelect(true);
    }

    private void initTitleFont(JLabel ... labels) {
        for (JLabel label : labels) {
            Font font = new Font(SWITCH_FONT, 0, TITLE_FONT);
            label.setFont(font);
        }
    }

    private void initListener() {
        this.ibmcLabel.addMouseListener(new IbmcLabelListener(this.cardPanel, this.cardLayout, this.labelList, this));
        this.hmmLabel.addMouseListener(new HmmLabelListener(this.cardPanel, this.cardLayout, this.labelList, this));
        this.osLabel.addMouseListener(new OsLabelListener(this.cardPanel, this.cardLayout, this.labelList, this));
        this.cmcLabel.addMouseListener(new CmcLabelListener(this.cardPanel, this.cardLayout, this.labelList, this));
        this.iesLabel.addMouseListener(new IesLabelListener(this.cardPanel, this.cardLayout, this.labelList, this));
        this.tceLabel.addMouseListener(new TceLabelListener(this.cardPanel, this.cardLayout, this.labelList, this));
        this.switchLabel.addMouseListener(new SwitchLabelListener(this.cardPanel, this.cardLayout, this.labelList, this));
        this.ibmcLabel.setCurTable(this.ibmcTable);
        this.hmmLabel.setCurTable(this.hmmTable);
        this.osLabel.setCurTable(this.osTable);
        this.cmcLabel.setCurTable(this.cmcTable);
        this.iesLabel.setCurTable(this.atlasTable);
        this.tceLabel.setCurTable(this.tceTable);
        this.switchLabel.setCurTable(this.switchTable);
        this.switchDevLabels.add(this.ibmcLabel);
        this.switchDevLabels.add(this.hmmLabel);
        this.switchDevLabels.add(this.osLabel);
        this.switchDevLabels.add(this.cmcLabel);
        this.switchDevLabels.add(this.iesLabel);
        this.switchDevLabels.add(this.tceLabel);
        this.switchDevLabels.add(this.switchLabel);
        this.deleteBtn.addActionListener(new DeleteListener(this.switchDevLabels));
        this.refreshBtn.addActionListener(new RefreshListener(this.switchDevLabels));
        this.modifyBtn.addActionListener(new ModifyListener(this.switchDevLabels));
        this.checkPortBtn.addActionListener(new CheckSelectedDevicesPortListener(this.switchDevLabels));
        this.snWhiteListConfigBtn.addActionListener(e -> {
            this.devWhiteListDialog.setVisible(true);
            SwingUtil.putParentCenter((Window)this.devWhiteListDialog, (Window)DeviceCenterContext.getInstance().getParent());
        });
        this.snWhiteListEnableBox.addActionListener(new SnWhiteListEnableListener(this));
        this.importBtn.addActionListener(new ImportListener(this.importListener));
        this.batchPortsCheckBtn.addActionListener(new CheckPortListener());
        this.ibmcTable.getDeviceTable().setUpdateSelectionOnSort(true);
        this.hmmTable.getDeviceTable().setUpdateSelectionOnSort(true);
        this.osTable.getDeviceTable().setUpdateSelectionOnSort(true);
        this.cmcTable.getDeviceTable().setUpdateSelectionOnSort(true);
        this.atlasTable.getDeviceTable().setUpdateSelectionOnSort(true);
        this.tceTable.getDeviceTable().setUpdateSelectionOnSort(true);
        this.switchTable.getDeviceTable().setUpdateSelectionOnSort(true);
        this.excelHyperLink.addMouseListener((MouseListener)new ExcelListener());
        this.initListModelListener();
    }

    private void initListModelListener() {
        ListSelectionModel listModel = this.ibmcTable.getDeviceTable().getSelectionModel();
        listModel.addListSelectionListener(arg0 -> this.updateBtn());
        ListSelectionModel listModel2 = this.hmmTable.getDeviceTable().getSelectionModel();
        listModel2.addListSelectionListener(arg0 -> this.updateBtn());
        ListSelectionModel listModel3 = this.osTable.getDeviceTable().getSelectionModel();
        listModel3.addListSelectionListener(arg0 -> this.updateBtn());
        ListSelectionModel listModel4 = this.cmcTable.getDeviceTable().getSelectionModel();
        listModel4.addListSelectionListener(arg0 -> this.updateBtn());
        ListSelectionModel iesListModel = this.atlasTable.getDeviceTable().getSelectionModel();
        iesListModel.addListSelectionListener(arg0 -> this.updateBtn());
        ListSelectionModel tceListModel = this.tceTable.getDeviceTable().getSelectionModel();
        tceListModel.addListSelectionListener(arg0 -> this.updateBtn());
        ListSelectionModel switchListModel = this.switchTable.getDeviceTable().getSelectionModel();
        switchListModel.addListSelectionListener(arg0 -> this.updateBtn());
    }

    public JButton getAddLabel() {
        return this.addBtn;
    }

    @Override
    public void deleteServiceDev() {
    }

    @Override
    public int getSelectNum() {
        return 0;
    }

    public SerDeviTitleLabel getOsLabel() {
        return this.osLabel;
    }

    public JCheckBox getSnWhiteListEnableBox() {
        return this.snWhiteListEnableBox;
    }

    public DevWhiteListDialog getDevWhiteListDialog() {
        return this.devWhiteListDialog;
    }

    public HMMTablePanel getHmmTable() {
        return this.hmmTable;
    }

    public SWITCHTablePanel getSwitchTable() {
        return this.switchTable;
    }

    public IBMCTablePanel getIbmcTable() {
        return this.ibmcTable;
    }

    public OSTablePanel getOsTable() {
        return this.osTable;
    }

    public CMCTablePanel getCmcTable() {
        return this.cmcTable;
    }

    public IesTablePanel getAtlasTable() {
        return this.atlasTable;
    }

    public TceTablePanel getTceTable() {
        return this.tceTable;
    }

    public TableScrollPane getIbmcScrollPane() {
        return this.ibmcScrollPane;
    }

    public TableScrollPane getHmmScrollPane() {
        return this.hmmScrollPane;
    }

    public TableScrollPane getOsScrollPane() {
        return this.osScrollPane;
    }

    public TableScrollPane getCmcScrollPane() {
        return this.cmcScrollPane;
    }

    public TableScrollPane getIesScrollPane() {
        return this.iesScrollPane;
    }

    public TableScrollPane getTceScrollPanel() {
        return this.tceScrollPanel;
    }

    public TableScrollPane getSwitchScrollPanel() {
        return this.switchScrollPanel;
    }
}

