/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.utils;

import com.huawei.ism.tool.framework.platform.exception.ToolSceneException;
import com.huawei.json.JSONObject;
import com.huawei.netcareinsidesdk.bo.CommandBo;
import com.huawei.netcareinsidesdk.constants.CommandTypeEnum;
import com.huawei.netcareinsidesdk.service.command.CommandServiceForSdk;
import com.huawei.netcareinsidesdk.service.common.impl.CommonServiceForSdkImpl;
import com.huawei.netcareinsidesdk.service.task.TaskServiceForSdk;
import com.huawei.netcareinsidesdk.utils.Result;
import java.awt.Window;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceNetCareUtil {
    private static final Logger log = LoggerFactory.getLogger(DeviceNetCareUtil.class);
    public static final String CODE_0 = "0";
    private static final String RESULT_DATA_RESULT_CODE_KEY = "resultCode";
    private static final String RESULT_DATA = "data";
    private static final String RESULT_CODE_KEY = "code";
    private static final String RESULT_DATA_RESULT_MESSAGE_KEY = "resultMessage";
    private static CommandServiceForSdk commandService;
    private static TaskServiceForSdk taskService;
    private static CommonServiceForSdkImpl commonService;
    private static boolean netCareEnabled;

    public static void initNetCareSdk(TaskServiceForSdk taskService, CommandServiceForSdk commandService, CommonServiceForSdkImpl commonService) {
        DeviceNetCareUtil.taskService = taskService;
        DeviceNetCareUtil.commandService = commandService;
        DeviceNetCareUtil.commonService = commonService;
    }

    public static boolean checkNetCareCode(String cmdKey, Window parent) throws ToolSceneException {
        if (!netCareEnabled) {
            log.warn("netCare is closed,check pass.");
            return true;
        }
        if (commonService == null || commandService == null || taskService == null) {
            throw new ToolSceneException("netCare sdk is not initialized.");
        }
        commonService.setToolMainFrame(parent);
        JSONObject taskResult = DeviceNetCareUtil.parseResult(taskService.getExecuteTaskInfo(null));
        JSONObject taskData = taskResult.getJSONObject(RESULT_DATA);
        if (!CODE_0.equals(taskResult.getStringOrDefault(RESULT_CODE_KEY, ""))) {
            throw new ToolSceneException("NetCare request failed," + taskResult);
        }
        if (!CODE_0.equals(taskData.getStringOrDefault(RESULT_DATA_RESULT_CODE_KEY, ""))) {
            log.warn("netCare task is not exist,ignore: {}; ", (Object)taskResult);
            return false;
        }
        CommandBo commandBo = new CommandBo();
        commandBo.setCommand(Collections.singletonList(cmdKey));
        commandBo.setCommandTypeEnum(CommandTypeEnum.COMMANDS);
        JSONObject cmdResult = DeviceNetCareUtil.parseResult(commandService.checkCommandExecute(commandBo));
        if (!CODE_0.equals(cmdResult.getStringOrDefault(RESULT_CODE_KEY, ""))) {
            throw new ToolSceneException("NetCare request failed: " + cmdResult);
        }
        JSONObject cmdData = cmdResult.getJSONObject(RESULT_DATA);
        log.warn("NetCare verification cmdResult code: {}; cmdResult message: {}", (Object)cmdData.getStringOrDefault(RESULT_DATA_RESULT_CODE_KEY, ""), (Object)cmdData.getStringOrDefault(RESULT_DATA_RESULT_MESSAGE_KEY, ""));
        return CODE_0.equals(cmdData.getStringOrDefault(RESULT_DATA_RESULT_CODE_KEY, ""));
    }

    public static void disableNetCare() {
        log.info("The NetCare is set disabled.");
        netCareEnabled = false;
    }

    private static JSONObject parseResult(Result result) {
        if (Objects.isNull(result)) {
            log.error("The NetCare execution result is null.");
            return new JSONObject();
        }
        return new JSONObject((Map)result);
    }

    static {
        netCareEnabled = true;
    }
}

