/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicecenter.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.CMCDevice;
import com.huawei.ism.tool.devicecenter.entity.CMCDevice2Json;
import com.huawei.ism.tool.devicecenter.entity.Device2JsonList;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice;
import com.huawei.ism.tool.devicecenter.entity.HMMDevice2Json;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice2Json;
import com.huawei.ism.tool.devicecenter.entity.IESDevice;
import com.huawei.ism.tool.devicecenter.entity.IESDevice2Json;
import com.huawei.ism.tool.devicecenter.entity.OsDevice;
import com.huawei.ism.tool.devicecenter.entity.OsDevice2Json;
import com.huawei.ism.tool.devicecenter.entity.SwitchDevice;
import com.huawei.ism.tool.devicecenter.entity.SwitchDevice2Json;
import com.huawei.ism.tool.devicecenter.entity.TceDevice;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.utils.UiItemCheckServiceEnum;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.TableRow;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class SmartkitUtils {
    public static final String LOG_CS_TYPE = "operalog.type.system";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SmartkitUtils.class);
    private static final String SERVER_TOOL_FILE = "server";
    private static final String DCTOOLS = "drivers";
    private static String[] killUmateExeCmds = new String[]{"taskkill /im uMate_CLI.exe /f /t", "taskkill /im uMate_CLI32.exe /f /t", "taskkill /im uMate.exe /f /t"};

    public static boolean isServerToolRunning(String flag) {
        StringBuilder buildedr = new StringBuilder(ApplicationContext.getInstance().getWorkPath());
        buildedr.append(File.separator).append(DCTOOLS).append(File.separator).append(SERVER_TOOL_FILE).append(File.separator);
        String normalRunpath = buildedr.toString() + flag;
        File flagFile = new File(normalRunpath);
        if (flagFile.exists() && !flagFile.delete()) {
            LOGGER.info("umate is running.");
            return true;
        }
        return false;
    }

    public static void addBatchImportDialog(BatchImportInfoDialog dialog, List<IImportListener> tables) {
        boolean hasBatchImportDialog = false;
        if (null == tables) {
            return;
        }
        for (IImportListener listener : tables) {
            if (!(listener instanceof BatchImportInfoDialog)) continue;
            hasBatchImportDialog = true;
            break;
        }
        if (hasBatchImportDialog) {
            for (IImportListener listener : tables) {
                if (!(listener instanceof BatchImportInfoDialog)) continue;
                tables.remove(listener);
                break;
            }
            tables.add(dialog);
        } else {
            tables.add(dialog);
        }
        DeviceCenterContext.getInstance().setBatchisCancel(false);
    }

    public static boolean checkIpBefore2NetPart(String start, String end) {
        if (StringUtils.isNULLStr((String)start) || StringUtils.isNULLStr((String)end)) {
            return false;
        }
        if (!start.contains(".") || !end.contains(".")) {
            return false;
        }
        String[] startArr = start.split("\\.");
        String[] endArr = end.split("\\.");
        if (4 != startArr.length && 4 != endArr.length) {
            return false;
        }
        return startArr[0].equals(endArr[0]) && startArr[1].equals(endArr[1]);
    }

    public static boolean isPortLegal(int port) {
        return port >= 1 && port <= 65535;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transDevice2Json(List<AbstractDevice> devices) {
        boolean deleteFlag;
        File sceneDeviceListFile;
        boolean mkFlag;
        Device2JsonList device2JsonList = new Device2JsonList();
        SmartkitUtils.setDeviceJsonList(devices, device2JsonList);
        String jsonArrayStr = JSONArray.toJSONString((Object)device2JsonList);
        StringBuilder sceneDeviceJsonParent = SmartkitUtils.getSceneDeviceJsonParent();
        File templates = new File(sceneDeviceJsonParent.toString());
        if (!templates.exists() && !(mkFlag = templates.mkdirs())) {
            LOGGER.info("mkdirs for json success.");
        }
        if ((sceneDeviceListFile = new File(SmartkitUtils.getSceneDeviceJsonFilePath())).exists() && (deleteFlag = sceneDeviceListFile.delete())) {
            LOGGER.info("delete dir success.");
        }
        FileOutputStream out = null;
        BufferedOutputStream buffOut = null;
        try {
            if (sceneDeviceListFile.createNewFile()) {
                out = new FileOutputStream(sceneDeviceListFile);
                buffOut = new BufferedOutputStream(out);
                buffOut.write(jsonArrayStr.getBytes(Charset.forName("UTF-8")));
            } else {
                LOGGER.info("create sceneDevice.json file failed.");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found.");
        }
        catch (IOException e) {
            LOGGER.error("io exception");
        }
        finally {
            StreamUtils.closeStream(buffOut, null);
            StreamUtils.closeStream((OutputStream)out, null);
        }
    }

    private static String getSceneDeviceJsonFilePath() {
        StringBuilder sceneDeviceJsonPath = SmartkitUtils.getSceneDeviceJsonParent();
        sceneDeviceJsonPath.append(File.separator).append("sceneDevice.json");
        return sceneDeviceJsonPath.toString();
    }

    private static StringBuilder getSceneDeviceJsonParent() {
        String toolkitPath = ApplicationContext.getInstance().getWorkPath();
        StringBuilder sceneDeviceJsonPath = new StringBuilder(toolkitPath);
        sceneDeviceJsonPath.append(File.separator).append("temp").append(File.separator).append("sceneTemplates").append(File.separator).append(SERVER_TOOL_FILE);
        return sceneDeviceJsonPath;
    }

    private static void handleStaticIp(List<AbstractDevice> devices) {
        HashMap<String, Integer> ip2Count = new HashMap<String, Integer>();
        for (AbstractDevice device : devices) {
            int count = ip2Count.getOrDefault(device.getIp(), 0);
            ip2Count.put(device.getIp(), ++count);
            if (count <= 1) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append(device.getIp());
            buffer.append("(");
            buffer.append(count - 1);
            buffer.append(")");
            device.setIp(buffer.toString());
        }
    }

    private static void setDeviceJsonList(List<AbstractDevice> devices, Device2JsonList device2JsonList) {
        SmartkitUtils.handleStaticIp(devices);
        for (AbstractDevice dev : devices) {
            Object obj2JsonDev;
            Object obj2JsonDev2;
            if (dev instanceof IBMCDevice) {
                IBMCDevice ibmcDevice = (IBMCDevice)dev;
                if (ibmcDevice.getHwServerDev().isPortProxy()) {
                    ibmcDevice.setIp(dev.getIp());
                }
                obj2JsonDev2 = new IBMCDevice2Json(ibmcDevice);
                device2JsonList.getDeviceList().add(obj2JsonDev2);
                continue;
            }
            if (dev instanceof HMMDevice) {
                obj2JsonDev = new HMMDevice2Json((HMMDevice)dev);
                device2JsonList.getDeviceList().add(obj2JsonDev);
                continue;
            }
            if (dev instanceof OsDevice) {
                obj2JsonDev = new OsDevice2Json((OsDevice)dev);
                device2JsonList.getDeviceList().add(obj2JsonDev);
                continue;
            }
            if (dev instanceof SwitchDevice) {
                obj2JsonDev = new SwitchDevice2Json((SwitchDevice)dev);
                device2JsonList.getDeviceList().add(obj2JsonDev);
                continue;
            }
            if (dev instanceof CMCDevice) {
                obj2JsonDev = new CMCDevice2Json((CMCDevice)dev);
                device2JsonList.getDeviceList().add(obj2JsonDev);
                continue;
            }
            if (dev instanceof IESDevice) {
                obj2JsonDev = new IESDevice2Json((IESDevice)dev);
                device2JsonList.getDeviceList().add(obj2JsonDev);
                continue;
            }
            if (!(dev instanceof TceDevice)) continue;
            HMMDevice tceDevice = ((TceDevice)dev).getDevice();
            if (tceDevice.getHwServerDev().isPortProxy()) {
                tceDevice.setIp(dev.getIp());
            }
            obj2JsonDev2 = new HMMDevice2Json(tceDevice);
            ((HMMDevice2Json)obj2JsonDev2).setType("tce");
            ((HMMDevice2Json)obj2JsonDev2).setSwichPlanes(null);
            device2JsonList.getDeviceList().add(obj2JsonDev2);
        }
    }

    public static void deleteSceneAddDialogHasedDevices(List<TableRow> deleteRows, IImportListener targetTable) {
        List<IImportListener> sceneAddDialogs = DeviceCenterContext.getInstance().getSceneDeviceTables().get("sceneTables");
        if (VerifyUtil.isEmpty(sceneAddDialogs)) {
            return;
        }
        for (IImportListener dialog : sceneAddDialogs) {
            if (!dialog.getClass().getName().equals(targetTable.getClass().getName())) continue;
            SmartkitUtils.deleteTableModelRows(dialog.getTableModel(), deleteRows);
            break;
        }
    }

    private static void deleteTableModelRows(DefaultTableModel tableModel, List<TableRow> deleteRows) {
        if (null != tableModel) {
            for (TableRow deleteRow : deleteRows) {
                tableModel.removeRow(new TableRow[]{deleteRow});
            }
        }
    }

    public static void refreshDevicesInfoByFile() {
        String sceneJson = null;
        try {
            sceneJson = SmartkitUtils.readValueByJsonFile(SmartkitUtils.getSceneDeviceJsonFilePath());
        }
        catch (IOException e) {
            LOGGER.error("read json from file error: {}", (Throwable)e);
        }
        if (StringUtils.isNULLStr((String)sceneJson)) {
            return;
        }
        Device2JsonList device2JsonList = (Device2JsonList)JSONObject.parseObject((String)sceneJson.trim(), Device2JsonList.class);
        List<Object> deviceJsonList = device2JsonList.getDeviceList();
        for (Object obj : deviceJsonList) {
            SmartkitUtils.refreshDeviceInfoByJsonObj((JSONObject)obj);
        }
        if (null != DeviceCenterContext.getInstance().getSelectServerManagerDialog()) {
            DeviceCenterContext.getInstance().getSelectServerManagerDialog().refresh();
        }
        if (null != DeviceCenterContext.getInstance().getServerManagePanel()) {
            DeviceCenterContext.getInstance().getServerManagePanel().refreshDatas();
        }
    }

    private static void refreshDeviceInfoByJsonObj(JSONObject jsonObject) {
        AbstractDevice devcie;
        if (!jsonObject.containsKey((Object)"refreshFlag")) {
            return;
        }
        if (!"true".equals(jsonObject.getString("refreshFlag"))) {
            return;
        }
        String deviceTypeJsonKey = "";
        String deviceIpJsonKey = "";
        String deviceSnJsonKey = "";
        if (jsonObject.containsKey((Object)"type")) {
            deviceTypeJsonKey = jsonObject.getString("type");
        }
        if (jsonObject.containsKey((Object)"ip")) {
            deviceIpJsonKey = jsonObject.getString("ip");
        }
        if (jsonObject.containsKey((Object)"serialNumber")) {
            deviceSnJsonKey = jsonObject.getString("serialNumber");
        }
        if (null == (devcie = SmartkitUtils.findDeviceByIpAndType(deviceIpJsonKey, deviceTypeJsonKey, deviceSnJsonKey))) {
            return;
        }
        if (deviceTypeJsonKey.equals(ITDeviceType.SERVER_HMM.getDeviceTypeJsonKey())) {
            HMMDevice hmmDev = (HMMDevice)devcie;
            hmmDev.refreshDeviceInfoBySelectJson(jsonObject);
        } else if (deviceTypeJsonKey.equals(ITDeviceType.SERVER_IBMC.getDeviceTypeJsonKey())) {
            IBMCDevice ibmcDevice = (IBMCDevice)devcie;
            ibmcDevice.refreshDeviceInfoBySelectJson(jsonObject);
        } else if (deviceTypeJsonKey.equals(ITDeviceType.IES.getDeviceTypeJsonKey())) {
            IESDevice iesDevice = (IESDevice)devcie;
            iesDevice.refreshDeviceInfoBySelectJson(jsonObject);
        }
    }

    private static AbstractDevice findDeviceByIpAndType(String ip, String type, String sn) {
        List<AbstractDevice> exitstDevices = DeviceCenterContext.getInstance().getIbmcHmmOsDevs();
        for (AbstractDevice device : exitstDevices) {
            if (!device.getIp().equals(ip) || !device.getTypeJsonKey().equals(type) || !device.getDeviceSn().equals(sn)) continue;
            return device;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String readValueByJsonFile(String path) throws IOException {
        File jsonFile = new File(path);
        StringBuilder result = new StringBuilder();
        FileReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            String str;
            reader = new FileReader(jsonFile);
            bufferedReader = new BufferedReader(reader);
            while ((str = bufferedReader.readLine()) != null) {
                result.append(str);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("{0} file not found.", (Object)jsonFile.getName());
            StreamUtils.closeResource(null, (Closeable)bufferedReader);
            StreamUtils.closeResource(null, (Closeable)reader);
        }
        catch (IOException e2) {
            LOGGER.error("read file io exception {0}", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeResource(null, bufferedReader);
                    StreamUtils.closeResource(null, (Closeable)reader);
                    throw throwable;
                }
            }
            StreamUtils.closeResource(null, (Closeable)bufferedReader);
            StreamUtils.closeResource(null, (Closeable)reader);
        }
        StreamUtils.closeResource(null, (Closeable)bufferedReader);
        StreamUtils.closeResource(null, (Closeable)reader);
        return result.toString();
    }

    public static UiItemCheckServiceEnum checkUserNameAndPwdByBlackList(List<AbstractDevice> hwServerList) {
        UiItemCheckServiceEnum checkResult = UiItemCheckServiceEnum.PASS;
        String matchRule = checkResult.getBlackRuleMap().keySet().stream().filter(rule -> !SmartkitUtils.isUserNamePwdVerifyPassByRule(hwServerList, rule)).findFirst().orElse("");
        if (VerifyUtil.isEmpty((String)matchRule)) {
            return checkResult;
        }
        checkResult = UiItemCheckServiceEnum.FAILED;
        checkResult.setRule(matchRule);
        return checkResult;
    }

    public static boolean isUserNamePwdVerifyPassByRule(List<AbstractDevice> hwServerList, String rule) {
        return hwServerList.stream().filter(hw -> hw instanceof HwServerDevice).filter(hwDevice -> SmartkitUtils.hasAtLeastOneMatch(((HwServerDevice)hwDevice).getAllUserNames(), rule) || SmartkitUtils.hasAtLeastOneMatch(((HwServerDevice)hwDevice).getAllPwds(), rule)).count() == 0L;
    }

    public static boolean hasAtLeastOneMatch(List<String> values, String rule) {
        return values.stream().anyMatch(value -> Pattern.matches(rule, value));
    }

    public static void killDriverProcess() {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            String[] cmdArr = killUmateExeCmds;
            Arrays.stream(cmdArr).forEach(cmd -> {
                LOGGER.info("execute cmd :{}", cmd);
                OSCmdUtils.executeCmd(cmd);
            });
        } else {
            String uname = OSCmdUtils.executeCmd("whoami");
            if (StringUtils.isNULLStr((String)uname)) {
                return;
            }
            String processesId = OSCmdUtils.executeCmd("pgrep -u " + uname + " -f smartKitDriversServer");
            if (StringUtils.isNULLStr((String)processesId)) {
                return;
            }
            OSCmdUtils.executeCmd("kill -9 " + processesId);
        }
    }
}

