/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.Interface.manage.redfish;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.Interface.manage.redfish.IDeviceRedfishService;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.uMate.common.rest.RedfishResult;
import com.huawei.uMate.common.utils.RedfishUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DeviceRedfishService
implements IDeviceRedfishService {
    private static final Logger LOGGER = new Logger(DeviceRedfishService.class);
    private static final String[] UNIQUEID_KEYS = new String[]{"Oem", "Huawei", "ProductUniqueID"};
    private static final String[] COMPATIBLE_KEYS = new String[]{"Oem", "Public", "ProductUniqueID"};
    private static final String VER_FORMAT = "%-30s: %s\n";
    private static final String REDFISH_V1_MANAGERS_S = "/redfish/v1/Managers/%s";
    private static final String REFISH_V1_CHASSIS_S = "/redfish/v1/Chassis/%s";
    private static final String SPOS_URL = "/redfish/v1/Managers/%s/SPService/SPOSInstallPara";
    private static final String ARCH_URL = "/redfish/v1/Systems/%s/Processors/1";
    public static final String CHASSIS_MAIN_BOARD_URL = "/redfish/v1/Chassis/%s/Boards/chassisMainBoard";
    public static final String SPVER_URL = "/redfish/v1/Managers/%s/SPService";
    protected RedfishConnestion conn;

    protected DeviceRedfishService() {
    }

    @Override
    public String getProductUniqueId() {
        RedfishResult result;
        String objectAttr;
        String slotId = this.getDeviceSlotId();
        String uri = "/redfish/v1/Managers/1";
        if (!StringUtils.isNULLStr((String)slotId)) {
            uri = String.format(Locale.ROOT, REDFISH_V1_MANAGERS_S, slotId);
        }
        if ((objectAttr = RedfishUtils.getObjectAttr((result = this.conn.executeGet(uri)).getResult(), String.class, UNIQUEID_KEYS)) == null) {
            objectAttr = RedfishUtils.getObjectAttr(result.getResult(), String.class, COMPATIBLE_KEYS);
        }
        return objectAttr;
    }

    @Override
    public String getDeviceSlotId() {
        RedfishResult result = this.conn.executeGet("/redfish/v1/Managers/");
        if (!result.isSuccess()) {
            return null;
        }
        if (RedfishUtils.hasKeyObject(result.getResult(), "Members")) {
            JSONArray array = RedfishUtils.getObjectAttr(result.getResult(), JSONArray.class, "Members");
            String slotInfo = array == null || array.size() == 0 ? null : array.getJSONObject(0).getString("@odata.id");
            return StringUtils.isNULLStr(slotInfo) ? "" : slotInfo.split("/")[4];
        }
        return null;
    }

    @Override
    public String getMainBordInfo(String sign) {
        String slotId = this.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            return "Failure: slotid is None.";
        }
        String url = String.format(Locale.ROOT, CHASSIS_MAIN_BOARD_URL, slotId);
        RedfishResult resp = this.conn.executeGet(url);
        if (!resp.isSuccess()) {
            return "Failure: Get Main Board Name Failed.";
        }
        if ("BN".equals(sign)) {
            return RedfishUtils.getObjectAttr(resp.getResult(), String.class, "BoardName");
        }
        return RedfishUtils.getObjectAttr(resp.getResult(), String.class, "BoardId");
    }

    @Override
    public String getESN() {
        JSONArray fistArray;
        RedfishResult result = this.conn.executeGet("/redfish/v1/Managers/");
        if (!result.isSuccess()) {
            LOGGER.error(String.format(Locale.ROOT, "device %s send command error %s", this.conn.getDestIp(), "/redfish/v1/Managers/"));
            return null;
        }
        if (RedfishUtils.hasKeyObject(result.getResult(), "Members") && Objects.requireNonNull(fistArray = RedfishUtils.getObjectAttr(result.getResult(), JSONArray.class, "Members")).size() > 0 && RedfishUtils.hasKeyObject(fistArray.getJSONObject(0), "@odata.id")) {
            String url = RedfishUtils.getObjectAttr(fistArray.getJSONObject(0), String.class, "@odata.id");
            result = this.conn.executeGet(url);
            if (!result.isSuccess()) {
                LOGGER.error(String.format(Locale.ROOT, "device %s send command error %s", this.conn.getDestIp(), url));
                return null;
            }
            String[] keys = new String[]{"Oem", "Huawei", "LicenseService", "@odata.id"};
            String[] compatibleKeys = new String[]{"Oem", "Public", "LicenseService", "@odata.id"};
            if (!RedfishUtils.hasKeyObject(result.getResult(), keys)) {
                keys = compatibleKeys;
            }
            if (RedfishUtils.hasKeyObject(result.getResult(), keys)) {
                String licUrl = RedfishUtils.getObjectAttr(result.getResult(), String.class, keys);
                RedfishResult ensResult = this.conn.executeGet(licUrl);
                if (!ensResult.isSuccess()) {
                    LOGGER.error(String.format(Locale.ROOT, "device %s send command error %s", this.conn.getDestIp(), licUrl));
                    return null;
                }
                if (RedfishUtils.hasKeyObject(ensResult.getResult(), "DeviceESN")) {
                    return RedfishUtils.getObjectAttr(ensResult.getResult(), String.class, "DeviceESN");
                }
            }
        }
        LOGGER.error(String.format(Locale.ROOT, "device %s doesnot has key menbers", this.conn.getDestIp()));
        return null;
    }

    @Override
    public String getSPVersion() {
        String slotId = this.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ROOT, "device %s slot id is null", this.conn.getDestIp()));
            return null;
        }
        String url = String.format(Locale.ROOT, SPVER_URL, slotId);
        RedfishResult result = this.conn.executeGet(url);
        if (!result.isSuccess()) {
            LOGGER.error(String.format(Locale.ROOT, "device %s cmd %s send error.", this.conn.getDestIp(), url));
        }
        StringBuilder resultBuilder = new StringBuilder();
        String key = "SysRestartDelaySeconds";
        if (RedfishUtils.hasKeyObject(result.getResult(), key)) {
            Integer val = RedfishUtils.getObjectAttr(result.getResult(), Integer.class, key);
            resultBuilder.append(String.format(Locale.ROOT, VER_FORMAT, key, val));
        }
        key = "Version";
        if (RedfishUtils.hasKeyObject(result.getResult(), key)) {
            JSONObject object = RedfishUtils.getObjectAttr(result.getResult(), JSONObject.class, key);
            for (Map.Entry<String, Object> e : Objects.requireNonNull(object).entrySet()) {
                resultBuilder.append(String.format(Locale.ROOT, VER_FORMAT, e.getKey(), e.getValue()));
            }
        }
        return resultBuilder.toString();
    }

    @Override
    public String getDeviceTimeZone() {
        String slotId = this.getDeviceSlotId();
        String nullStr = "";
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ROOT, "device %s slot id is null", this.conn.getDestIp()));
            return nullStr;
        }
        String url1 = String.format(Locale.ROOT, SPOS_URL, slotId);
        RedfishResult result1 = this.conn.executeGet(url1);
        if (!result1.isSuccess()) {
            LOGGER.error(String.format(Locale.ROOT, "device %s cmd %s send error.", this.conn.getDestIp(), url1));
            return nullStr;
        }
        JSONObject jsonObject1 = JSON.parseObject(result1.getResult());
        JSONArray membersArray = jsonObject1.getJSONArray("Members");
        if (membersArray.size() == 0) {
            LOGGER.error(String.format(Locale.ROOT, "device %s SPOSInstallPara members is empty.", this.conn.getDestIp()));
            return nullStr;
        }
        String url2 = membersArray.getJSONObject(0).getString("@odata.id");
        RedfishResult result2 = this.conn.executeGet(url2);
        if (!result2.isSuccess()) {
            LOGGER.error(String.format(Locale.ROOT, "device %s cmd %s send error.", this.conn.getDestIp(), url2));
            return nullStr;
        }
        JSONObject jsonObject2 = JSON.parseObject(result2.getResult());
        return jsonObject2.getString("TimeZone");
    }

    @Override
    public JSONObject getDiskHealth() {
        JSONObject diskInfoJson = new JSONObject();
        JSONArray diskInfoArray = new JSONArray();
        String slotId = this.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ROOT, "device %s slot id is null", this.conn.getDestIp()));
            return null;
        }
        String chassisUrl = String.format(Locale.ROOT, REFISH_V1_CHASSIS_S, slotId);
        RedfishResult chassisResult = this.conn.executeGet(chassisUrl);
        if (!chassisResult.isSuccess()) {
            LOGGER.error(String.format(Locale.ROOT, "device %s cmd %s send error.", this.conn.getDestIp(), chassisUrl));
            return null;
        }
        JSONObject chassisJson = JSON.parseObject(chassisResult.getResult());
        JSONArray drives = chassisJson.getJSONObject("Links").getJSONArray("Drives");
        for (int i = 0; i < drives.size(); ++i) {
            String url = drives.getJSONObject(i).getString("@odata.id");
            RedfishResult diskResult = this.conn.executeGet(url);
            if (!diskResult.isSuccess()) {
                LOGGER.error(String.format(Locale.ROOT, "device %s cmd %s send error.", this.conn.getDestIp(), chassisUrl));
                return null;
            }
            JSONObject diskJson = JSON.parseObject(diskResult.getResult());
            diskInfoArray.add(diskJson);
        }
        diskInfoJson.put("DiskInfo", (Object)diskInfoArray);
        return diskInfoJson;
    }

    @Override
    public String getCPUArchitecture() {
        String slotId = this.getDeviceSlotId();
        if (StringUtils.isNULLStr((String)slotId)) {
            LOGGER.error(String.format(Locale.ROOT, "device %s slot id is null", this.conn.getDestIp()));
            return null;
        }
        String url = String.format(Locale.ROOT, ARCH_URL, slotId);
        RedfishResult result = this.conn.executeGet(url);
        if (!result.isSuccess()) {
            LOGGER.error(String.format(Locale.ROOT, "device %s cmd %s send error.", this.conn.getDestIp(), url));
            return null;
        }
        JSONObject chassisJson = JSON.parseObject(result.getResult());
        return chassisJson.getString("ProcessorArchitecture");
    }
}

