/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.file;

import com.huawei.uMate.common.UMateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperation {
    private static final Logger log = LoggerFactory.getLogger(FileOperation.class);
    private static final Pattern FILE_PATTERN = Pattern.compile("(.*([/\\\\]{1}[ \\.\\.]{1,2}|[\\.\\.]{1,2}[/\\\\]{1}|\\.\\.).*|\\.)");
    private static final int ONE_K = 1024;

    public static void copyFile(String oldPath, String newPath) throws UMateException, FileNotFoundException, IOException {
        int byteread = 0;
        File oldfile = FileOperation.getFile(oldPath);
        FileOperation.mkdirs(FileOperation.getFile(newPath).getParentFile());
        if (oldfile.exists()) {
            try (FileInputStream inStream = FileUtils.openInputStream(oldfile);
                 FileOutputStream fs = FileUtils.openOutputStream(FileUtils.getFile(newPath));){
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
                fs.flush();
            }
            catch (Exception e) {
                log.error("Copy file {} to {}.", (Object)oldPath, (Object)newPath);
            }
        }
    }

    public static void copyFolder(String oldPath, String newPath) throws UMateException {
        FileOperation.mkdirs(FileOperation.getFile(newPath));
        File a = FileOperation.getFile(oldPath);
        String[] filePaths = a.list();
        if (null == filePaths) {
            log.error("file list the oldPath is null");
            return;
        }
        for (String filePath : filePaths) {
            File temp = oldPath.endsWith(File.separator) ? FileOperation.getFile(oldPath + filePath) : FileOperation.getFile(oldPath + File.separator + filePath);
            if (temp.isFile()) {
                try (FileInputStream input = FileUtils.openInputStream(temp);
                     FileOutputStream output = FileUtils.openOutputStream(FileUtils.getFile(newPath + "/" + temp.getName()));){
                    int len;
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                }
                catch (Exception ex) {
                    log.error("Copy file {} failed.", (Object)temp.getName());
                }
            }
            if (!temp.isDirectory()) continue;
            FileOperation.copyFolder(oldPath + "/" + filePath, newPath + "/" + filePath);
        }
    }

    public static boolean isSafeFilePath(String filePath) {
        Matcher matcher = FILE_PATTERN.matcher(filePath);
        return !matcher.matches();
    }

    public static File getFile(String filePath) throws UMateException {
        if (FileOperation.isSafeFilePath(filePath)) {
            return FileUtils.getFile(filePath);
        }
        throw new UMateException("The file path is invalid.");
    }

    public static boolean mkdirs(File dirFile) {
        if (null == dirFile) {
            return false;
        }
        if (!dirFile.exists()) {
            boolean mkdirs = dirFile.mkdirs();
            if (mkdirs) {
                return true;
            }
            log.error("Create directory {} failed.", (Object)dirFile);
            return false;
        }
        return true;
    }
}

