/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.ftp;

import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.ftp.ReadOnlySftpEvent;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.model.SFTPModel;
import com.huawei.uMate.common.thread.CommonRunnable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;

public class SFTPServer
extends CommonRunnable {
    private static final Logger LOGGER = new Logger(SFTPServer.class);
    private static final SFTPServer SFTP_SERVER = new SFTPServer();
    private static volatile SshServer server = null;
    private static String execPrint = "";
    private static SftpSubsystemFactory subsystemFactory;
    private static Map<String, SshServer> map;

    public static boolean startSFTP() throws UMateException, InterruptedException {
        subsystemFactory = new SftpSubsystemFactory();
        return SFTPServer.startSftpServer();
    }

    public static boolean startReadOnlySftp() throws UMateException, InterruptedException {
        subsystemFactory = new SftpSubsystemFactory();
        subsystemFactory.addSftpEventListener(new ReadOnlySftpEvent());
        return SFTPServer.startSftpServer();
    }

    private static boolean startSftpServer() throws InterruptedException, UMateException {
        SFTPServer.init();
        execPrint = "";
        SFTP_SERVER.start();
        while (SFTP_SERVER.isAlive()) {
            CommonRunnable.sleep(500);
            if (!execPrint.contains("Start SFTP server successfully.")) continue;
            LOGGER.info("Start SFTP server successfully.");
            return true;
        }
        LOGGER.error(String.format(Locale.ROOT, "Start SFTP server failed, error message:%s.", execPrint));
        throw new UMateException(execPrint);
    }

    public static boolean stopSFTP() {
        try {
            if (server != null) {
                CloseFuture close = server.close(true);
                if (!close.isClosed()) {
                    LOGGER.error("SFTP close failed.");
                }
                server.stop(true);
                server = null;
            }
            if (SFTP_SERVER != null && SFTP_SERVER.isAlive()) {
                SFTP_SERVER.interrupt();
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex);
            return false;
        }
        return true;
    }

    public static SFTPServer getSFTP_SERVER() {
        return SFTP_SERVER;
    }

    @Override
    public void run() {
        try {
            server = SshServer.setUpDefaultServer();
            server.setHost(SFTPModel.getSFTP_IP());
            server.setPort(Integer.parseInt(SFTPModel.getSFTP_SERVER_PORT()));
            String pathStr = SystemEnvUtil.getDefaultUserDir() + File.separator + SFTPModel.getSftpPath();
            Path ftpPath = Paths.get(pathStr, new String[0]);
            server.setFileSystemFactory(new VirtualFileSystemFactory(ftpPath));
            server.setSubsystemFactories(Collections.singletonList(subsystemFactory));
            server.setCommandFactory(new ScpCommandFactory());
            SimpleGeneratorHostKeyProvider keyProvider = new SimpleGeneratorHostKeyProvider();
            keyProvider.setPath(Paths.get(SFTPModel.getKeyPath(), new String[0]));
            keyProvider.setAlgorithm("RSA");
            server.setKeyPairProvider(keyProvider);
            server.setPasswordAuthenticator((username, password, session) -> SFTPModel.getSFTP_User().equals(username) && SFTPModel.getPassword().equals(password));
            map.put(SFTPModel.getSFTP_IP(), server);
            server.start();
            execPrint = "Start SFTP server successfully.";
            while (!this.isInterrupt()) {
                SFTPServer.sleep(10000);
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.error(ex);
            execPrint = "SFTP server port must be a number.";
        }
        catch (InterruptedException ex) {
            execPrint = "Task was aborted.";
        }
        catch (IOException ex) {
            this.handledErrorMessage(ex);
        }
        catch (Exception ex) {
            LOGGER.error(ex);
            execPrint = ex.getMessage();
        }
    }

    void handledErrorMessage(IOException ex) {
        LOGGER.error("start sftp failed.", ex);
        String msg = ex.getMessage();
        String message = Optional.ofNullable(ex.getCause()).map(Throwable::getMessage).orElse(null);
        execPrint = msg == null && message == null ? "SFTP start failed, " : (msg.contains("Address already in use") || message.contains("Address already in use") ? "Server port is already in use." : (msg.contains("Cannot assign requested address") || message.contains("Cannot assign requested address") ? "Server IP is not a local IP, change it and try again." : msg));
    }

    private static synchronized void init() {
        if (null != server) {
            return;
        }
        File sftpLogPath = new File(SFTPModel.getLogPath());
        FileOperation.mkdirs(sftpLogPath.getParentFile());
    }

    public static String getExecPrint() {
        return execPrint;
    }

    static {
        map = new ConcurrentHashMap<String, SshServer>();
    }
}

