/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.model;

import com.huawei.uMate.common.CommonMethods;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.utils.ResUtil;
import com.huawei.uMate.common.utils.SecurityUtils;

public class IPMIAndSNMPModel {
    private static final ResUtil RES = ResUtil.getInstance("common");
    private String IPAddress = "";
    private String userName = "";
    private char[] userPwd = null;
    private char[] rootPwd = null;
    private String SSHPort = "22";

    public String getIPAddress() {
        return this.IPAddress;
    }

    public void setIPAddress(String IPAddress) throws UMateException {
        String validIPAddress;
        String string = validIPAddress = IPAddress == null ? "" : IPAddress.replace(" ", "");
        if ("".equals(validIPAddress)) {
            throw new UMateException("IP Address can not be empty.");
        }
        if (!validIPAddress.matches(SecurityUtils.getregxIPv4()) && !validIPAddress.matches(SecurityUtils.getregxIPv6())) {
            throw new UMateException(validIPAddress + ":Invalid IP Address.");
        }
        this.IPAddress = validIPAddress;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) throws UMateException {
        if (userName == null || "".equals(userName.trim())) {
            throw new UMateException(RES.getString("common.message.swi.user.invalid"));
        }
        if (!SecurityUtils.isValidAndSafeUser(userName)) {
            throw new UMateException(RES.getString("common.message.swi.user.invalid"));
        }
        this.userName = userName;
    }

    public String getUserPwd() {
        if (this.userPwd == null) {
            return "";
        }
        return new String(this.userPwd);
    }

    public void setUserPwd(String userPwd) {
        this.userPwd = (char[])(userPwd == null ? null : userPwd.toCharArray());
    }

    public String getRootPwd() {
        if (this.rootPwd == null) {
            return "";
        }
        return new String(this.rootPwd);
    }

    public void setRootPwd(String rootPwd) {
        this.rootPwd = (char[])(rootPwd == null ? null : rootPwd.toCharArray());
    }

    public String getSSHPort() {
        return this.SSHPort;
    }

    public void setSSHPort(String SSHPort) throws UMateException {
        String validSSHPort;
        String string = validSSHPort = SSHPort == null ? "" : SSHPort.trim();
        if ("".equals(validSSHPort)) {
            return;
        }
        if (!CommonMethods.checkPort(validSSHPort, "SSH/SFTP Port")) {
            return;
        }
        this.SSHPort = validSSHPort;
    }
}

