/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.ssh;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.connection.MultiRouteManager;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.uMate.HWDiscover.model.HWDiscoverModel;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.enums.CommonEnums;
import com.huawei.uMate.common.model.IPMIAndSNMPModel;
import com.huawei.uMate.common.model.SFTPModel;
import com.huawei.uMate.common.ssh.ServerEndJudge;
import com.huawei.uMate.common.ssh.manager.SessionMonitor;
import com.huawei.uMate.common.utils.ResUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.impl.DefaultSftpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell {
    private static final Logger log = LoggerFactory.getLogger(Shell.class);
    public static final Shell EMPTY = null;
    public static final int COMMAND_EXECUTION_SUCCESS_OPCODE = -2;
    public static final String BACKSLASH_R = "\r";
    public static final String BACKSLASH_N = "\n";
    public static final String ENTER_CHARACTER = "\r\n";
    public static final String lastCmd = "uMateLogCollectTag";
    public static final String[] linuxPromptRegEx = new String[]{"uMateLogCollectTag"};
    public static final String SUCCESS = "Collect Data Success: ";
    private static final ResUtil RES = ResUtil.getInstance("common");
    private static final com.huawei.uMate.common.log.Logger LOGGER = new com.huawei.uMate.common.log.Logger(Shell.class);
    private static final String[] NOT_PRINT_LOG_CMD = new String[]{"smmset -d userpasswd -v"};
    private static final int DEFAULT_TIMEOUT = 3600000;
    private static final int DEFAULT_SLEEP_TIME = 200;
    private static final String[] errorMsg = new String[]{"could not acquire the config lock "};
    private static final int TIME_OUT = 30000;
    private static String collectLogPath = "";
    protected SessionMonitor monitor = null;
    protected volatile boolean connected;
    private StringBuffer buffer = new StringBuffer();
    private String LOCAL_IP = "";
    private String ip;
    private int port;
    private String user;
    private String pasd;
    private volatile boolean isExecuting;
    private IPMIAndSNMPModel snmpModel = null;
    private ChannelShell shellChannel = null;
    private CommonEnums.ShellType shellType = CommonEnums.ShellType.ALL;
    private ClientSession sessionSftp;
    private ClientSession session;
    private MultiRouteManager routeMgr = null;
    private SftpClient sftpChannel;
    private SshClient client;
    private SshClient clientForSftp;

    public Shell(IPMIAndSNMPModel snmpModel, CommonEnums.ShellType shellType) throws UMateException {
        this.snmpModel = snmpModel;
        this.shellType = shellType;
        java.util.logging.Logger.getLogger("expect4j").setLevel(Level.OFF);
        this.ip = snmpModel.getIPAddress();
        this.port = Integer.parseInt(snmpModel.getSSHPort());
        this.user = snmpModel.getUserName();
        this.pasd = snmpModel.getUserPwd();
        this.activeSession();
    }

    public SftpClient getSftpChannel() {
        return this.sftpChannel;
    }

    public ChannelShell getChannel() {
        return this.shellChannel;
    }

    public ClientSession getSession() {
        return this.session;
    }

    public void disconnect() {
        log.info("device {} ssh closing...", (Object)this.snmpModel.getIPAddress());
        if (this.monitor != null) {
            this.monitor.close();
            this.monitor = null;
            log.info("device {} ssh monitor closed...", (Object)this.snmpModel.getIPAddress());
        }
        if (this.shellChannel != null) {
            try {
                this.shellChannel.close();
            }
            catch (FileNotFoundException e) {
                log.error("file not found");
            }
            catch (IOException ex) {
                log.error(this.snmpModel.getIPAddress(), ex);
            }
        }
        try {
            if (this.sftpChannel != null) {
                this.sftpChannel.close();
            }
            if (this.sessionSftp != null) {
                this.sessionSftp.close();
            }
            this.session.close();
            if (this.routeMgr != null) {
                this.routeMgr.close();
            }
        }
        catch (IOException e) {
            log.error("close sftp error {}", e);
        }
        log.info("device {} ssh closed...", (Object)this.snmpModel.getIPAddress());
    }

    public void disconnectSftp() {
        try {
            if (this.sftpChannel != null && this.sftpChannel.isOpen()) {
                this.sftpChannel.close();
            }
            if (this.sessionSftp != null) {
                this.sessionSftp.close();
            }
        }
        catch (IOException e) {
            log.error("close sftp error {}", e);
        }
    }

    public synchronized boolean isConnected() {
        if (!this.isConnectionActive()) {
            return false;
        }
        if (!this.isSessionActive()) {
            log.info("the connection session is closed, close whole connection and isConnected return false.");
            this.closeStraightly();
            return false;
        }
        return true;
    }

    private void closeStraightly() {
        try {
            if (!this.connected) {
                return;
            }
        }
        finally {
            this.closeSession();
            this.connected = false;
        }
    }

    private void closeSession() {
        if (this.monitor != null) {
            this.monitor.close();
            this.monitor = null;
        }
        if (this.session != null) {
            this.close(this.session);
        }
        if (this.client != null) {
            this.close(this.client);
        }
        if (this.clientForSftp != null) {
            this.close(this.clientForSftp);
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.error("Close session error.", e);
            }
        }
    }

    public boolean isSessionActive() {
        return this.monitor != null && this.monitor.isActive();
    }

    public synchronized boolean isConnectionActive() {
        if (!this.connected) {
            log.info("the connection is closed, isConected return false.");
            return false;
        }
        return true;
    }

    public synchronized String getResponse() {
        String result = this.buffer.toString();
        this.buffer.setLength(0);
        return result.replaceAll(lastCmd, "");
    }

    private void activeSession() throws UMateException {
        Properties config = new Properties();
        try {
            this.initSessionParams(config);
            CoreModuleProperties.IDLE_TIMEOUT.set(this.session, Duration.ofMinutes(30L));
            this.session.auth().verify(30000L, new CancelOption[0]);
            this.connected = true;
            if (this.shellType == CommonEnums.ShellType.ALL || this.shellType == CommonEnums.ShellType.SSH || this.shellType == CommonEnums.ShellType.PROXY) {
                this.monitor = new SessionMonitor(this.session);
                this.monitor.setName("session monitor for " + this.ip);
                this.monitor.startShell();
                this.monitor.start();
            }
            if (this.shellType == CommonEnums.ShellType.ALL || this.shellType == CommonEnums.ShellType.SFTP) {
                this.createSftpChannel();
            }
            this.switchToRootIfNeeded();
        }
        catch (IOException e) {
            LOGGER.error("active session error.", e);
            throw new UMateException(e.getMessage());
        }
    }

    private void createSftpChannel() throws IOException {
        this.clientForSftp = SshClient.setUpDefaultClient();
        CoreModuleProperties.NIO_WORKERS.set(this.clientForSftp, 1);
        this.clientForSftp.start();
        this.clientForSftp.setServerKeyVerifier(AcceptAllServerKeyVerifier.INSTANCE);
        this.sessionSftp = (ClientSession)((ConnectFuture)this.clientForSftp.connect(this.user, this.ip, this.port).verify(30000L, new CancelOption[0])).getSession();
        this.sessionSftp.addPasswordIdentity(this.pasd);
        this.sessionSftp.auth().verify(30000L, new CancelOption[0]);
        this.connected = true;
        this.sftpChannel = DefaultSftpClientFactory.INSTANCE.createSftpClient(this.sessionSftp);
    }

    public void mkdirs(String directory) {
        try {
            this.sftpChannel.mkdir(directory);
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("fail and retry");
                this.disconnectSftp();
                this.createSftpChannel();
                this.sftpChannel.mkdir(directory);
            }
            catch (IOException e) {
                LOGGER.error(this.snmpModel.getIPAddress() + " mkdir on target device failed.", e);
            }
        }
    }

    private void initSessionParams(Properties config) throws IOException {
        this.client = SshClient.setUpDefaultClient();
        CoreModuleProperties.NIO_WORKERS.set(this.client, 1);
        ArrayList<UserAuthFactory> userAuthFactories = new ArrayList<UserAuthFactory>();
        userAuthFactories.add(UserAuthPasswordFactory.INSTANCE);
        userAuthFactories.add(UserAuthKeyboardInteractiveFactory.INSTANCE);
        this.client.setUserAuthFactories((List<UserAuthFactory>)userAuthFactories);
        this.client.start();
        this.client.setServerKeyVerifier(AcceptAllServerKeyVerifier.INSTANCE);
        this.client.setServerKeyVerifier(AcceptAllServerKeyVerifier.INSTANCE);
        this.session = (ClientSession)((ConnectFuture)this.client.connect(this.user, this.ip, this.port).verify(30000L, new CancelOption[0])).getSession();
        this.session.addPasswordIdentity(this.pasd);
    }

    private void clearLgoinCliRet() {
        if (this.monitor == null) {
            return;
        }
        ConnUtils.sleep((int)1000);
        this.preInputStreamReceiver();
        for (int times = 0; !org.apache.commons.lang3.StringUtils.isEmpty(this.monitor.getCurrentStdOut(false)) || times < 10; ++times) {
            ConnUtils.sleep((int)100);
            this.preInputStreamReceiver();
        }
    }

    public synchronized boolean executeCommand(String command, int timeOut) throws Exception {
        return this.executeCommands(new String[]{command}, timeOut);
    }

    public synchronized boolean executeCommand(String command) throws Exception {
        return this.executeCommand(command, null);
    }

    public synchronized boolean executeCommand(String command, String expect) throws Exception {
        return this.executeCommands(new String[]{command}, expect);
    }

    public synchronized String executeAndGetCommand(String command, int timeOut) throws Exception {
        if (this.executeCommands(new String[]{command}, timeOut)) {
            return this.getResponse();
        }
        return null;
    }

    public synchronized String executeAndGetCommand(String command) throws Exception {
        if (this.executeCommands(new String[]{command})) {
            return this.getResponse();
        }
        return null;
    }

    public synchronized String executeAndGetCommand(String command, String[] endKeyWhitelist) throws Exception {
        if (this.executeCommands(new String[]{command}, endKeyWhitelist)) {
            return this.getResponse();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized boolean executeCommands(String[] commands, int timeout, String expect, String[] endKeyWhitelist) throws Exception {
        this.isExecuting = true;
        try {
            boolean bl = this.doExecuteCmd(commands, timeout, expect, endKeyWhitelist);
            return bl;
        }
        finally {
            this.isExecuting = false;
        }
    }

    private boolean doExecuteCmd(String[] commands, int timeout, String expect, String[] endKeyWhitelist) {
        boolean isCmdexecSucc = true;
        if (this.monitor == null) {
            return false;
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank(commands[0])) {
            this.preInputStreamReceiver();
        }
        boolean isPrint = this.isPrintLog(commands);
        for (String strCmd : commands) {
            isCmdexecSucc = isCmdexecSucc && this.sendCommand(strCmd, isPrint);
            this.sleepSomeTime(500);
        }
        if (!isCmdexecSucc) {
            return false;
        }
        boolean result = this.waitResult(timeout, commands[0], expect, endKeyWhitelist);
        String response = this.buffer.toString().toLowerCase(Locale.ENGLISH);
        for (String msg : errorMsg) {
            if (!response.contains(msg)) continue;
            return false;
        }
        this.preInputStreamReceiver();
        return result;
    }

    public synchronized boolean executeCommands(String[] commands, int timeout) throws Exception {
        return this.executeCommands(commands, timeout, null, null);
    }

    public synchronized boolean executeCommands(String[] commands) throws Exception {
        return this.executeCommands(commands, 3600000);
    }

    public synchronized boolean executeCommands(String[] commands, String[] endKeyWhitelist) throws Exception {
        return this.executeCommands(commands, 3600000, null, endKeyWhitelist);
    }

    public synchronized boolean executeCommands(String[] commands, String expect) throws Exception {
        return this.executeCommands(commands, 3600000, expect, null);
    }

    private boolean sendCommand(String commandLine, boolean isPrintLog) {
        if (isPrintLog) {
            String cmd = commandLine;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(this.snmpModel.getRootPwd())) {
                cmd = cmd.replace(this.snmpModel.getRootPwd(), "*****");
            }
            if (!StringUtils.isNULLStr((String)SFTPModel.getPassword())) {
                cmd = cmd.replace(SFTPModel.getPassword(), "******");
            }
            LOGGER.info(String.format(Locale.ROOT, "begin to exec command : %s", cmd.replace(this.snmpModel.getUserPwd(), "*****")));
        }
        return this.sendCmd(commandLine, true);
    }

    private boolean sendCmd(String commandLine, boolean isEnter) {
        try {
            String remoteCommandLine = commandLine;
            if (isEnter) {
                remoteCommandLine = remoteCommandLine + BACKSLASH_R;
            }
            this.monitor.sendCmd(remoteCommandLine);
            return true;
        }
        catch (Exception th) {
            LOGGER.error("send cmd error", th);
            return false;
        }
    }

    private String removeIncreaseLines(int numOfIncrease, String ret) {
        String result = ret;
        for (int i = 0; i < numOfIncrease; ++i) {
            int idxOfSep = result.lastIndexOf(10);
            if (idxOfSep < 0) {
                return result;
            }
            result = result.substring(0, idxOfSep);
        }
        return result;
    }

    private String afterTWoCMD(String cmd, String cmdRet) {
        int idx;
        int thirdIdxOfLinSep = 0;
        int numbersOfLine = 0;
        for (int i = 0; i < cmdRet.length(); ++i) {
            if (cmdRet.charAt(i) == '\n') {
                thirdIdxOfLinSep = i;
                ++numbersOfLine;
            }
            if (numbersOfLine > 3) break;
        }
        String result = cmdRet;
        for (int i = 0; i < 2 && (idx = result.indexOf(cmd)) >= 0 && idx < thirdIdxOfLinSep; ++i) {
            result = result.substring(idx + cmd.length());
        }
        return result;
    }

    private boolean waitResult(int timeout, String cmd, String expect, String[] endKeyWhitelist) {
        boolean result;
        String cmdStr;
        block4: {
            this.sleepSomeTime(200);
            cmdStr = "";
            int usedTime = 0;
            int lastLen = 0;
            int notSendNewLineTimes = 0;
            int increaseLines = 0;
            result = true;
            while (true) {
                if (this.isBreakNow(timeout, cmd, usedTime)) {
                    result = this.printLogAndRet(timeout, cmd, usedTime);
                    break block4;
                }
                this.sleepSomeTime(200);
                usedTime += 200;
                if (!org.apache.commons.lang3.StringUtils.isBlank(cmd) && cmdStr.contains(cmd)) {
                    cmdStr = this.afterTWoCMD(cmd, cmdStr);
                }
                if (ServerEndJudge.isSshFinish(this.removeIncreaseLines(increaseLines, cmdStr), expect, cmd, endKeyWhitelist)) break;
                cmdStr = this.monitor.getCurrentStdOut(false);
                if (cmdStr.length() != lastLen) {
                    notSendNewLineTimes = 0;
                    lastLen = cmdStr.length();
                    continue;
                }
                if (++notSendNewLineTimes % 300 != 0) continue;
                this.sendCommand(ENTER_CHARACTER, true);
                ++increaseLines;
                notSendNewLineTimes = 0;
            }
            LOGGER.info("End judge found, break up process of waiting result.");
        }
        this.handleResult(cmd, cmdStr);
        return result;
    }

    private boolean printLogAndRet(int timeout, String cmd, int usedTime) {
        String cmdNew = cmd.replace(this.snmpModel.getUserPwd(), "***");
        String rootPwd = null;
        if (this.snmpModel instanceof HWDiscoverModel) {
            rootPwd = ((HWDiscoverModel)this.snmpModel).getRootPwd();
            cmdNew = cmdNew.replace(rootPwd, "***");
        }
        LOGGER.info(usedTime > timeout ? String.format(Locale.ENGLISH, "%s time out happened,cmd:%s", this.snmpModel.getIPAddress(), cmdNew) : "");
        boolean result = usedTime < timeout && this.monitor.isActive();
        return result;
    }

    protected boolean isPrintLog(String cmd) {
        for (String cmdLine : NOT_PRINT_LOG_CMD) {
            if (!cmd.contains(cmdLine)) continue;
            return false;
        }
        return true;
    }

    private void handleResult(String cmd, String cmdStr) {
        if (cmdStr.contains(SUCCESS) && "".equals(collectLogPath)) {
            collectLogPath = cmdStr.substring(cmdStr.indexOf(SUCCESS), cmdStr.length());
            collectLogPath = collectLogPath.substring(0, collectLogPath.indexOf(BACKSLASH_N));
            collectLogPath = collectLogPath.replaceAll(SUCCESS, "");
        }
        if (this.isPrintLog(cmd)) {
            String rootPwd = null;
            String cmdRet = cmdStr;
            String cmdHand = cmd;
            if (this.snmpModel instanceof HWDiscoverModel && !org.apache.commons.lang3.StringUtils.isEmpty(rootPwd = ((HWDiscoverModel)this.snmpModel).getRootPwd())) {
                cmdRet = cmdRet.replace(rootPwd, "***");
                cmdHand = cmd.replace(rootPwd, "***");
            }
            if (!StringUtils.isNULLStr((String)SFTPModel.getPassword())) {
                cmdHand = cmdHand.replace(SFTPModel.getPassword(), "******");
                cmdRet = cmdRet.replace(SFTPModel.getPassword(), "******");
            }
            LOGGER.info(String.format(Locale.ROOT, "dev %s,cmd:%s,received cmd exec result : \n%s", this.snmpModel.getIPAddress(), cmdHand.replace(this.snmpModel.getUserPwd(), "****"), cmdRet.replace(this.snmpModel.getUserPwd(), "****")));
        }
        this.buffer.append(this.monitor.getCurrentStdOut(true));
    }

    private boolean isBreakNow(int timeout, String cmd, int usedTime) {
        boolean condition3;
        boolean condition1 = usedTime > timeout;
        boolean condition2 = !this.monitor.isActive();
        boolean isNotEndCommands = true;
        for (String endJudge : ServerEndJudge.NOT_END_COMMANDS) {
            Pattern wp = Pattern.compile(endJudge, 34);
            Matcher matcher = wp.matcher(cmd);
            if (!matcher.find()) continue;
            isNotEndCommands = false;
        }
        boolean bl = condition3 = org.apache.commons.lang3.StringUtils.isBlank(cmd) && usedTime > 50 && isNotEndCommands;
        if (condition1) {
            LOGGER.info(String.format(Locale.ROOT, "usedTime:%s,timeout:%s", usedTime, timeout));
            LOGGER.error("condition1:" + condition1);
        }
        if (condition2) {
            LOGGER.error("condition2:" + condition2);
        }
        if (condition3) {
            LOGGER.error("condition3:" + condition3);
        }
        return condition1 || condition2 || condition3;
    }

    private void sleepSomeTime(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.error("sleep error.", e);
        }
    }

    private void preInputStreamReceiver() {
        String lastOut = this.monitor.getCurrentStdOut(true);
        String lastError = this.monitor.getCurrentStdErr(true);
        if (!org.apache.commons.lang3.StringUtils.isEmpty(lastOut)) {
            LOGGER.info(String.format(Locale.ROOT, "PreInputStreamReceiver. Read :%s", lastOut));
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(lastError)) {
            LOGGER.info(String.format(Locale.ROOT, "PreInputStreamReceiver. Read :%s", lastError));
        }
    }

    private boolean checkResult(int intRetVal) {
        return intRetVal == -2;
    }

    public void upload(String directory, String uploadFile, boolean overwrite) throws UMateException {
        log.info("begin upload");
        try {
            if (!org.apache.commons.lang3.StringUtils.isEmpty(this.snmpModel.getRootPwd()) && !"root".equals(this.user)) {
                throw new UMateException("Unsupport for non root user to upload scripts");
            }
            SftpTransfer.uploadFile((String)directory, (String)uploadFile, (SftpClient)this.sftpChannel);
            log.info("end upload");
        }
        catch (IOException e) {
            throw new UMateException("Upload file to device failed, please check space is enough or not.");
        }
    }

    public void uploadFile(String targetFile, String uploadFile, boolean overwrite) throws IOException {
        SftpTransfer.uploadFile((String)targetFile, (String)uploadFile, (SftpClient)this.sftpChannel);
    }

    public void getDeviceFile(String directory, String downloadFile, String saveFile) throws ToolException {
        try {
            log.info("begin download...");
            String devPath = directory + downloadFile;
            SftpTransfer.downloadFile((String)saveFile, (String)devPath, (SftpClient)this.sftpChannel);
            log.info("finish download");
        }
        catch (IOException e) {
            LOGGER.error("update file error", e);
            throw new ToolException("putFile file error.", false, (Throwable)e);
        }
    }

    public List<String> listFiles(String directory) {
        ArrayList<String> fileList = new ArrayList<String>();
        Iterable<SftpClient.DirEntry> entrys = null;
        try {
            SftpClient.CloseableHandle handle = this.sftpChannel.openDir(directory);
            entrys = this.sftpChannel.listDir(handle);
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Can not list file in remote path:****");
            return fileList;
        }
        for (SftpClient.DirEntry entry : entrys) {
            if (entry.getAttributes().isDirectory() || entry.getFilename().startsWith(".")) continue;
            fileList.add(entry.getFilename());
        }
        return fileList;
    }

    public void switchToRootIfNeeded() throws UMateException {
        LOGGER.info("check if need switch to root?");
        if (org.apache.commons.lang3.StringUtils.isEmpty(this.snmpModel.getRootPwd())) {
            log.info("No root password. You do not need to switch to the root user.");
            return;
        }
        if (this.isRootUser()) {
            log.info("The current login user is the root user. You do not need to switch to the root user.");
            return;
        }
        LOGGER.info("Start to switch to the root user.");
        this.executeSwitchCommand();
    }

    private void executeSwitchCommand() throws UMateException {
        try {
            String rootPwd = this.snmpModel.getRootPwd();
            String[] cmdList = new String[]{"su root", rootPwd};
            this.executeCommands(cmdList, 600000);
            if (!this.isRootUser()) {
                throw new UMateException("Failed to switch to the root user.");
            }
            log.info("switch output: ".concat(this.getResponse()).replace(rootPwd, "******"));
        }
        catch (Exception e) {
            log.error("An error occurred when executing the 'su root' command.", e);
            throw new UMateException("Failed to switch to the root user.");
        }
        log.info("Succeeded in switching to user root.");
    }

    public boolean isRootUser() throws UMateException {
        try {
            String response = this.executeAndGetCommand("whoami", 600000);
            log.info("The command output is {}.", (Object)response);
            if (!this.checkCommandExists(response)) {
                throw new UMateException("Failed to query the current login user's role.");
            }
            String[] outputs = response.split("[\\r\\n]");
            return Arrays.stream(outputs).anyMatch(output -> "root".equalsIgnoreCase(output.trim()));
        }
        catch (Exception e) {
            log.error("An error occurred when executing the 'whoami' command.", e);
            throw new UMateException(RES.getString("ssh.check.whoami.error"));
        }
    }

    public boolean checkCommandExists(String response) {
        if (org.apache.commons.lang3.StringUtils.isEmpty(response)) {
            log.warn("The command may not exist. The command output is {}.", (Object)response);
            return false;
        }
        String[] outputs = response.split("[\\r\\n]");
        if (outputs.length <= 1) {
            log.warn("The command may not exist. The command output is {}.", (Object)response);
            return false;
        }
        return IntStream.range(1, outputs.length).mapToObj(i -> outputs[i].trim().toLowerCase(Locale.ENGLISH)).noneMatch(commandResult -> commandResult.contains("not found") || commandResult.contains("not-found") || commandResult.contains("no such file or directory") || commandResult.contains("not exist"));
    }

    protected boolean isPrintLog(String[] commands) {
        for (String command : commands) {
            if (!command.contains(this.snmpModel.getUserPwd())) continue;
            return false;
        }
        return true;
    }

    public void delete(String directory, String deleteFile, boolean throwException) {
        try {
            this.sftpChannel.remove(deleteFile);
            log.info("{} deleted successfully.", (Object)deleteFile);
        }
        catch (IOException exp) {
            if (throwException) {
                log.error(this.snmpModel.getIPAddress(), exp);
            }
            log.info("{} delete {} failed, message:{}.", this.snmpModel.getIPAddress(), deleteFile, exp.getMessage());
        }
    }

    public String toString() {
        return "Shell{LOCAL_IP='" + this.LOCAL_IP + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + '}';
    }

    public Shell() {
    }
}

