/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.uMate.common.CommonMethods;
import com.huawei.uMate.common.file.FileOperation;
import com.huawei.uMate.common.utils.DataCheckUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    private static final List<String> SCHEMEWHITELIST = new ArrayList<String>(1);

    public static String getregxIPv6() {
        return "^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$";
    }

    public static String getregxIPv4() {
        return "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
    }

    public static boolean isValidAndSafeIp(String ip) {
        if (CommonMethods.checkIPv4(ip)) {
            return true;
        }
        if (CommonMethods.checkIPv6(ip)) {
            return true;
        }
        return CommonMethods.checkIPZero(ip);
    }

    public static boolean isValidAndSafeNumber(String number, boolean isAllowEmpty) {
        if (isAllowEmpty) {
            return StringUtils.isNULLStr((String)number);
        }
        if (StringUtils.isNULLStr((String)number)) {
            return false;
        }
        return DataCheckUtil.isValidNumParam(number, false);
    }

    public static boolean isValidAndSafePath(String toCheckPath) {
        return FileOperation.isSafeFilePath(toCheckPath);
    }

    public static boolean isValidAndSafeUser(String user) {
        return DataCheckUtil.isValidUserName(user, false) && user.matches(".{1,16}");
    }

    public static boolean isValidAndSafePassword(String password) {
        if (StringUtils.isNULLStr((String)password)) {
            return false;
        }
        return password.matches(".{6,64}");
    }

    public static SAXReader getSecuritySAXReader() {
        SAXReader reader = new SAXReader();
        try {
            SecurityUtils.makeSaxReaderSecurity(reader);
        }
        catch (SAXException e) {
            log.error("SAXException a general SAX error or warning.", e);
        }
        return reader;
    }

    private static SAXReader makeSaxReaderSecurity(SAXReader reader) throws SAXException {
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return reader;
    }

    public static boolean isValidURL(String testUrl) {
        URI uri;
        try {
            URL url = new URL(testUrl);
            uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery());
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("url illegal", e);
            return false;
        }
        if (uri.getHost() == null) {
            log.error("The host component of thr URI is null.");
            return false;
        }
        String scheme = uri.getScheme();
        if (StringUtils.isNULLStr((String)scheme) || !SCHEMEWHITELIST.contains(scheme.toLowerCase(Locale.ROOT))) {
            log.error("{} scheme is not legal.", (Object)scheme);
            return false;
        }
        return true;
    }

    @Deprecated
    public static String generatePassword(int pwdLen) throws InvalidParameterException {
        return com.huawei.ism.tool.file.SecurityUtils.generatePassword((int)pwdLen);
    }

    static {
        SCHEMEWHITELIST.add("https");
    }
}

