/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.oss.cn.common.anonymize;

import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.oss.cn.common.Constant;
import com.huawei.oss.cn.common.anonymize.AnonymizeType;
import com.huawei.oss.cn.common.anonymize.AnonymizeUtil;
import com.huawei.oss.cn.common.anonymize.FileType;
import com.huawei.oss.cn.common.anonymize.IgnoreFileType;
import com.huawei.oss.cn.common.util.CommonFileUtils;
import com.huawei.oss.cn.common.util.CommonUtils;
import com.huawei.oss.cn.common.util.DecompresserUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAnonymizeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAnonymizeUtil.class);
    private static final String ARCHIVE_TEMP_PATH = Constant.HOME_PATH + File.separator + "tmp" + File.separator + "CNOSS" + File.separator + "archivetemp";
    private static final String TEMP_PATH = Constant.HOME_PATH + File.separator + "tmp" + File.separator + "CNOSS" + File.separator + "temp";

    private FileAnonymizeUtil() {
    }

    public static boolean anonymize(String anonymizePath, AnonymizeType type) {
        LOGGER.info("anonymize file path:{}, anonymize star time:{}", (Object)anonymizePath, (Object)new Date());
        boolean infoFilterResult = false;
        String path = FileAnonymizeUtil.checkValid(anonymizePath);
        if (null == path) {
            return infoFilterResult;
        }
        if (null == type) {
            type = AnonymizeType.TRACE;
        }
        File file = new File(path);
        FileAnonymizeUtil.anonymizeDir(file, type, "");
        LOGGER.info("anonymize file path:{}, anonymize end time:{}", (Object)anonymizePath, (Object)new Date());
        return true;
    }

    public static boolean anonymize(String anonymizePath, AnonymizeType type, String charSet) {
        LOGGER.info("anonymize file path:{}, anonymize star time:{}", (Object)anonymizePath, (Object)new Date());
        boolean infoFilterResult = false;
        String path = FileAnonymizeUtil.checkValid(anonymizePath);
        if (null == path) {
            return infoFilterResult;
        }
        if (null == type) {
            type = AnonymizeType.TRACE;
        }
        File file = new File(path);
        FileAnonymizeUtil.anonymizeDir(file, type, charSet);
        LOGGER.info("anonymize file path:{}, anonymize end time:{}", (Object)anonymizePath, (Object)new Date());
        return true;
    }

    public static boolean anonymize(String anonymizePath) {
        return FileAnonymizeUtil.anonymize(anonymizePath, null, "");
    }

    public static boolean anonymizeWithEncoding(String anonymizePath, String charSet) {
        return FileAnonymizeUtil.anonymize(anonymizePath, null, charSet);
    }

    private static void anonymizeDir(String path, AnonymizeType type) {
        File file = new File(path);
        FileAnonymizeUtil.anonymizeDir(file, type, "");
    }

    private static void anonymizeDir(File file, AnonymizeType type, String charSet) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] subFiles = file.listFiles();
                if (null != subFiles) {
                    for (File subFile : subFiles) {
                        FileAnonymizeUtil.anonymizeDir(subFile, type, charSet);
                    }
                } else {
                    LOGGER.info("There is no file in this dir, need not be anonymized.");
                }
            } else if (file.isFile()) {
                FileType filetype = FileAnonymizeUtil.parseFileType(file);
                if (filetype == FileType.NORMAL || filetype == FileType.CSV || filetype == FileType.JSON) {
                    try {
                        FileAnonymizeUtil.anonymizeFile(file.getCanonicalPath(), filetype, type, charSet);
                    }
                    catch (IOException e) {
                        LOGGER.error("Get the file path exception,flie Path is {}", (Object)file);
                    }
                } else if (filetype == FileType.IGNOREFILETYPE) {
                    LOGGER.info("The file is ignore file type:", (Object)file);
                } else {
                    FileAnonymizeUtil.deCompressArchiveFile(file, filetype, type);
                }
            }
        } else {
            LOGGER.info("This file is not exist, need not be anonymized.");
        }
    }

    private static FileType parseFileType(File file) {
        FileType type = FileType.NORMAL;
        String fileName = file.getName();
        int pos = fileName.lastIndexOf(".");
        if (pos > 0) {
            String ext2;
            String ext = fileName.substring(pos, fileName.length());
            if (ext.equalsIgnoreCase(".zip")) {
                type = FileType.ZIP;
            } else if (ext.equalsIgnoreCase(".tar")) {
                type = FileType.TAR;
            } else if (ext.equalsIgnoreCase(".csv")) {
                type = FileType.CSV;
            } else if (FileAnonymizeUtil.checkIgnoreFile(ext)) {
                type = FileType.IGNOREFILETYPE;
            } else if (ext.equalsIgnoreCase(".json")) {
                type = FileType.JSON;
            }
            fileName = fileName.substring(0, pos);
            pos = fileName.lastIndexOf(".");
            if (pos > 0 && (ext2 = fileName.substring(pos, fileName.length())).equalsIgnoreCase(".tar") && ext.equalsIgnoreCase(".gz")) {
                type = FileType.TAR_GZ;
            }
        }
        return type;
    }

    private static void deCompressArchiveFile(File file, FileType type, AnonymizeType anonymizeType) {
        String temp = ARCHIVE_TEMP_PATH;
        String fileName = file.getName();
        try {
            if (type == FileType.TAR) {
                temp = temp + File.separator + CommonUtils.getPid() + "_" + fileName.substring(0, fileName.length() - 4) + "_" + Constant.ATOMIC_INTEGER.incrementAndGet();
                DecompresserUtil.unTar(file, temp);
            } else if (type == FileType.TAR_GZ) {
                temp = temp + File.separator + CommonUtils.getPid() + "_" + fileName.substring(0, fileName.length() - 7) + "_" + Constant.ATOMIC_INTEGER.incrementAndGet();
                DecompresserUtil.unTarGz(file, temp);
            } else if (type == FileType.ZIP) {
                temp = temp + File.separator + CommonUtils.getPid() + "_" + fileName.substring(0, fileName.length() - 4) + "_" + Constant.ATOMIC_INTEGER.incrementAndGet();
                DecompresserUtil.unZip(file, temp);
            }
            FileAnonymizeUtil.anonymizeDir(temp, anonymizeType);
            ZipUtils.compressFile(temp + File.separator + fileName, temp);
            File zipFile = new File(temp + File.separator + fileName);
            String originalFileName = file.getCanonicalPath();
            LOGGER.info("delete result:{}", (Object)file.delete());
            LOGGER.info("rename result:{}", (Object)zipFile.renameTo(new File(originalFileName)));
            FileUtils.cleanDirectory((File)new File(temp));
            LOGGER.info("temp path:{}", (Object)temp);
            LOGGER.info("delete result:{}", (Object)new File(temp).delete());
        }
        catch (IOException e) {
            File tempFile = new File(temp + File.separator + fileName);
            LOGGER.info("delete result:{}", (Object)file.delete());
            LOGGER.info("delete result:{}", (Object)tempFile.delete());
            LOGGER.warn("when decompressFile error, delete this file. fileName is " + fileName);
        }
    }

    private static String checkValid(String anonymizePath) {
        if (null == anonymizePath) {
            return null;
        }
        File file = new File(anonymizePath);
        if (!file.exists()) {
            LOGGER.error("anonymizePath is not exists.");
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("getTempForInfoCollectionPath error, delete the file.");
            return null;
        }
    }

    public static String anonymizeMultiLine(String multiLine) {
        return FileAnonymizeUtil.anonymizeMultiLine(multiLine, AnonymizeType.TRACE);
    }

    public static String anonymizeMultiLine(String multiLine, AnonymizeType anonymizeType) {
        if (multiLine == null || multiLine.isEmpty()) {
            return multiLine;
        }
        if (anonymizeType == null) {
            anonymizeType = AnonymizeType.TRACE;
        }
        AnonymizeUtil anonymizeUtils = new AnonymizeUtil();
        StringBuilder sb = new StringBuilder();
        for (String line : multiLine.split("\\r?\\n")) {
            switch (anonymizeType) {
                case TRACE: {
                    line = anonymizeUtils.anonymizeStr(line);
                    break;
                }
                case LOG: {
                    line = anonymizeUtils.anonymizeForExport(line);
                    break;
                }
                case FILE: {
                    line = anonymizeUtils.anonymizeForFile(line);
                    break;
                }
                default: {
                    line = anonymizeUtils.anonymizeStr(line);
                }
            }
            sb.append(line);
            sb.append(System.lineSeparator());
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static void anonymizeFile(String fileName, FileType type, AnonymizeType anonymizeType, String charSet) {
        AnonymizeUtil anonymizeUtils = new AnonymizeUtil();
        boolean isCSV = type == FileType.CSV;
        File file = new File(fileName);
        String name = file.getName();
        String temp = null;
        temp = TEMP_PATH + File.separator + CommonUtils.getPid() + "_" + name + "_" + Constant.ATOMIC_INTEGER.incrementAndGet();
        CommonFileUtils.createDirectory(temp, null);
        temp = temp + File.separator + name;
        File tempOutFile = new File(temp);
        boolean result = FileAnonymizeUtil.checkIsResult(fileName, anonymizeType, anonymizeUtils, isCSV, tempOutFile, charSet);
        File ptempFile = tempOutFile.getParentFile();
        if (result) {
            file.delete();
            try {
                tempOutFile.renameTo(new File(fileName));
            }
            catch (Exception e) {
                LOGGER.error("move file:\"" + tempOutFile + "\" to file:\"" + fileName + "\" appear exception", (Throwable)e);
            }
        } else {
            LOGGER.info("delete result:{}", (Object)tempOutFile.delete());
        }
        LOGGER.info("delete result:{}", (Object)ptempFile.delete());
    }

    /*
     * Exception decompiling
     */
    private static boolean checkIsResult(String fileName, AnonymizeType anonymizeType, AnonymizeUtil anonymizeUtils, boolean isCSV, File tempOutFile, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean checkIgnoreFile(String ext) {
        for (IgnoreFileType ignoreFileType : IgnoreFileType.values()) {
            if (!ext.equalsIgnoreCase(ignoreFileType.getName())) continue;
            return true;
        }
        return false;
    }
}

