/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.oss.cn.common.fileutils;

import com.huawei.oss.cn.common.fileutils.FileReader;
import com.huawei.oss.cn.common.fileutils.FileTooLargeException;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertFileEncode {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertFileEncode.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertFileEncode(String srcPath, String destPath, String srcCharset, String destCharSet) throws FileTooLargeException, FileNotFoundException, UnsupportedEncodingException, IOException {
        BufferedWriter writer;
        OutputStreamWriter outputStreamWriter;
        FileOutputStream outstream;
        block10: {
            LOGGER.info("Enter in ConvertFileEncode:{} to {}", (Object)srcCharset, (Object)destCharSet);
            File currentSrcFile = new File(srcPath);
            File tempOutFile = new File(destPath);
            FileInputStream instream = null;
            outstream = null;
            outputStreamWriter = null;
            writer = null;
            try {
                instream = new FileInputStream(currentSrcFile);
                ConvertFileEncode.checkFileSize(instream);
                outstream = new FileOutputStream(tempOutFile);
                outputStreamWriter = new OutputStreamWriter((OutputStream)outstream, destCharSet);
                writer = new BufferedWriter(outputStreamWriter);
                byte[] buf = new byte[1024];
                FileReader reader = new FileReader(instream, srcCharset);
                int iLen = reader.read(buf);
                while (iLen != -1) {
                    String sout = new String(buf, 0, iLen, srcCharset);
                    writer.write(sout);
                    writer.flush();
                    iLen = reader.read(buf);
                }
                if (instream == null) break block10;
            }
            catch (Throwable throwable) {
                if (instream != null) {
                    ConvertFileEncode.safeClose(instream);
                }
                if (writer != null) {
                    ConvertFileEncode.safeClose(writer);
                }
                if (outputStreamWriter != null) {
                    ConvertFileEncode.safeClose(outputStreamWriter);
                }
                if (outstream != null) {
                    ConvertFileEncode.safeClose(outstream);
                }
                throw throwable;
            }
            ConvertFileEncode.safeClose(instream);
        }
        if (writer != null) {
            ConvertFileEncode.safeClose(writer);
        }
        if (outputStreamWriter != null) {
            ConvertFileEncode.safeClose(outputStreamWriter);
        }
        if (outstream != null) {
            ConvertFileEncode.safeClose(outstream);
        }
    }

    private static void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOGGER.error("Close Stream error:" + e.getMessage());
        }
    }

    private static void checkFileSize(InputStream instream) throws FileTooLargeException, IOException {
        if (instream.available() > 0xA00000) {
            LOGGER.error("File is too larger, maxSize is 10M.");
            throw new FileTooLargeException("File size is too large.");
        }
    }
}

