/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.oss.cn.common.fileutils;

import com.huawei.oss.cn.common.fileutils.FileTooLargeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileReader.class);
    private static final int MAXSIZE = 10;
    private InputStream inStream = null;
    private byte[] buf;
    private int currChar;
    private char[] buffChar;
    private StringBuffer left = new StringBuffer("");
    private int maxFileSize = 10;
    private static final int BUFFER_SIZE = 1024;
    private String charSet;
    private String lineSep;

    public FileReader(InputStream inStream) throws FileTooLargeException, UnsupportedEncodingException, IOException {
        this(inStream, 10, "utf-8");
    }

    public FileReader(InputStream inStream, String charSet) throws FileTooLargeException, UnsupportedEncodingException, IOException {
        this(inStream, 10, charSet);
    }

    public FileReader(InputStream inStream, int maxFileSize, String charSet) throws FileTooLargeException, UnsupportedEncodingException, IOException {
        if (null == inStream) {
            throw new IOException("Stream has been closed.");
        }
        if (null == charSet) {
            throw new IOException("CharSet is null.");
        }
        this.inStream = inStream;
        this.maxFileSize = maxFileSize;
        this.charSet = charSet;
        this.currChar = 0;
        this.buf = new byte[1024];
        this.lineSep = null;
        this.buffChar = "".toCharArray();
        this.checkFileSize();
    }

    public String getLineSep() {
        return this.lineSep == null ? File.separator : this.lineSep;
    }

    private void checkFileSize() throws FileTooLargeException, IOException {
        if ((long)this.inStream.available() > (long)(this.maxFileSize * 1024) * 1024L) {
            LOGGER.error("File is too larger, maxSize is " + this.maxFileSize + "M.");
            throw new FileTooLargeException("File size is too large.");
        }
    }

    public String readLineWithEndChar() throws UnsupportedEncodingException, IOException {
        if (this.buffChar == null) {
            return null;
        }
        if (this.currChar >= this.buffChar.length) {
            this.currChar = 0;
            this.read();
        }
        return this.handleContext();
    }

    public String readLine() throws UnsupportedEncodingException, IOException {
        int pos;
        String str = this.readLineWithEndChar();
        if (str != null && this.lineSep != null && (pos = str.indexOf(this.lineSep)) != -1) {
            str = str.substring(0, pos);
        }
        return str;
    }

    private void read() throws IOException {
        int iLen = this.read(this.buf);
        if (iLen != -1) {
            String bufRead = new String(this.buf, 0, iLen, this.charSet);
            if (bufRead != null && !bufRead.isEmpty()) {
                this.buffChar = bufRead.toCharArray();
            }
        } else {
            LOGGER.info("Read file end, set buffChar=null.");
            this.buffChar = null;
        }
    }

    public int read(byte[] buffer) throws IOException {
        int iLen = this.inStream.read(buffer, 0, 100);
        if (iLen != -1) {
            int i;
            int zhCnt = 0;
            for (i = 0; i < iLen; ++i) {
                if (buffer[i] >= 0) continue;
                ++zhCnt;
            }
            int byteCntpreChar = 2;
            if (this.charSet.equalsIgnoreCase("utf-8")) {
                byteCntpreChar = 3;
            }
            if ((i = this.inStream.read(buffer, iLen, (byteCntpreChar - zhCnt % byteCntpreChar) % byteCntpreChar)) > 0) {
                iLen += i;
            }
        }
        return iLen;
    }

    private String handleContext() throws UnsupportedEncodingException, IOException {
        String result = "";
        if (this.buffChar == null && this.left != null) {
            result = this.left.toString();
            this.left = null;
            return result;
        }
        if (this.buffChar != null && this.left != null) {
            while (this.currChar < this.buffChar.length) {
                char t = this.buffChar[this.currChar];
                this.left.append(t);
                if (t == '\n') {
                    if (this.lineSep == null) {
                        this.lineSep = this.currChar == 0 || this.buffChar[this.currChar - 1] != '\r' ? "\n" : "\r\n";
                    }
                    ++this.currChar;
                    result = this.left.toString();
                    this.left = new StringBuffer();
                    return result;
                }
                ++this.currChar;
            }
        }
        this.currChar = 0;
        this.read();
        result = this.handleContext();
        return result;
    }
}

