/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.oss.cn.common.util;

import com.huawei.ism.tool.base.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompresserUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecompresserUtil.class);

    public static void unTar(File file, String outputDir) throws IOException {
        if (!ZipUtils.decompressTarFile(file, outputDir)) {
            throw new IOException(String.format(Locale.ROOT, "un tar error,file name:%s", file.getName()));
        }
    }

    public static void unTarGz(File file, String outputDir) throws IOException {
        ZipUtils.decompressTarGzFile(file, outputDir);
    }

    public static void unZip(File file, String outputDir) {
        try {
            ZipUtils.decompressFile(file, outputDir);
        }
        catch (IOException ex) {
            LOGGER.error("untar file failed.", (Throwable)ex);
        }
    }
}

