/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.reflection.PrimitiveParser;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public final class ClassUtils {
    public static final Map<String, Class<?>> PRIM_CLASS_MAP = new HashMap(8, 1.0f);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ClassUtils.class);
    private static final Map<Class<?>, PrimitiveParser> PRIMPARSERS = new HashMap(8, 1.0f);

    public static Method toSetMethod(Class<?> clazz, String field, Class<?>[] paramTypes) {
        String set = "set" + field.substring(0, 1).toUpperCase(Locale.ENGLISH) + field.substring(1);
        return ClassUtils.getClassMethod(clazz, set, paramTypes);
    }

    public static Method toGetMethod(Class<?> clazz, String field) {
        String get = "get" + field.substring(0, 1).toUpperCase(Locale.ENGLISH) + field.substring(1);
        return ClassUtils.getClassMethod(clazz, get, new Class[0]);
    }

    public static Method toIsMethod(Class<?> clazz, String field) {
        String get = "is" + field.substring(0, 1).toUpperCase(Locale.ENGLISH) + field.substring(1);
        return ClassUtils.getClassMethod(clazz, get, new Class[0]);
    }

    public static Method toAddMethod(Class<?> clazz, String field, Class<?>[] paramTypes) {
        String add = "add" + field.substring(0, 1).toUpperCase(Locale.ENGLISH) + field.substring(1);
        return ClassUtils.getClassMethod(clazz, add, paramTypes);
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?>[] paramTypes) {
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(paramTypes);
        }
        catch (Exception e) {
            StringBuffer params = new StringBuffer();
            for (Class<?> type : paramTypes) {
                params.append(type.getName() + ",");
            }
            LOGGER.error("Get constructor error for class: " + clazz.getName() + ", parameters: " + params, (Throwable)e);
        }
        return constructor;
    }

    public static Class<?> getClazz(String className) {
        Class<?> clazz = PRIM_CLASS_MAP.get(className);
        if (null == clazz && null != className) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Cannot load class for type: " + className, (Throwable)e);
            }
        }
        return clazz;
    }

    public static Object parsePrimitive(Class<?> type, String str) {
        Object obj = null;
        PrimitiveParser parser = PRIMPARSERS.get(type);
        if (null != parser) {
            obj = parser.parseValue(str);
        }
        return obj;
    }

    public static String objectToString(Object obj) {
        String str = null;
        str = null == obj ? "" : (obj.getClass().isPrimitive() ? String.valueOf(obj) : obj.toString());
        return str;
    }

    public static Object stringToObject(Class<?> clazz, String str) {
        Constructor<?> constr;
        Object obj = null;
        if (clazz.isPrimitive()) {
            obj = ClassUtils.parsePrimitive(clazz, str);
        } else if (!clazz.equals(String.class) && null != (constr = ClassUtils.getConstructor(clazz, new Class[]{String.class}))) {
            try {
                obj = constr.newInstance(str);
            }
            catch (Exception e) {
                LOGGER.error("Invoke constructor error:" + clazz.getName() + ", parameter: " + str, (Throwable)e);
            }
        }
        return obj;
    }

    public static Object[] objectToArray(Object value) {
        Object[] arr = null;
        if (null == value) {
            return arr;
        }
        if (value.getClass().isArray()) {
            arr = (Object[])value;
        } else {
            try {
                Method toArray = value.getClass().getMethod("toArray", new Class[0]);
                arr = (Object[])toArray.invoke(value, new Object[0]);
            }
            catch (RuntimeException e) {
                arr = new Object[]{};
            }
            catch (Exception e) {
                arr = new Object[]{};
            }
        }
        return arr;
    }

    private static Method getClassMethod(Class<?> clazz, String mtdName, Class<?>[] paramTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(mtdName, paramTypes);
        }
        catch (Exception e) {
            StringBuffer params = new StringBuffer();
            for (Class<?> type : paramTypes) {
                params.append(type.getName() + ",");
            }
            LOGGER.error("Get Class method error. Class: " + clazz.getName() + ", method: " + mtdName + ", parameters: " + params.toString(), (Throwable)e);
        }
        return method;
    }

    public static List<String> toStringList(List<?> objList) {
        ArrayList<String> strList = new ArrayList<String>();
        if (null != objList) {
            for (Object obj : objList) {
                strList.add(obj.toString());
            }
        }
        return strList;
    }

    public static String[] toStringArray(Object ... objArray) {
        String[] strArr = new String[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            strArr[i] = objArray[i].toString();
        }
        return strArr;
    }

    public static <T> List<T> parseEnumList(Class<T> enumType, List<String> strList) {
        ArrayList<T> enumList = new ArrayList<T>();
        if (null == enumType || !enumType.isEnum()) {
            return enumList;
        }
        for (String str : strList) {
            enumList.add(Enum.valueOf(enumType, str));
        }
        return enumList;
    }

    public static <T> List<T> parseEnumList(Class<T> enumType, String ... strArr) {
        return ClassUtils.parseEnumList(enumType, Arrays.asList(strArr));
    }

    private ClassUtils() {
    }

    static {
        PRIM_CLASS_MAP.put("boolean", Boolean.TYPE);
        PRIM_CLASS_MAP.put("byte", Byte.TYPE);
        PRIM_CLASS_MAP.put("char", Character.TYPE);
        PRIM_CLASS_MAP.put("short", Short.TYPE);
        PRIM_CLASS_MAP.put("int", Integer.TYPE);
        PRIM_CLASS_MAP.put("long", Long.TYPE);
        PRIM_CLASS_MAP.put("float", Float.TYPE);
        PRIM_CLASS_MAP.put("double", Double.TYPE);
        PRIM_CLASS_MAP.put("void", Void.TYPE);
        PRIMPARSERS.put(Boolean.TYPE, new PrimitiveParser.BooleanParser());
        PRIMPARSERS.put(Byte.TYPE, new PrimitiveParser.ByteParser());
        PRIMPARSERS.put(Character.TYPE, new PrimitiveParser.CharParser());
        PRIMPARSERS.put(Short.TYPE, new PrimitiveParser.ShortParser());
        PRIMPARSERS.put(Integer.TYPE, new PrimitiveParser.IntegerParser());
        PRIMPARSERS.put(Long.TYPE, new PrimitiveParser.LongParser());
        PRIMPARSERS.put(Float.TYPE, new PrimitiveParser.FloatParser());
        PRIMPARSERS.put(Double.TYPE, new PrimitiveParser.DoubleParser());
    }
}

