/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.exception.SupportException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.LoggerFactory;

public class PkgSupportCheckUtils {
    private static final String TOOL_ID = "tool.name";
    private static final String TOOL_VER = "tool.version";
    private static final String TOOL_SUPPORT_DATE = "supported.package.date";
    private static final String PKG_PARENT_ID = "package.type";
    private static final String PKG_DATE = "date";

    public static void checkPkgSupport(String toolIniPath, String pkgZipPath) throws SupportException {
        File toolIni = new File(toolIniPath);
        if (!toolIni.exists()) {
            return;
        }
        IniReader toolRder = new IniReader(toolIni);
        String toolId = toolRder.getString(TOOL_ID);
        String toolVer = toolRder.getString(TOOL_VER);
        String supportPkgDate = toolRder.getString(TOOL_SUPPORT_DATE);
        ZipFile pkgZip = null;
        InputStream in = null;
        IniReader pkgRder = null;
        try {
            pkgZip = new ZipFile(pkgZipPath);
            ZipEntry entry = pkgZip.getEntry("package.ini");
            if (null == entry) {
                throw new SupportException("tool.support.not.exists");
            }
            in = pkgZip.getInputStream(entry);
            pkgRder = new IniReader(in);
        }
        catch (IOException e) {
            try {
                throw new SupportException("tool.support.not.exists", e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, in);
                PkgSupportCheckUtils.closeZipFile(pkgZip);
                throw throwable;
            }
        }
        StreamUtils.closeStream(null, in);
        PkgSupportCheckUtils.closeZipFile(pkgZip);
        String parentId = pkgRder.getString(PKG_PARENT_ID);
        String pkgDate = pkgRder.getString(PKG_DATE);
        String parentVer = pkgRder.getString(TOOL_VER);
        if (!toolId.equals(parentId)) {
            throw new SupportException("tool.support.not.exists");
        }
        if (supportPkgDate.compareTo(pkgDate) > 0) {
            throw new SupportException("tool.support.not.pkg");
        }
        if (parentVer.compareTo(toolVer) > 0) {
            throw new SupportException("tool.support.not.tool");
        }
    }

    private static void closeZipFile(ZipFile pkgZip) {
        if (null == pkgZip) {
            return;
        }
        try {
            pkgZip.close();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PkgSupportCheckUtils.class).error("tool.support.not.exists.", (Throwable)e);
        }
    }
}

