/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.PatchUtil;
import com.huawei.ism.tool.base.utils.RSAUtils;
import com.huawei.ism.tool.base.utils.SHA256Check;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHAAndRSAVerifyUtils {
    private static final Logger log = LoggerFactory.getLogger(SHAAndRSAVerifyUtils.class);
    private static final String[] ORIGIN_FILE_SUFFIX = new String[]{"py"};
    private static boolean isSignCheckRemoved = false;
    private static final SHAAndRSAVerifyUtils INSTANCE = new SHAAndRSAVerifyUtils();
    private static final String SHA_VERIFYFILE_EXTENDNAME = ".sign";
    private static final String CLASS_EXTENDNAME = ".class";
    private static final String SVN_FORDER = ".svn";
    private static final String IMPORT_CONSTANTS = "import";
    private static final String FROM_CONSTANTS = "from";
    private static final String JYTHO_IMPORT_SPLIT = ".";

    private SHAAndRSAVerifyUtils() {
    }

    public static SHAAndRSAVerifyUtils getInstance() {
        return INSTANCE;
    }

    public boolean verify(File verifySrcFile, List<String> classPath, String[] extend, boolean isIpmort) throws Exception {
        if (!verifySrcFile.exists()) {
            log.error("verfiy file not exists.{}", (Object)verifySrcFile.getCanonicalPath());
            return false;
        }
        if (verifySrcFile.isDirectory()) {
            List<File> files = this.getFiles(verifySrcFile, extend);
            if (files.isEmpty()) {
                return true;
            }
            for (File file : files) {
                if (this.verifyFile(file, classPath, isIpmort)) continue;
                return false;
            }
            return true;
        }
        return this.verifyFile(verifySrcFile, classPath, isIpmort);
    }

    public boolean verify(File verifySrcFile) throws Exception {
        if (!verifySrcFile.exists()) {
            log.error("verfiy file not exists." + verifySrcFile.getCanonicalPath());
            return false;
        }
        if (verifySrcFile.isDirectory()) {
            List<File> files = this.getFiles(verifySrcFile, null);
            if (files.isEmpty()) {
                return true;
            }
            for (File file : files) {
                if (this.excuteVerify(file)) continue;
                log.error("verfiy error." + file.getCanonicalPath());
                return false;
            }
            return true;
        }
        return this.excuteVerify(verifySrcFile);
    }

    private boolean verifyFile(File verifySrcFile, List<String> classPath, boolean isIpmort) throws Exception {
        HashSet<File> fileSet = new HashSet<File>();
        fileSet.add(verifySrcFile);
        if (isIpmort && null != classPath) {
            Set<File> importFile = SHAAndRSAVerifyUtils.getInstance().getImportFiles(verifySrcFile, classPath);
            fileSet.addAll(importFile);
        }
        for (File file : fileSet) {
            if (this.excuteVerify(file)) continue;
            return false;
        }
        return true;
    }

    private List<File> getFiles(File destDir, String[] extend) {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] fs = destDir.listFiles(new MyCusFilter(extend));
        if (null == fs) {
            return fileList;
        }
        for (File f : fs) {
            if (f.isFile()) {
                fileList.add(f);
                continue;
            }
            if (!f.isDirectory() || SVN_FORDER.equals(f.getName())) continue;
            fileList.addAll(this.getFiles(f, extend));
        }
        return fileList;
    }

    public boolean excuteVerify(File verifySrcFile) {
        if (isSignCheckRemoved) {
            return isSignCheckRemoved;
        }
        String userHome = System.getProperty("user.home");
        String unAuthFilePath = FilePathUtils.getSafePath(userHome + File.separator + "authtoolkit.data");
        File unAuthFile = new File(unAuthFilePath);
        if (unAuthFile.exists() && this.isAuthFileValid(unAuthFile) && this.verifySingleFile(unAuthFile)) {
            isSignCheckRemoved = true;
            return true;
        }
        if (!ApplicationContext.getInstance().isValidSign()) {
            log.info("verify pyframe.jar file fail");
            return false;
        }
        return this.verifySingleFile(verifySrcFile);
    }

    public boolean excuteVerify(String verifySrcFile) {
        try {
            return this.excuteVerify(new File(verifySrcFile));
        }
        catch (Exception e) {
            log.error("verify cms for file {} error", (Object)new File(verifySrcFile).getName(), (Object)e);
            return false;
        }
    }

    private boolean isAuthFileValid(File unAuthFile) {
        try {
            String result = new String(Files.readAllBytes(Paths.get(unAuthFile.getCanonicalPath(), new String[0])));
            String ipConfigResult = OSCmdUtils.executeCmd("ipconfig");
            return result.equals(ipConfigResult);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verifySingleFileForCBB(File verifySrcFile) {
        return this.verifySingleFile(verifySrcFile);
    }

    public void verifyDirectoryFiles(String path) throws IOException, ToolException {
        File file = new File(path);
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean result;
                String fileName = files[i].getName();
                if (files[i].isDirectory()) {
                    this.verifyDirectoryFiles(files[i].getCanonicalPath());
                    continue;
                }
                if (fileName.endsWith(SHA_VERIFYFILE_EXTENDNAME) || !this.isFileInSignWhiteList(fileName) || files[i].length() == 0L || (result = this.verifySingleFileForCBB(files[i]))) continue;
                log.error("verify file: {} fail", (Object)files[i].getName());
                throw new ToolException("verify directory files fail");
            }
        }
    }

    public boolean isFileInSignWhiteList(String fileName) {
        if (fileName.indexOf(JYTHO_IMPORT_SPLIT) == -1) {
            return false;
        }
        int lastIndexOf = fileName.lastIndexOf(JYTHO_IMPORT_SPLIT) + 1;
        String suffix = fileName.substring(lastIndexOf);
        if (StringUtils.isNULLStr(suffix)) {
            return false;
        }
        return Arrays.asList(ORIGIN_FILE_SUFFIX).contains(suffix);
    }

    private boolean verifySingleFile(File verifySrcFile) {
        File shaFile = new File(verifySrcFile.getParentFile(), verifySrcFile.getName() + SHA_VERIFYFILE_EXTENDNAME);
        if (!shaFile.exists()) {
            return false;
        }
        try {
            byte[] signData = StreamUtils.readBytesFromFile(shaFile);
            if (signData == null || signData.length == 0) {
                return false;
            }
            String sha256code = SHA256Check.getInstance().getHash(verifySrcFile.getCanonicalPath());
            return RSAUtils.verify(sha256code.getBytes(Charset.forName("UTF-8")), PatchUtil.importRSAKey(), signData);
        }
        catch (Exception e) {
            log.error("verify single file error.", (Throwable)e);
            return false;
        }
    }

    private static String getSuffix(String fileName) {
        return -1 == fileName.indexOf(JYTHO_IMPORT_SPLIT) ? "" : fileName.substring(fileName.lastIndexOf(JYTHO_IMPORT_SPLIT) + 1, fileName.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Set<File> getImportFiles(File verifyScrFile, List<String> jythonEnPath) {
        HashSet<File> importSet = new HashSet<File>();
        BufferedReader reader = null;
        String line = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(FilePathUtils.checkFile(verifyScrFile));
            reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
            while (null != (line = reader.readLine())) {
                File file;
                if (!(line = Normalizer.normalize(line, Normalizer.Form.NFKC)).startsWith(IMPORT_CONSTANTS) && !this.checkContainFromImport(line) || null == (file = this.parseFile(line.trim(), jythonEnPath))) continue;
                importSet.add(file);
                Set<File> tmp = this.getImportFiles(file, jythonEnPath);
                if (tmp.isEmpty()) continue;
                importSet.addAll(tmp);
            }
        }
        catch (RuntimeException e) {
            log.error("Read error.", (Throwable)e);
            StreamUtils.closeStream(null, input);
            StreamUtils.closeResource(null, reader);
        }
        catch (Exception e2) {
            log.error("Read error.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, input);
                    StreamUtils.closeResource(null, reader);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, input);
            StreamUtils.closeResource(null, reader);
        }
        StreamUtils.closeStream(null, input);
        StreamUtils.closeResource(null, reader);
        return importSet;
    }

    private boolean checkContainFromImport(String content) {
        String normalizedContent = Normalizer.normalize(content, Normalizer.Form.NFKC);
        return normalizedContent.startsWith(FROM_CONSTANTS) && normalizedContent.contains(IMPORT_CONSTANTS);
    }

    private File parseFile(String line, List<String> jythonEnPath) {
        String afterImport = "";
        String normalizedLine = Normalizer.normalize(line, Normalizer.Form.NFKC);
        if (normalizedLine.startsWith(IMPORT_CONSTANTS)) {
            afterImport = normalizedLine.substring(normalizedLine.indexOf(IMPORT_CONSTANTS) + IMPORT_CONSTANTS.length()).trim();
            return this.constructFile(jythonEnPath, afterImport);
        }
        afterImport = normalizedLine.substring(normalizedLine.indexOf(FROM_CONSTANTS) + FROM_CONSTANTS.length(), normalizedLine.indexOf(IMPORT_CONSTANTS)).trim();
        return this.constructFile(jythonEnPath, afterImport);
    }

    private File constructFile(List<String> jythonEnPath, String afterImport) {
        String[] importPathStr = afterImport.split("[.]");
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < importPathStr.length; ++i) {
            if (i == importPathStr.length - 1) {
                path.append(File.separator);
                path.append(importPathStr[i]);
                path.append(".py");
                continue;
            }
            path.append(File.separator);
            path.append(importPathStr[i]);
        }
        for (String pathTmp : jythonEnPath) {
            File file = new File(pathTmp);
            File jythonFile = new File(pathTmp + path.toString());
            if (!file.exists() || !jythonFile.exists()) continue;
            return jythonFile;
        }
        return null;
    }

    public boolean verifyByStr(File verifySrcFile, String shaVerifyCode) {
        if (!verifySrcFile.exists()) {
            log.error("verfiy file not exists.");
            return false;
        }
        if (StringUtils.isNULLStr(shaVerifyCode)) {
            log.error("verfiy code is empty.");
            return false;
        }
        String actualShaVerifyCode = RSAUtils.decrypt(RSAUtils.getPublicKey(PatchUtil.importRSAKey()), shaVerifyCode);
        try {
            String fileHash = SHA256Check.getInstance().getHash(verifySrcFile.getCanonicalPath());
            return fileHash.equals(actualShaVerifyCode);
        }
        catch (IOException e) {
            log.error("verfiy code is error.", (Throwable)e);
            return false;
        }
    }

    private static final class MyCusFilter
    implements FilenameFilter {
        private final String[] extend;

        private MyCusFilter(String[] extend) {
            this.extend = extend;
        }

        @Override
        public boolean accept(File file, String fileName) {
            if (fileName.endsWith(SHAAndRSAVerifyUtils.SHA_VERIFYFILE_EXTENDNAME) || fileName.endsWith(SHAAndRSAVerifyUtils.CLASS_EXTENDNAME)) {
                return false;
            }
            if (null == this.extend || 0 == this.extend.length) {
                return true;
            }
            for (String suffix : this.extend) {
                if (!suffix.equals(SHAAndRSAVerifyUtils.getSuffix(fileName))) continue;
                return true;
            }
            return false;
        }
    }
}

