/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.aescache;

import com.huawei.ism.tool.base.utils.aescache.DelayedItem;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class AESCache {
    private static volatile AESCache instance = null;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AESCache.class);
    private ConcurrentHashMap<String, String> conHashMap = new ConcurrentHashMap();
    private DelayQueue<DelayedItem<String>> delayQueue = new DelayQueue();

    private AESCache() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AESCache.this.removeExpiredItem();
            }
        }, "AESCache-DelayQueue").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AESCache getInstance() {
        if (null != instance) return instance;
        Class<AESCache> clazz = AESCache.class;
        synchronized (AESCache.class) {
            if (null != instance) return instance;
            instance = new AESCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void put(String key, String value, long time) {
        this.put(key, value, time, TimeUnit.MILLISECONDS);
    }

    public void put(String key, String value, long time, TimeUnit unit) {
        if (null == key) {
            return;
        }
        String v2 = this.conHashMap.put(key, value);
        DelayedItem<String> tmpItem = new DelayedItem<String>(key, TimeUnit.NANOSECONDS.convert(time, unit));
        if (v2 != null) {
            this.delayQueue.remove(tmpItem);
        }
        this.delayQueue.put(tmpItem);
    }

    public String getValueByKey(String key) {
        return null != key ? this.conHashMap.get(key) : null;
    }

    private void removeExpiredItem() {
        DelayedItem delayedItem = null;
        while (true) {
            try {
                while (true) {
                    if ((delayedItem = (DelayedItem)this.delayQueue.take()) == null) {
                        continue;
                    }
                    this.conHashMap.remove(delayedItem.getItemKey());
                }
            }
            catch (Exception e) {
                this.handelException();
                LOGGER.error("an Exception happened in delayQuene:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void handelException() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            LOGGER.error("an Exception happened in thread sleep:", (Throwable)e);
        }
    }
}

