/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.scenedata;

import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SecureObjectInputStream
extends ObjectInputStream {
    private List<String> trustlist = new ArrayList<String>();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SecureObjectInputStream.class);

    public SecureObjectInputStream(FileInputStream in, List<String> list) throws IOException, SecurityException {
        super(in);
        if (!VerifyUtil.isEmpty(list)) {
            this.trustlist.addAll(list);
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (!VerifyUtil.isEmpty(this.trustlist) && !this.trustlist.stream().anyMatch(name -> name.equalsIgnoreCase(desc.getName()))) {
            throw new ClassNotFoundException(desc.getName() + " not find");
        }
        return super.resolveClass(desc);
    }
}

