/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.silentprocess;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessAnalyzeSummary;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SilentProcessToFile {
    private static final String TOTAL_TIME = "totalTime";
    private static final String ZERO = "0";
    private static final String ERR_MSG = "errMsg";
    private static final String NOT_CHECK_NUM = "notCheckNum";
    private static final String RISK_DISK_NUM = "riskDiskNum";
    private static final String TOTAL_DISK_NUM = "totalDiskNum";
    private static final String SERIALNO = "serialNo";
    private static final String RESULT = "result";
    private static final String UPDATE_TIME = "updateTime";
    private static final String PROGRESS = "progress";
    private static final String SUCCESS = "success";
    private static final String STATUS = "status";
    private static final String PASSRATE = "passRate";
    private static final String RETURN_DATA = "returnData";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SilentProcessToFile.class);
    private static final String PROGRESS_XML = "Progress.xml";

    public static synchronized boolean updateDeviceData(List<SilentProcessData> dataList, String path) {
        for (SilentProcessData data : dataList) {
            SilentProcessToFile.updateDeviceData(data, path);
        }
        return true;
    }

    public static synchronized boolean updateDevsData(List<SilentProcessData> dataList, String path) {
        File file = new File(path, PROGRESS_XML);
        if (!file.exists()) {
            LOGGER.error("Progress file not exist.");
            return false;
        }
        try {
            Document document = XmlUtils.getSaxReader().read(file);
            org.dom4j.Element root = document.getRootElement();
            List elements = root.elements();
            if (null == elements || elements.isEmpty()) {
                LOGGER.info("Init device data,data size {}", (Object)dataList.size());
                for (SilentProcessData data2 : dataList) {
                    SilentProcessToFile.addDeviceElement(root, data2);
                }
            }
            dataList.forEach(data -> {
                SilentProcessToFile.buildSummary(data, root);
                List elementz = root.elements();
                boolean exist = false;
                for (org.dom4j.Element element : elementz) {
                    if (!element.attributeValue(SERIALNO).contains(data.getDevNode().getDeviceSerialNumber())) continue;
                    exist = true;
                }
                if (!exist) {
                    SilentProcessToFile.addDeviceElement(root, data);
                }
                SilentProcessToFile.queryAnalyDeviceData(root, data);
            });
            SilentProcessToFile.writeDataToXml(file, document);
        }
        catch (Exception e) {
            LOGGER.error("update progress error.", (Throwable)e);
            return false;
        }
        return true;
    }

    public static synchronized boolean updateDeviceData(SilentProcessData data, String path) {
        File file = new File(path, PROGRESS_XML);
        if (file.exists()) {
            try {
                Document document = XmlUtils.getSaxReader().read(file);
                org.dom4j.Element root = document.getRootElement();
                SilentProcessToFile.buildSummary(data, root);
                List elements = root.elements();
                if (null == elements || elements.isEmpty()) {
                    return SilentProcessToFile.createDeviceData(data, path);
                }
                if (SilentProcessToFile.addDeviceElement(data, elements, path)) {
                    return false;
                }
                SilentProcessToFile.queryAnalyDeviceData(root, data);
                SilentProcessToFile.writeDataToXml(file, document);
                return true;
            }
            catch (DocumentException e) {
                LOGGER.error("document is error...", (Throwable)e);
                return false;
            }
            catch (IOException e) {
                LOGGER.error("document is error...", (Throwable)e);
                return false;
            }
            catch (SAXException e) {
                LOGGER.error("document is error...", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private static void buildSummary(SilentProcessData data, org.dom4j.Element root) {
        SilentProcessAnalyzeSummary summary = data.getSummary();
        if (null != summary) {
            int totalDiskNum = Integer.valueOf(root.attributeValue(TOTAL_DISK_NUM));
            int riskDiskNum = Integer.valueOf(root.attributeValue(RISK_DISK_NUM));
            int notCheckNum = Integer.valueOf(root.attributeValue(NOT_CHECK_NUM));
            LOGGER.info("current disk count: {} ,riskDiskNum: {} ,notCheckNum:{}. ", new Object[]{totalDiskNum, riskDiskNum, notCheckNum});
            root.addAttribute(NOT_CHECK_NUM, String.valueOf(notCheckNum + summary.getFailedDiskNum()));
            root.addAttribute(TOTAL_DISK_NUM, String.valueOf(totalDiskNum + summary.getTotalDiskNum()));
            root.addAttribute(RISK_DISK_NUM, String.valueOf(riskDiskNum + summary.getRiskDiskNum()));
        }
    }

    private static synchronized boolean addDeviceElement(SilentProcessData data, List<org.dom4j.Element> elements, String path) {
        ArrayList<String> snLists = new ArrayList<String>();
        for (org.dom4j.Element element : elements) {
            snLists.add(element.attributeValue(SERIALNO));
        }
        if (snLists.contains(data.getDevNode().getDeviceSerialNumber())) {
            return false;
        }
        return SilentProcessToFile.createDeviceData(data, path);
    }

    public static synchronized boolean updateProcessData(SilentProcessData data, String path) {
        File file = new File(path, PROGRESS_XML);
        if (file.exists()) {
            try {
                Document document = XmlUtils.getSaxReader().read(file);
                org.dom4j.Element processNode = document.getRootElement();
                processNode.addAttribute(PROGRESS, data.getProcess());
                processNode.addAttribute(STATUS, data.getStatus());
                processNode.addAttribute(RESULT, data.getResult());
                processNode.addAttribute(ERR_MSG, data.getErrMsg() == null ? "" : data.getErrMsg());
                processNode.addAttribute(UPDATE_TIME, SilentProcessToFile.getCurrentTime());
                SilentProcessToFile.writeDataToXml(file, document);
                return true;
            }
            catch (DocumentException e) {
                LOGGER.error("update progress element is error..." + (Object)((Object)e));
                return false;
            }
            catch (IOException e) {
                LOGGER.error("update progress element is error..." + e);
                return false;
            }
            catch (SAXException e) {
                LOGGER.error("update progress element is error..." + e);
                return false;
            }
        }
        return false;
    }

    public static synchronized boolean createProgressData(SilentProcessData data, String path) {
        File file = new File(path, PROGRESS_XML);
        if (file.exists()) {
            FileUtils.deleteFile(file);
        }
        SilentProcessToFile.createFile(data, file);
        return true;
    }

    private static boolean createDeviceData(SilentProcessData data, String path) {
        File file = new File(path, PROGRESS_XML);
        if (file.exists()) {
            try {
                Document document = XmlUtils.getSaxReader().read(file);
                org.dom4j.Element processNode = document.getRootElement();
                SilentProcessToFile.addDeviceElement(processNode, data);
                SilentProcessToFile.writeDataToXml(file, document);
                return true;
            }
            catch (DocumentException e) {
                LOGGER.error("update progress element is error..." + (Object)((Object)e));
                return false;
            }
            catch (IOException e) {
                LOGGER.error("update progress element is error..." + e);
                return false;
            }
            catch (SAXException e) {
                LOGGER.error("update progress element is error..." + e);
                return false;
            }
        }
        return false;
    }

    private static void createFile(SilentProcessData data, File file) {
        try {
            SilentProcessToFile.createProgressXml(data, file);
        }
        catch (IOException e) {
            LOGGER.error("create progress file is error..." + e);
        }
        catch (TransformerConfigurationException e) {
            LOGGER.error("create progress file is error..." + e);
        }
        catch (TransformerFactoryConfigurationError e) {
            LOGGER.error("create progress file is error..." + e);
        }
        catch (TransformerException e) {
            LOGGER.error("create progress file is error..." + e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("create progress file is error..." + e);
        }
    }

    public static void createInspectFile(SilentProcessData data, File file) {
        try {
            SilentProcessToFile.createInspectProgressXml(data, file);
        }
        catch (IOException e) {
            LOGGER.error("create progress file is error..." + e);
        }
        catch (TransformerConfigurationException e) {
            LOGGER.error("create progress file is error..." + e);
        }
        catch (TransformerFactoryConfigurationError e) {
            LOGGER.error("create progress file is error..." + e);
        }
        catch (TransformerException e) {
            LOGGER.error("create progress file is error..." + e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("create progress file is error..." + e);
        }
    }

    private static void createProgressXml(SilentProcessData data, File file) throws IOException, ParserConfigurationException, FileNotFoundException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        if (!file.createNewFile()) {
            ToolLoggerFactory.getLogger(SilentProcessToFile.class).error("create new file error : " + file.getName());
        }
        DocumentBuilder builder = XmlUtils.newDocumentBuilder();
        org.w3c.dom.Document document = builder.newDocument();
        Element element = document.createElement(PROGRESS);
        document.appendChild(element);
        element.setAttribute(STATUS, data.getStatus());
        element.setAttribute(PROGRESS, data.getProcess());
        element.setAttribute(UPDATE_TIME, SilentProcessToFile.getCurrentTime());
        element.setAttribute(RESULT, data.getResult());
        element.setAttribute(TOTAL_DISK_NUM, ZERO);
        element.setAttribute(RISK_DISK_NUM, ZERO);
        element.setAttribute(NOT_CHECK_NUM, ZERO);
        element.setAttribute(ERR_MSG, data.getErrMsg());
        Transformer transformer = XmlUtils.newTransformer();
        transformer.setOutputProperty("indent", "YES");
        transformer.setOutputProperty("method", "XML");
        SilentProcessToFile.transformDOMToStream(file, document, transformer);
    }

    private static void createInspectProgressXml(SilentProcessData data, File file) throws IOException, ParserConfigurationException, FileNotFoundException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        if (!file.createNewFile()) {
            ToolLoggerFactory.getLogger(SilentProcessToFile.class).error("create new file error : " + file.getName());
        }
        DocumentBuilder builder = XmlUtils.newDocumentBuilder();
        org.w3c.dom.Document document = builder.newDocument();
        Element element = document.createElement(PROGRESS);
        document.appendChild(element);
        element.setAttribute(STATUS, data.getStatus());
        element.setAttribute(PROGRESS, data.getProcess());
        element.setAttribute(UPDATE_TIME, SilentProcessToFile.getCurrentTime());
        element.setAttribute(RESULT, SUCCESS);
        element.setAttribute(ERR_MSG, "");
        Transformer transformer = XmlUtils.newTransformer();
        transformer.setOutputProperty("indent", "YES");
        transformer.setOutputProperty("method", "XML");
        SilentProcessToFile.transformDOMToStream(file, document, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformDOMToStream(File file, org.w3c.dom.Document document, Transformer transformer) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (Exception e) {
            try {
                LOGGER.error("outputStream is error..." + e);
            }
            catch (Throwable throwable) {
                SilentProcessToFile.closeOutputStream(outputStream);
                throw throwable;
            }
            SilentProcessToFile.closeOutputStream(outputStream);
        }
        SilentProcessToFile.closeOutputStream(outputStream);
    }

    private static synchronized void addDeviceElement(org.dom4j.Element processNode, SilentProcessData silentProcessData) {
        org.dom4j.Element deviceElement = processNode.addElement("device");
        deviceElement.addAttribute(SERIALNO, silentProcessData.getDevNode().getDeviceSerialNumber());
        deviceElement.addAttribute(STATUS, silentProcessData.getStatus());
        deviceElement.addAttribute(RESULT, silentProcessData.getResult());
        deviceElement.addAttribute(ERR_MSG, silentProcessData.getErrMsg());
        deviceElement.addAttribute(UPDATE_TIME, SilentProcessToFile.getCurrentTime());
        deviceElement.addAttribute(TOTAL_TIME, ZERO);
        deviceElement.addAttribute(PASSRATE, silentProcessData.getPassRate() + "%");
        deviceElement.addAttribute(PROGRESS, ZERO);
    }

    private static void queryAnalyDeviceData(org.dom4j.Element root, SilentProcessData silentProcessData) {
        for (org.dom4j.Element element : root.elements()) {
            String deviceSn = silentProcessData.getDevNode().getDeviceSerialNumber();
            if (!deviceSn.equals(element.attributeValue(SERIALNO))) continue;
            element.addAttribute(STATUS, silentProcessData.getStatus());
            element.addAttribute(RESULT, silentProcessData.getResult());
            String currentTime = SilentProcessToFile.getCurrentTime();
            String preTime = element.attributeValue(UPDATE_TIME);
            String totalTime = "";
            String usedTime = silentProcessData.getUsedTime();
            if (null == usedTime || usedTime.isEmpty()) {
                long pretimeLong = Long.parseLong(preTime);
                totalTime = String.valueOf(Long.parseLong(currentTime) - pretimeLong);
            } else {
                totalTime = usedTime;
            }
            element.addAttribute(UPDATE_TIME, currentTime);
            element.addAttribute(TOTAL_TIME, totalTime);
            element.addAttribute(ERR_MSG, silentProcessData.getErrMsg());
            if (silentProcessData.getSummary() != null) {
                element.addAttribute(NOT_CHECK_NUM, String.valueOf(silentProcessData.getSummary().getFailedDiskNum()));
                element.addAttribute(RISK_DISK_NUM, String.valueOf(silentProcessData.getSummary().getRiskDiskNum()));
                element.addAttribute(TOTAL_DISK_NUM, String.valueOf(silentProcessData.getSummary().getTotalDiskNum()));
            }
            element.addAttribute(PASSRATE, silentProcessData.getPassRate() + "%");
            element.addAttribute(PROGRESS, silentProcessData.getProcess());
            element.addAttribute(RETURN_DATA, silentProcessData.getReturnData());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDataToXml(File file, Document document) throws IOException {
        XMLWriter xw = null;
        FileOutputStream fos = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            fos = new FileOutputStream(file);
            xw = new XMLWriter((OutputStream)fos, format);
            xw.write(document);
        }
        catch (Exception e) {
            try {
                LOGGER.error("document is error..." + e);
            }
            catch (Throwable throwable) {
                SilentProcessToFile.closeXMLResource(xw);
                SilentProcessToFile.closeOutputStream(fos);
                throw throwable;
            }
            SilentProcessToFile.closeXMLResource(xw);
            SilentProcessToFile.closeOutputStream(fos);
        }
        SilentProcessToFile.closeXMLResource(xw);
        SilentProcessToFile.closeOutputStream(fos);
    }

    private static void closeOutputStream(FileOutputStream fos) {
        if (null != fos) {
            try {
                fos.close();
            }
            catch (Exception e3) {
                LOGGER.error("close fos failed..." + e3);
            }
        }
    }

    private static void closeXMLResource(XMLWriter xw) {
        if (null != xw) {
            try {
                xw.close();
            }
            catch (Exception e2) {
                LOGGER.error("close xw failed..." + e2);
            }
        }
    }

    private static String getCurrentTime() {
        return String.valueOf(System.currentTimeMillis());
    }
}

