/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.pubservice.entity.SupportProduct;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SupportProductUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportProductUtils.class);
    private static final String PRODUCT_NODE = "product";
    private static final String PRODUCT_NAME_NODE = "productname";
    private static final String PRODUCT_TYPE_NODE = "supporttypes";
    private static final String DISK_SCAN_TYPE = "diskscantypes";
    private static final String TLV_PORT = "tlvport";
    private static final String SSL_VERSION = "sslversion";

    private SupportProductUtils() {
    }

    public static List<SupportProduct> parseProductsXml(File xmlFile) {
        Document document = SupportProductUtils.initXMLDocument(xmlFile);
        if (document == null) {
            return new ArrayList<SupportProduct>();
        }
        return SupportProductUtils.buildProductList(document);
    }

    public static List<SupportProduct> parseProductsXml(InputStream xmlFileStream) {
        Document document = SupportProductUtils.initXMLDocument(xmlFileStream);
        if (document == null) {
            return new ArrayList<SupportProduct>();
        }
        return SupportProductUtils.buildProductList(document);
    }

    private static List<SupportProduct> buildProductList(Document document) {
        ArrayList<SupportProduct> products = new ArrayList<SupportProduct>();
        Element root = document.getDocumentElement();
        NodeList productList = root.getElementsByTagName(PRODUCT_NODE);
        if (productList == null) {
            LOGGER.error("the product.xml format is error.");
            return products;
        }
        int length = productList.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = productList.item(index);
            SupportProduct packProduct = SupportProductUtils.parseProduct((Element)node);
            products.add(packProduct);
        }
        return products;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document initXMLDocument(File xmlFile) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(xmlFile);
            Document document = XmlUtils.parseDocument(fileInputStream);
            return document;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("the xml config file is not exist or the file is not a file. ");
            Document document = null;
            return document;
        }
        finally {
            if (fileInputStream != null) {
                StreamUtils.closeResource(null, fileInputStream);
            }
        }
    }

    private static Document initXMLDocument(InputStream xmlFileStream) {
        return XmlUtils.parseDocument(xmlFileStream);
    }

    private static SupportProduct parseProduct(Element productElement) {
        String scanType;
        String sslVersion;
        SupportProduct packProduct = new SupportProduct();
        packProduct.setProductName(SupportProductUtils.getElementContent(productElement, PRODUCT_NAME_NODE));
        String versionStrings = SupportProductUtils.getElementContent(productElement, PRODUCT_TYPE_NODE);
        String tlvPort = SupportProductUtils.getElementContent(productElement, TLV_PORT);
        if (!StringUtils.isNULLStr(tlvPort)) {
            packProduct.setTlvportByXml(Integer.valueOf(tlvPort));
        }
        if (!StringUtils.isNULLStr(sslVersion = SupportProductUtils.getElementContent(productElement, SSL_VERSION))) {
            packProduct.setSslVersion(sslVersion);
        }
        if (!StringUtils.isNULLStr(scanType = SupportProductUtils.getElementContent(productElement, DISK_SCAN_TYPE))) {
            SupportProductUtils.setDiskScanTypes(packProduct, scanType);
        }
        ArrayList<String> versions = new ArrayList<String>();
        versions.addAll(Arrays.asList(versionStrings.split(",")));
        packProduct.setVersions(versions);
        return packProduct;
    }

    private static void setDiskScanTypes(SupportProduct packProduct, String scanType) {
        String[] scanTypes;
        ArrayList<SupportProduct.DiskScanType> notScanTypeList = new ArrayList<SupportProduct.DiskScanType>();
        notScanTypeList.addAll(Arrays.asList(SupportProduct.DiskScanType.values()));
        for (String type : scanTypes = scanType.split(",")) {
            SupportProduct.DiskScanType t = SupportProduct.DiskScanType.valueOf(type);
            notScanTypeList.remove((Object)t);
        }
        packProduct.setNotSupportScanType(notScanTypeList);
    }

    private static String getElementContent(Element parent, String elementName) {
        NodeList nodeList = parent.getElementsByTagName(elementName);
        if (nodeList == null || nodeList.getLength() == 0) {
            return "";
        }
        return ((Element)nodeList.item(0)).getTextContent();
    }
}

