/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.common.devmgr.DeviceLocator;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityResMgr;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityType;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityUserScene;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.connection.AbstractGrabConn;
import com.huawei.ism.tool.obase.connection.CustomDefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.connection.SshErrParser;
import com.huawei.ism.tool.obase.connection.mina.SshUtils;
import com.huawei.ism.tool.obase.connection.ssh.SshKnownHostsManager;
import com.huawei.ism.tool.obase.connection.support.AsyncExecSSHCmdTask;
import com.huawei.ism.tool.obase.connection.support.SessionMonitor;
import com.huawei.ism.tool.obase.constant.CliCmdModel;
import com.huawei.ism.tool.obase.constant.CmdConditions;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ExtendHandleException;
import com.huawei.ism.tool.obase.exception.InitPwdNotChangeException;
import com.huawei.ism.tool.obase.exception.PortUnreachableException;
import com.huawei.ism.tool.obase.exception.PwdCLIOverrunException;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.PwdExpiredException;
import com.huawei.ism.tool.obase.exception.PwdUnSafeException;
import com.huawei.ism.tool.obase.exception.PwdWillExpireException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.util.CommonUtil;
import com.huawei.json.JSONObject;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.IOException;
import java.net.Proxy;
import java.text.Normalizer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.core.CoreModuleProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnection
extends AbstractGrabConn {
    private static final Logger log = LoggerFactory.getLogger(SshConnection.class);
    public static final String STRICT_HOST_KEY_CHECKING_YES = "yes";
    public static final String STRICT_HOST_KEY_CHECKING_NO = "no";
    public static final String STRICT_HOST_KEY_CHECKING_ASK = "ask";
    private static final String CONTAINS_UNSAFE_ALGORITHMS_KEX_ALGORITHMS = "diffie-hellman-group1-sha1,diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha1";
    private static final String CONTAINS_UNSAFE_ALGORITHMS_CIPHER_ALGORITHMS = "aes128-ctr,aes192-ctr,aes256-ctr,aes128-cbc,3des-ctr,3des-cbc,blowfish-cbc,aes192-cbc,aes256-cbc";
    private static final String CONTAINS_UNSAFE_ALGORITHMS_MAC_ALGORITHMS = "hmac-sha2-256,hmac-md5,hmac-sha1,hmac-sha1-96,hmac-md5-96";
    private static final String EMPTY = "";
    private Lock lock = new ReentrantLock();
    private static final String CMD_HAS_RETRIED = "CMD_HAS_RETRIED";
    private static final String OPTION = "OPTION_COMMANDS";
    private static final String[] FILTER_DEVTYPE = new String[]{"VIS", "VTL", "SIR", "HDP", "SWITC", "AKI", "NEX"};
    private static final String[] CONN_NORECONN_COND = new String[]{"connection is closed by foreign host", "timed out"};
    private static final int NOT_EXISTS = -1;
    private static final String LINE_SEP = "\n";
    private static final String STORG_LASTLINE_SEP = ">";
    private static final String CLI_MODE_LASTLINE_SEP = "cliportal>";
    private static final int SECOND_LINE = 1;
    private static final int FAILED_SLEEP_TIME = 10000;
    private static final int POLLUTED_CMD_SLEEP_TIME = 5000;
    private static final int LINUX_PROCESS_KILL_CMD = 3;
    private static final int CMD_DEFAULT_TIMEOUTE = 1200;
    private static final int TIME_OUT;
    private static final int CLOSE_SESSION_SLEEP_TIME = 3000;
    private Proxy proxyData;
    private ClientSession session;
    private String username;
    private String password;
    protected volatile boolean connected;
    private ISshJudge sshEndJudgeIntf = null;
    protected SessionMonitor monitor = null;
    private String logInMessage = "";
    private String hostName = "";
    private int hostPort = 0;
    private PriKeyInfo priKey;
    private boolean isLogin = false;
    private SshClient client = null;
    private String fingerPrint = null;
    private DevNode dNode;
    private String isNeedCheckUnSupportSign = null;
    private String strictHostKeyChecking = "no";
    private String knownHostsInfo = "";
    private boolean isPwdWillExpireBreak;
    private boolean isDeviceMgr;
    private TriFunction<String, String, ICliConnection.SSHCmdParamEntity, String> doExtendHandleForResult = (command, result, params) -> result;
    private ICliConnection.SSHCmdParamEntity defaultCmdParamEntity;

    public SshConnection(String sshHostname, String username, String password, ISshJudge sshEndJudgeIntf) {
        this(sshHostname, username, password, 22, sshEndJudgeIntf);
    }

    public void appendSshEndJudgeIntf(List<String> endStrs) {
        if (this.sshEndJudgeIntf instanceof CustomDefaultSshJudge && !CollectionUtil.isEmpty(endStrs)) {
            ((CustomDefaultSshJudge)this.sshEndJudgeIntf).setIsWhiteEndJudge(end -> endStrs.stream().anyMatch(end::endsWith));
        }
    }

    public void disableEndJudge(String endStr) {
        if (this.sshEndJudgeIntf instanceof CustomDefaultSshJudge) {
            ((CustomDefaultSshJudge)this.sshEndJudgeIntf).setIsEndJudgeValid(end -> !end.equals(endStr));
        }
    }

    public void setEndJudgeBlackList(String endStr) {
        log.warn("======node :{} set end judge black str :{}", (Object)this.dNode.getIp(), (Object)endStr);
        if (this.sshEndJudgeIntf instanceof CustomDefaultSshJudge) {
            ((CustomDefaultSshJudge)this.sshEndJudgeIntf).setIsBlackEndJudge(end -> end.endsWith(endStr));
        }
    }

    public void setEndJudgeBlackList(List<String> endStrs) {
        log.warn("======node :{} set end judge black list :{}", (Object)this.dNode.getIp(), (Object)endStrs);
        if (this.sshEndJudgeIntf instanceof CustomDefaultSshJudge) {
            ((CustomDefaultSshJudge)this.sshEndJudgeIntf).setIsBlackEndJudge(end -> endStrs.stream().anyMatch(end::endsWith));
        }
    }

    public DevNode getdNode() {
        return this.dNode;
    }

    public void setdNode(DevNode deNode) {
        this.dNode = deNode;
    }

    public PriKeyInfo getPriKey() {
        return this.priKey;
    }

    public void setPriKey(PriKeyInfo priKey) {
        this.priKey = priKey;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public SshConnection(String sshHostname, String username, String password) {
        this(sshHostname, username, password, new CustomDefaultSshJudge());
    }

    public SshConnection(String sshHostname, String username, String password, int port) {
        this(sshHostname, username, password, port, (ISshJudge)new CustomDefaultSshJudge());
    }

    public String getCurpathRight(String serverFilePath) throws ToolException {
        if (StringUtils.isNULLStr(serverFilePath)) {
            return EMPTY;
        }
        String rightStr = this.execCmd("ll -d " + serverFilePath);
        if (rightStr.contains("command not found")) {
            rightStr = this.execCmd("ls -ld " + serverFilePath);
        }
        return rightStr;
    }

    public SshConnection(String sshHostname, String username, String password, int sshHostPort, ISshJudge sshEndJudgeIntf) {
        log.info("Connect to host: {} HostPort: {} :username:{}", sshHostname, sshHostPort, com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)username));
        this.username = username;
        this.setPassword(password);
        this.hostName = sshHostname;
        this.hostPort = sshHostPort;
        this.sshEndJudgeIntf = sshEndJudgeIntf;
    }

    public SshConnection(String sshHostname, User user, int sshHostPort, PriKeyInfo prikey, ISshJudge sshEndJudgeIntf) {
        this(sshHostname, user.getUserName(), user.getPassword(), sshHostPort, sshEndJudgeIntf);
        this.priKey = prikey;
    }

    public String getPassword() {
        return AESEncrypt.decrypt((String)this.password);
    }

    public void setPassword(String pwd) {
        this.password = AESEncrypt.encrypt((String)pwd);
    }

    public Lock getLock() {
        return this.lock;
    }

    protected void rebuildConn(String sshHostname, int sshHostPort) throws IOException, ToolException {
        this.hostPort = sshHostPort;
        this.initSession();
    }

    public synchronized void reConnect() throws ToolException {
        try {
            this.closeSession();
            this.connected = false;
        }
        catch (Exception e) {
            log.error("in reconnect close Connection error!", e);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            log.error("Sleep after close ssh session failed.");
        }
        this.connect();
    }

    @Override
    public void close() {
        try {
            if (!this.connected) {
                return;
            }
        }
        finally {
            this.closeSession();
            this.connected = false;
        }
    }

    private void closeStraightly() {
        try {
            if (!this.connected) {
                return;
            }
        }
        finally {
            this.closeSession();
            this.connected = false;
        }
    }

    @Override
    public synchronized boolean isConnected() {
        if (!this.isConnectionActive()) {
            return false;
        }
        if (!this.isSessionActive()) {
            log.info("the connection session is closed, close whole connection and isConnected return false.");
            this.closeStraightly();
            return false;
        }
        return true;
    }

    public synchronized boolean isConnectionActive() {
        if (!this.connected) {
            log.info("the connection is closed, isConected return false.");
            return false;
        }
        return true;
    }

    private boolean isCommandFinished(String temp) {
        return this.sshEndJudgeIntf.isSshFinish(temp, this.username);
    }

    private boolean isCommandFinished(String temp, String sshjudge) {
        if (StringUtils.isNULLStr(sshjudge)) {
            return this.isCommandFinished(temp);
        }
        sshjudge = Normalizer.normalize(sshjudge, Normalizer.Form.NFKC);
        return StringUtils.hasMatchStr(temp, sshjudge);
    }

    private void preInputStreamReceiver(boolean isLog) {
        String lastOut = this.monitor.getCurrentStdOut(true);
        String lastError = this.monitor.getCurrentStdErr(true);
        if (!StringUtils.isNULLStr(lastOut) && isLog) {
            log.info("PreInputStreamReceiver. Read :{}", (Object)lastOut);
        }
        if (!StringUtils.isNULLStr(lastError) && isLog) {
            log.info("PreInputStreamReceiver. Read :{}", (Object)lastError);
        }
    }

    private void checkConnected() throws ToolException {
        if (!this.connected) {
            throw new ToolException("build.connection.failed", new String[]{this.getHost()});
        }
        if (!this.isSessionActive()) {
            log.error("session is note active.");
            this.close();
            throw new ToolException("build.connection.failed", new String[]{this.getHost()});
        }
    }

    public boolean isSessionActive() {
        if (this.monitor == null) {
            return false;
        }
        return this.monitor.isActive();
    }

    private void closeSession() {
        log.info("start close session.");
        if (this.monitor != null) {
            this.monitor.close();
            this.monitor = null;
        }
        if (null != this.session) {
            try {
                this.session.close();
            }
            catch (IOException e) {
                log.error("close session error.", e);
            }
        }
        this.closeClient();
        log.info("close session success.");
    }

    private void closeClient() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                log.error("close session error.", e);
            }
        }
    }

    @Override
    public synchronized void execCmdWithOutReturn(String commandLine) throws ToolException {
        this.execCmdWithOutReturn(commandLine, true);
    }

    public synchronized void execCmdWithOutReturnAutoEnter(String command) throws ToolException {
        log.info("Executed command line : {}", (Object)command);
        this.checkConnected();
        this.sendCmd(command, true);
    }

    public synchronized void execCmdWithOutReturn(String command, boolean isAutoEnter) throws ToolException {
        log.info("Excuted command line : {}", (Object)command);
        this.checkConnected();
        this.sendCmd(command, false);
    }

    public String getCurrentSessionOut(boolean isFlush) {
        return this.monitor.getCurrentStdOut(isFlush);
    }

    @Override
    public synchronized String execCmd(String commandLine) throws ToolException {
        return this.execCmdWithTimout(commandLine, 1200);
    }

    @Override
    public synchronized String execCmd(String commandLine, List<String> endStrs) throws ToolException {
        return this.execCmd(commandLine, endStrs, 1200);
    }

    public synchronized String execCmd(String commandLine, List<String> endStrs, int timeOutSecs) throws ToolException {
        return this.execCmdWithTimout(commandLine, timeOutSecs, endStrs);
    }

    @Override
    public synchronized String execCmdWithTimout(String commandLine, int timeout) throws ToolException {
        log.info("Execute command line : {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)commandLine));
        return this.sendCmdAndGetResult(timeout, true, commandLine, null);
    }

    public synchronized String execCmdWithTimout(String commandLine, ICliConnection.SSHCmdParamEntity params) throws ToolException {
        boolean isNeedLog;
        boolean bl = isNeedLog = params == null || params.isNeedLog();
        if (isNeedLog) {
            log.info("Execute command line : {}", (Object)commandLine);
        } else {
            log.info("execute not log command!!!");
        }
        int timeout = params == null || -2 == params.getTimeout() ? 1200 : params.getTimeout();
        return this.sendCmdAndGetResult(timeout, isNeedLog, commandLine, params);
    }

    @Override
    public synchronized String execCmdWithTimout(String commandLine, int timeout, List<String> endStrs, boolean isProcesKill) throws ToolException {
        log.info("Excuted command line : {}", (Object)commandLine);
        HashMap<String, Object> params = null;
        if (endStrs != null) {
            params = new HashMap<String, Object>();
            params.put("_SPEFIC_END_STRS", endStrs);
            log.info("end str setted:{}", (Object)endStrs);
        }
        ICliConnection.SSHCmdParamEntity cmdParams = new ICliConnection.SSHCmdParamEntity();
        cmdParams.setParams(params);
        cmdParams.setCkeckCmdSendResult(false);
        cmdParams.setProcessKill(isProcesKill);
        return this.sendCmdAndGetResult(timeout, true, commandLine, cmdParams);
    }

    @Override
    public synchronized String execCmdWithTimout(String commandLine, int timeout, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(commandLine, timeout, endStrs, true);
    }

    @Override
    public synchronized ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLine, int timeout) throws ToolException {
        ICliConnection.CliRtnEntity entity = new ICliConnection.CliRtnEntity(commandLine);
        entity.setCmdExecOver(false);
        new Thread(new AsyncExecSSHCmdTask(this, timeout, commandLine, entity)).start();
        return entity;
    }

    @Override
    public synchronized ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLine) throws ToolException {
        ICliConnection.CliRtnEntity entity = new ICliConnection.CliRtnEntity(commandLine);
        entity.setCmdExecOver(false);
        new Thread(new AsyncExecSSHCmdTask(this, 1200, commandLine, entity)).start();
        return entity;
    }

    public String execCmdWithKeepAlive(String commandLine, int keepInterval, int timeOut) throws ToolException {
        ICliConnection.SSHCmdParamEntity paramEntity = new ICliConnection.SSHCmdParamEntity();
        paramEntity.setKeepInterval(keepInterval);
        paramEntity.setTimeout(timeOut);
        return this.execCmdWithKeepAlive(commandLine, paramEntity);
    }

    public String execCmdWithKeepAlive(String commandLine, int keepInterval, int timeOut, boolean isNeedLog) throws ToolException {
        ICliConnection.SSHCmdParamEntity paramEntity = new ICliConnection.SSHCmdParamEntity();
        paramEntity.setKeepInterval(keepInterval);
        paramEntity.setTimeout(timeOut);
        paramEntity.setNeedLog(isNeedLog);
        return this.execCmdWithKeepAlive(commandLine, paramEntity);
    }

    @Override
    public String execCmdWithKeepAlive(String commandLine, ICliConnection.SSHCmdParamEntity paramEntity) throws ToolException {
        int checkTimes;
        ICliConnection.CliRtnEntity entity = new ICliConnection.CliRtnEntity(commandLine);
        entity.setCmdExecOver(false);
        int keepInterval = paramEntity == null ? 30 : paramEntity.getKeepInterval();
        String keepAliveMsg = paramEntity == null ? null : paramEntity.getKeepAliveMsg();
        int timeOut = paramEntity == null || paramEntity.getTimeout() == -2 ? 1200 : paramEntity.getTimeout();
        new Thread(new AsyncExecSSHCmdTask(this, timeOut, commandLine, entity, paramEntity)).start();
        for (checkTimes = 0; checkTimes <= timeOut && !entity.isCmdExecOver(); ++checkTimes) {
            this.sleepSomeTime(1000);
            if (checkTimes % keepInterval != 0) continue;
            this.sendKeepActiveMsg(keepAliveMsg);
        }
        if (checkTimes > timeOut) {
            log.info("keep alive message have sent reconnect to clear dirty data.");
            this.reConnect();
        }
        return this.replaceSpecChars(entity);
    }

    @Override
    public String execCmdWithKeepAlive(String commandLine, int keepInterval, List<String> endStrs) throws ToolException {
        ICliConnection.SSHCmdParamEntity paramEntity = new ICliConnection.SSHCmdParamEntity();
        paramEntity.setKeepInterval(keepInterval);
        paramEntity.setEndStrs(endStrs);
        return this.execCmdWithKeepAlive(commandLine, paramEntity);
    }

    private String replaceSpecChars(ICliConnection.CliRtnEntity entity) {
        int[] spcStrs;
        String returnMsg = entity.getCmdReutrn();
        for (int spcChar : spcStrs = new int[]{127, 1, 7}) {
            String str = String.valueOf((char)spcChar);
            if (!returnMsg.contains(str)) continue;
            returnMsg = returnMsg.replace(str, EMPTY);
        }
        return returnMsg;
    }

    public synchronized String execCmdWithConditions(String commandLine, Map<String, Object> params) throws ToolException {
        int timeout = Integer.parseInt(String.valueOf(CmdConditions.TIMEOUT.getValue(params)));
        boolean isLog = Boolean.parseBoolean(String.valueOf(CmdConditions.ISLOG.getValue(params)));
        log.info("execCmdWithConditions!!!");
        ICliConnection.SSHCmdParamEntity cmdParams = new ICliConnection.SSHCmdParamEntity();
        cmdParams.setParams(params);
        return this.sendCmdAndGetResult(timeout, isLog, commandLine, cmdParams);
    }

    @Override
    public synchronized String execCmdNoLog(String command) throws ToolException {
        return this.execCmdNoLogTimout(command, 1200);
    }

    @Override
    public String execCmdHasLog(String command) throws ToolException {
        String result = this.execCmd(command);
        log.info("result is: {}{}", (Object)System.lineSeparator(), (Object)result);
        return result;
    }

    @Override
    public String execCmdHasLogTimout(String command, int timeout) throws ToolException {
        return this.execCmdWithTimout(command, this.getTimeout(timeout));
    }

    @Override
    public String execCmdNoLog(String command, List<String> endStrs) throws ToolException {
        return this.execCmdNoLogTimout(command, 1200, endStrs);
    }

    @Override
    public synchronized String execCmdNoLogTimout(String command, int timout) throws ToolException {
        return this.sendCmdAndGetResult(this.getTimeout(timout), false, command, null);
    }

    private int getTimeout(int timeout) {
        if (this.isInfoGrab()) {
            return timeout >= 1200 ? timeout / 4 : timeout * 5;
        }
        return timeout;
    }

    private boolean isInfoGrab() {
        return this.defaultCmdParamEntity != null && this.defaultCmdParamEntity.getParams() != null && "InfoGrab".equals(this.defaultCmdParamEntity.getParams().get("Tool"));
    }

    @Override
    public String execCmdNoLogTimout(String cmd, int timeOut, List<String> endStrs) throws ToolException {
        HashMap<String, Object> params = null;
        if (endStrs != null) {
            params = new HashMap<String, Object>();
            params.put("_SPEFIC_END_STRS", endStrs);
        }
        ICliConnection.SSHCmdParamEntity cmdParams = new ICliConnection.SSHCmdParamEntity();
        cmdParams.setParams(params);
        return this.sendCmdAndGetResult(timeOut, false, cmd, cmdParams);
    }

    private String sendCmdAndGetResult(int timeout, boolean isLog, String cmd, ICliConnection.SSHCmdParamEntity params) throws ToolException {
        this.checkConnected();
        this.sendCmd(cmd, true, isLog);
        try {
            this.isLogin = false;
            ICliConnection.SSHCmdParamEntity cmdParams = (ICliConnection.SSHCmdParamEntity)ObjectUtils.defaultIfNull((Object)params, (Object)this.defaultCmdParamEntity);
            String result = this.waitForResult(timeout, isLog, cmd, false, false, cmdParams);
            return (String)this.doExtendHandleForResult.apply((Object)cmd, (Object)result, (Object)cmdParams);
        }
        catch (PwdException e) {
            log.error("pwd exception error.", e);
            if (SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"PatchEvalu", "Upgrade Check"}) && e instanceof PwdCLIOverrunException) {
                throw new ToolException(e.getErrResult(), e);
            }
        }
        catch (ExtendHandleException e) {
            if (e.getCause() instanceof ToolException) {
                throw (ToolException)e.getCause();
            }
            throw new ToolException(e.getMessage(), e.getCause());
        }
        return EMPTY;
    }

    @Override
    public synchronized void setCLIMode(CliCmdModel mode) {
    }

    private void sendCmd(String commandLine) throws ToolException {
        this.sendCmd(commandLine, true);
    }

    private void sendCmd(String commandLine, boolean isEnter, boolean isLog) throws ToolException {
        try {
            this.preInputStreamReceiver(isLog);
            String remoteCommandLine = commandLine;
            if (isEnter) {
                remoteCommandLine = remoteCommandLine + LINE_SEP;
            }
            this.monitor.sendCmd(remoteCommandLine);
        }
        catch (Exception e) {
            if (isLog) {
                log.error("Execute cmd {} error", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)commandLine), (Object)e);
            } else {
                log.error("Execute cmd error", e);
            }
            throw new ToolException("cmd.execute.error", "Execute cmd error", (Throwable)e);
        }
    }

    private void sendCmd(String commandLine, boolean isEnter) throws ToolException {
        this.sendCmd(commandLine, isEnter, true);
    }

    public void sendKeepActiveMsg(String commandLine) throws ToolException {
        try {
            char spcChar = '\u0001';
            char spcCharDel = '\u007f';
            String dftStr = String.valueOf(spcChar) + String.valueOf(spcCharDel);
            commandLine = commandLine == null ? dftStr : commandLine;
            this.monitor.sendCmd(commandLine);
            log.info("send keep active message: {}", (Object)commandLine);
        }
        catch (Exception th) {
            log.error("Execute cmd error,cmd: {}", (Object)commandLine, (Object)th);
        }
    }

    private String waitForResult(int timeout, boolean isLog, String commandLine, boolean isPwdWillExpireBreak, boolean isDeviceMgr, ICliConnection.SSHCmdParamEntity cmdParams) throws ToolException {
        String result = EMPTY;
        Map<String, Object> params = cmdParams == null ? null : cmdParams.getParams();
        ICliConnection.CliRtnEntity entity = this.getCliRtnEntity(params);
        try {
            int startSleepTime = 50;
            int middleSleepTime = 100;
            int timeOutFactor = 10;
            if (com.huawei.ism.tool.obase.utils.ApplicationContext.getInstance().isUpgradeEvaluTool()) {
                startSleepTime = 100;
                middleSleepTime = 20;
                timeOutFactor = 50;
            }
            timeout = timeout * timeOutFactor + 1;
            startSleepTime = this.getStartSleepTimeForDb(startSleepTime, timeout, params);
            HashMap<String, Object> switches = new HashMap<String, Object>();
            switches.put(CMD_HAS_RETRIED, false);
            this.sleepSomeTime(startSleepTime);
            for (int i = 0; i < timeout; ++i) {
                this.checkConnect(this.isLogin);
                result = this.monitor.getCurrentStdOut(false);
                this.setCmdtExecResultMsg(result, entity);
                this.handlePwdError(isDeviceMgr, result);
                String tmp1 = this.pwdWillExpireHandle(isDeviceMgr, isPwdWillExpireBreak, result);
                if (null != tmp1) {
                    String string = tmp1;
                    return string;
                }
                if (result.endsWith("--More--")) {
                    this.monitor.sendCmd(" ");
                    continue;
                }
                if (!this.checkCmdResult(result, commandLine, params, cmdParams, switches)) {
                    break;
                }
                this.checkSystemNotReady(result);
                this.sleepSomeTime(middleSleepTime);
                String tmp = this.checkTimeout(i, timeout, this.isLogin, cmdParams == null || cmdParams.isProcessKill());
                if (!"TOOLKIT_SEND_CMD_TIME_OUT".equals(tmp)) continue;
                log.error("time out. result : {}", (Object)result.replace(commandLine, EMPTY));
                String string = commandLine.contains(OPTION) ? result : tmp;
                return string;
            }
        }
        catch (PwdException e) {
            log.error("pwd check failed. result : {}", (Object)result, (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("connection exec failed", e);
            throw new ToolException("build.connection.failed", new String[]{this.getHost()}, e.getMessage(), e);
        }
        finally {
            this.seCmdtExecOver(true, entity);
        }
        this.recordCmdExecResult(isLog, result);
        return result;
    }

    private int getStartSleepTimeForDb(int startSleepTime, int timeout, Map<String, Object> params) {
        if (params != null && Boolean.parseBoolean(Objects.toString(params.get("isDbSsh")))) {
            return Math.max(startSleepTime, timeout);
        }
        return startSleepTime;
    }

    public static void switchToRootIfNeeded(DevNode devNode, ICliConnection connection) throws ToolException {
        try {
            if (devNode == null || devNode.getRootUser() == null) {
                log.info("dev null no need to switch.");
                return;
            }
            if (devNode.isOceanCyber()) {
                log.info("Ocean Cyber no need to switch.");
                return;
            }
            User user = devNode.getRootUser();
            String uName = user.getUserName();
            String currentUser = connection.execCmd("whoami");
            if (SshConnection.isSwitchRoot(currentUser)) {
                log.info("current is root logined");
                return;
            }
            if (SshConnection.isDistributedFruAndCliMode(currentUser)) {
                SshConnection.switchToMiniSystem(devNode, connection);
                return;
            }
            String switchRootEcho = connection.execCmdNoLogTimout("su - " + uName, 120);
            log.info("switch result:{}", (Object)switchRootEcho);
            if (switchRootEcho.toLowerCase(Locale.ENGLISH).contains("unknown terminal type")) {
                devNode.setRootUser(null);
                throw new ToolException("ssh.connect.switchroot.terminal.unsupport");
            }
            switchRootEcho = connection.execCmdNoLog(Base64EncodeUtils.decode((String)user.getPassword()));
            if (SshErrParser.isRootInitPwdNotChanged(switchRootEcho.toLowerCase(Locale.ENGLISH))) {
                devNode.setRootUser(null);
                throw new ToolException("ssh.connect.switchroot.init.pwd.err", new String[]{devNode.getIp()});
            }
            currentUser = connection.execCmd("whoami");
            if (!SshConnection.isSwitchRoot(currentUser)) {
                devNode.setRootUser(null);
                if (SshConnection.checkWhoAmICommond(currentUser)) {
                    throw new ToolException("ssh.check.whoami.error");
                }
                throw new ToolException("ssh.connect.switchroot.passwd.error");
            }
            SshConnectionManager.getRuserMap().put(devNode.getDevKey(), user);
            log.info("switch to root success. {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)devNode.getIp()));
        }
        catch (ToolException e) {
            log.error("error to switch", e);
            throw e;
        }
        catch (Exception e) {
            log.error("error to switch", e);
        }
    }

    public static boolean isDistributedFruAndCliMode(String currentUser) {
        if (StringUtils.isNULLStr(currentUser)) {
            return false;
        }
        String[] echos = currentUser.split("\\n");
        String lastLine = echos[echos.length - 1].toLowerCase();
        return SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"Distributed FRU"}) && lastLine.contains(CLI_MODE_LASTLINE_SEP);
    }

    public static void switchToMiniSystem(DevNode devNode, ICliConnection connection) throws ToolException {
        try {
            connection.execCmdNoLogTimout("minisystem", 120);
            User user = devNode.getRootUser();
            String switchMiniSystemEcho = connection.execCmdNoLog(Base64EncodeUtils.decode((String)user.getPassword()));
            if (switchMiniSystemEcho.toLowerCase(Locale.ENGLISH).contains("password fails to be verified")) {
                throw new ToolException("ssh.connect.switchminisystem.pwd.err", new String[]{devNode.getIp()});
            }
            if (!switchMiniSystemEcho.toLowerCase(Locale.ENGLISH).contains("root login minisystem")) {
                throw new ToolException("ssh.connect.switchminisystem.unsupport");
            }
            devNode.setMiniSystem(true);
            SshConnectionManager.getRuserMap().put(devNode.getDevKey(), user);
            log.info("switch to minisystem success. {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)devNode.getIp()));
        }
        catch (ToolException e) {
            log.error("error to switch minisystem", e);
            throw e;
        }
    }

    private ICliConnection.CliRtnEntity getCliRtnEntity(Map<String, Object> params) {
        if (params == null) {
            return null;
        }
        return (ICliConnection.CliRtnEntity)CommonUtil.convertObject((Object)params.get("CMD_ENTITY"), ICliConnection.CliRtnEntity.class);
    }

    private void recordCmdExecResult(boolean isLog, String result) {
        if (isLog) {
            log.info("Receive str : {}", (Object)result);
        }
    }

    private void setCmdtExecResultMsg(String result, ICliConnection.CliRtnEntity entity) {
        if (entity != null) {
            entity.setCmdReutrn(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seCmdtExecOver(boolean isOver, ICliConnection.CliRtnEntity entity) {
        if (entity != null) {
            ICliConnection.CliRtnEntity cliRtnEntity = entity;
            synchronized (cliRtnEntity) {
                entity.setCmdExecOver(isOver);
                entity.notifyAll();
            }
        }
    }

    private void handlePwdError(boolean isDeviceMgr, String result) {
        this.loginClisOverrunHandle(result, isDeviceMgr);
        this.initPwdNotChangedhandle(result, isDeviceMgr);
        this.pwdExpiredHandle(result, isDeviceMgr);
        this.pwdUnsafeHandle(result, isDeviceMgr);
    }

    private void pwdUnsafeHandle(String result, boolean isDeviceMgr) {
        if (SshErrParser.isPwdUnSafe(result)) {
            String res = EMPTY;
            res = isDeviceMgr ? PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.UN_SAFE, PwdSecurityUserScene.DeviceMgr) : PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.UN_SAFE, PwdSecurityUserScene.Tool);
            throw new PwdUnSafeException(res);
        }
    }

    private void loginClisOverrunHandle(String result, boolean isDeviceMgr) {
        if (SshErrParser.isLoginCLIsOverrun(result)) {
            String res = EMPTY;
            res = isDeviceMgr ? PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.CLISOVERRUN, PwdSecurityUserScene.DeviceMgr) : PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.CLISOVERRUN, PwdSecurityUserScene.Tool);
            this.close();
            throw new PwdCLIOverrunException(res, result);
        }
    }

    private String pwdWillExpireHandle(boolean isDeviceMgr, Boolean isPwdWillExpireBreak, String result) throws ToolException {
        String ret = null;
        if (SshErrParser.isPwdWillExpire(result)) {
            ret = result + this.execCmd("n");
            String res = EMPTY;
            if (isPwdWillExpireBreak.booleanValue()) {
                try {
                    res = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_WILL_EXPIRE, PwdSecurityUserScene.DeviceMgr);
                    if (isDeviceMgr) {
                        this.exitHandle();
                        this.exitHandle();
                    } else {
                        res = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_WILL_EXPIRE, PwdSecurityUserScene.Tool);
                    }
                }
                catch (Exception e) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("exit error.", e);
                }
                throw new PwdWillExpireException(res);
            }
        }
        return ret;
    }

    private void exitHandle() throws ToolException {
        if (this.execCmd("exit").contains("y/n")) {
            log.info(this.execCmd("y"));
        }
    }

    private boolean checkCmdResult(String result, String commandLine, Map<String, Object> params, ICliConnection.SSHCmdParamEntity cmdParams, Map<String, Object> switches) throws IOException, ToolException {
        String commd;
        String cmdResult = this.replaceCmdResult(result, cmdParams);
        cmdResult = SshConnection.eliminatesResultColorCode(cmdResult);
        String string = commd = !StringUtils.isNULLStr(commandLine) && commandLine.contains(OPTION) ? commandLine.replace(OPTION, EMPTY) : commandLine;
        if (!this.isCommandNotSupport(result) && this.isEndStrSetted(params)) {
            return this.isNotEndWithEndStrs(cmdResult, params);
        }
        return this.checkIsCmdRsultEnd(cmdResult, commd, params, switches);
    }

    @NotNull
    public static String eliminatesResultColorCode(String cmdResult) {
        return cmdResult.replaceAll("\\e\\[[\\d;]*[^\\d;]", EMPTY);
    }

    private void checkSystemNotReady(String result) throws ToolException {
        boolean systemNotReady;
        if (StringUtils.isNULLStr(result)) {
            return;
        }
        String[] lines = result.split(LINE_SEP);
        String lastLine = lines[lines.length - 1].toLowerCase();
        boolean bl = systemNotReady = lastLine.startsWith("system is not ready") && lastLine.contains("input minisystem");
        if (systemNotReady) {
            this.sendCmd("minisystem");
        }
    }

    private String replaceCmdResult(String result, ICliConnection.SSHCmdParamEntity cmdParams) {
        Map<String, String> checkEndReplaceMap;
        Map<String, String> map = checkEndReplaceMap = cmdParams == null ? null : cmdParams.getCheckEndReplaceMap();
        if (null == checkEndReplaceMap) {
            return result;
        }
        for (Map.Entry<String, String> entry : checkEndReplaceMap.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private boolean checkIsCmdRsultEnd(String result, String commd, Map<String, Object> params, Map<String, Object> switches) throws IOException, ToolException {
        String sshjudge = String.valueOf(CmdConditions.SSHJUDGE.getValue(params));
        if (!this.isCommandNotSupport(result) && this.isCommandFinished(result, sshjudge)) {
            this.monitor.getCurrentStdOut(true);
            return false;
        }
        if (this.isCommandFinished(result, sshjudge)) {
            log.info("command finished!!! isEndWithByNewCli");
            this.monitor.getCurrentStdOut(true);
            return false;
        }
        if (this.isDoneProcessingCmdNotSupportOrPolluted(result, commd, sshjudge, switches)) {
            log.info("command is not supported and detected finished !!! isEndWithByNewCli");
            this.monitor.getCurrentStdOut(true);
            return false;
        }
        return true;
    }

    public boolean isNotEndWithEndStrs(String result, Map<String, Object> params) {
        Object endObj = params.get("_SPEFIC_END_STRS");
        List endStrs = (List)endObj;
        result = this.handleResult(result);
        for (String endStr : endStrs) {
            if (!result.trim().endsWith(endStr.trim())) continue;
            this.getMonitor().getCurrentStdOut(true);
            log.info("command end with :{}", (Object)endStr);
            return false;
        }
        return true;
    }

    public String handleResult(String result) {
        return result;
    }

    public SessionMonitor getMonitor() {
        return this.monitor;
    }

    private boolean isEndStrSetted(Map<String, Object> params) {
        return params != null && params.containsKey("_SPEFIC_END_STRS");
    }

    private void checkConnect(boolean isLoggin) throws ToolException {
        if (!this.isConnected()) {
            log.error("connection is over.");
            throw new ToolException("build.connection.failed");
        }
        if (!isLoggin && !this.isSessionActive()) {
            log.error("connection session is over.");
            throw new ToolException("build.connection.failed");
        }
    }

    private void sleepSomeTime(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            log.error("sleep error.", e);
        }
    }

    private void pwdExpiredHandle(String result, boolean isDeviceMgr) {
        if (SshErrParser.isPwdExpired(result)) {
            String res = EMPTY;
            res = isDeviceMgr ? PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_EXPIRED, PwdSecurityUserScene.DeviceMgr) : PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_EXPIRED, PwdSecurityUserScene.Tool);
            throw new PwdExpiredException(res);
        }
    }

    private void initPwdNotChangedhandle(String result, boolean isDeviceMgr) {
        if (SshErrParser.isInitPwdNotChanged(result)) {
            String res = EMPTY;
            res = isDeviceMgr ? PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.INIT_PWD_NOT_CHANGE, PwdSecurityUserScene.DeviceMgr) : PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.INIT_PWD_NOT_CHANGE, PwdSecurityUserScene.Tool);
            throw new InitPwdNotChangeException(res);
        }
    }

    private boolean isDoneProcessingCmdNotSupportOrPolluted(String result, String commd, String sshjudge, Map<String, Object> switches) throws IOException, ToolException {
        int charIndex;
        boolean isNotErr;
        boolean isRetried = (Boolean)switches.get(CMD_HAS_RETRIED);
        if (null == commd) {
            return false;
        }
        String sign = "^";
        int commdIndex = result.indexOf(commd);
        boolean bl = isNotErr = commdIndex + 1 == (charIndex = result.indexOf(sign));
        if (isNotErr || !result.contains(sign)) {
            return false;
        }
        String lastLine = StringUtils.getLastLineString(result);
        if (!this.isCommandNotSupport(result) && this.isCommandFinished(result, sshjudge)) {
            log.info("cmd is not supported and is cleared after sending baskspaces!");
            return true;
        }
        if (lastLine.indexOf(STORG_LASTLINE_SEP) < 0) {
            return false;
        }
        if (this.isLastLineInCmdAfterUpperSymbol(lastLine, commd, true)) {
            return this.setBackSpaceToClearCli(lastLine);
        }
        if (this.isLastLineInCmdAfterUpperSymbol(lastLine, commd, false)) {
            return false;
        }
        if (isRetried) {
            log.info("current cmd has retried sending, this cmd is not supported!");
            this.setBackSpaceToClearCli(lastLine);
            return true;
        }
        log.info("detected ssh io is polluted, wait for final result!");
        log.info("current echos:{}", (Object)result);
        this.sleepSomeTime(5000);
        log.info("fetch cmd echo and clear!");
        String returnStrNew = this.monitor.getCurrentStdOut(true);
        log.info("new echos:{}", (Object)returnStrNew);
        lastLine = StringUtils.getLastLineString(returnStrNew);
        this.setBackSpaceToClearCli(lastLine);
        log.info("resend the command!");
        this.sendCmd(commd);
        switches.put(CMD_HAS_RETRIED, true);
        return false;
    }

    private boolean setBackSpaceToClearCli(String lastLine) throws IOException {
        StringBuilder backSbr = new StringBuilder();
        int len = lastLine.substring(lastLine.indexOf(STORG_LASTLINE_SEP) + STORG_LASTLINE_SEP.length()).length();
        for (int chars = 0; chars < len; ++chars) {
            backSbr.append('\b');
        }
        this.monitor.sendCmd(backSbr.toString());
        for (int loop = 0; loop < 4; ++loop) {
            this.sleepSomeTime(50);
            String resultNew = this.monitor.getCurrentStdOut(false);
            if (!resultNew.trim().endsWith(STORG_LASTLINE_SEP)) continue;
            log.info("cmd is not supported and succeeded in sending backspace!");
            return true;
        }
        return false;
    }

    private boolean isLastLineInCmdAfterUpperSymbol(String lastLine, String commd, boolean isTotalCompare) {
        String returnedStr = lastLine.substring(lastLine.indexOf(STORG_LASTLINE_SEP) + 1);
        commd = commd.replace("_", EMPTY);
        commd = commd.replace(" ", EMPTY);
        returnedStr = returnedStr.replace("_", EMPTY);
        returnedStr = returnedStr.replace(" ", EMPTY);
        if (isTotalCompare) {
            return commd.equals(returnedStr);
        }
        return commd.contains(returnedStr);
    }

    private boolean isCommandNotSupport(String result) {
        if (!this.isHandleUnSupportSign()) {
            return false;
        }
        String secondLine = StringUtils.getIndexLineString(result, 2);
        String unSupportSign = this.dNode == null ? "^" : this.dNode.getUnSupportSign();
        return secondLine.trim().equals(unSupportSign);
    }

    private boolean isHandleUnSupportSign() {
        if (this.isNeedCheckUnSupportSign != null) {
            return Boolean.valueOf(this.isNeedCheckUnSupportSign);
        }
        if (this.dNode == null || this.dNode.getDeviceType() == null) {
            return false;
        }
        this.isNeedCheckUnSupportSign = String.valueOf(false);
        String devType = this.dNode.getDeviceType().toString();
        for (String type : FILTER_DEVTYPE) {
            if (!devType.contains(type)) continue;
            return false;
        }
        if (ArrayUtils.isHostDevice(this.dNode) || devType.matches("Ocean.+N[1-9][0-9]00") || devType.matches("N[1-9][0-9]00")) {
            return false;
        }
        this.isNeedCheckUnSupportSign = String.valueOf(true);
        return true;
    }

    private String checkTimeout(int i, int timeout, boolean isLoggin, boolean isProcessKill) throws ToolException, IOException {
        if (i == timeout - 1) {
            if (!isProcessKill) {
                log.info("No message received after time out");
                return "TOOLKIT_SEND_CMD_TIME_OUT";
            }
            log.info("No message received after time out, sending 'Ctrl C' command");
            this.monitor.sendCmd(3);
            for (int j = 0; j < 100; ++j) {
                if (this.isCommandFinished(this.monitor.getCurrentStdOut(false))) {
                    this.monitor.getCurrentStdOut(true);
                    break;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    log.error("Sending 'Ctr C' command faild");
                }
            }
            if (isLoggin) {
                log.error("connect time out!");
                throw new ToolException("connect time out!");
            }
            return "TOOLKIT_SEND_CMD_TIME_OUT";
        }
        return EMPTY;
    }

    public synchronized void connect(boolean isPwdWillExpireBreak, boolean isDeviceMgr) throws ToolException {
        log.info("Begin connect SSH host: {} with port: {}", (Object)this.getHost(), (Object)this.getPort());
        try {
            this.openSession(isPwdWillExpireBreak, isDeviceMgr);
        }
        catch (PwdException e) {
            log.error("PwdException", e);
            this.close();
            throw e;
        }
        catch (ToolException defException) {
            log.error("ToolException", defException);
            this.close();
            throw defException;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("init ssh connection failed. ", e);
            this.close();
            String errid = SshErrParser.getConErrId(e.getMessage());
            throw new ToolException(errid, new String[]{this.getHost()}, "bulid connection failed.", e);
        }
        log.info("SSH Connecting successfull!");
    }

    @Override
    public synchronized void connect() throws ToolException {
        this.connect(false, false);
    }

    public void connectionLost(Throwable th) {
        log.info("connection lost , ip : {}  connected is : {}", (Object)this.hostName, (Object)this.connected);
        if (this.connected) {
            this.closeSession();
            this.connected = false;
            log.info("connection lost run over in connected....{}", (Object)this);
        }
    }

    private void openSession(boolean isPwdWillExpireBreak, boolean isDeviceMgr) throws IOException, ToolException {
        try {
            this.initSession();
            this.monitor = new SessionMonitor(this.session);
            this.monitor.setName("session monitor for " + this.hostName);
            this.monitor.startShell();
            this.monitor.start();
        }
        catch (ToolException e) {
            throw e;
        }
        catch (Exception e) {
            if (NetUtil.isPortCannotReach(this.hostName, this.hostPort)) {
                throw new PortUnreachableException("ssh.conn.error.ip.reach.port.invalid", new Object[]{this.hostName, this.hostPort, this.hostPort});
            }
            this.closeSession();
            throw new IOException(e);
        }
        this.isLogin = true;
        this.logInMessage = this.waitForResult(180, true, null, isPwdWillExpireBreak, isDeviceMgr, null);
        this.checkIsLogining(this.logInMessage);
        this.checkNeedInitializePassword(this.logInMessage);
        SshConnection.switchToRootIfNeeded(this.dNode, this);
    }

    void checkNeedInitializePassword(String logInMessage) throws ToolException {
        if (this.dNode == null || this.dNode.getLoginUser() == null) {
            log.info("dev null and no login user no need init!");
            return;
        }
        try {
            if (ItDeviceType.A800_NODE.equals((Object)this.dNode.getItDeviceType()) && SshErrParser.isNeedInitPassword(logInMessage)) {
                log.info("need init admin info");
                this.execCmdNoLogTimout(this.dNode.getLoginUser().getPassword(), 10);
                String sshRet = this.execCmdNoLogTimout(this.dNode.getLoginUser().getPassword(), 10);
                if (!sshRet.contains(StringUtils.fillValues("{0}:/>", this.dNode.getLoginUser().getUserName()))) {
                    throw new ToolException("ssh.comm.error.init.password.fail");
                }
            }
        }
        catch (ToolException e) {
            throw new ToolException("ssh.comm.error.init.password.fail");
        }
    }

    public void refreshPrivKeyIfNull() {
        if (this.priKey == null) {
            com.huawei.ism.tool.framework.pubservice.entity.DevNode dn = this.dNode == null ? DeviceLocator.getDevNodeByKey((String)this.hostName) : EntityUtils.toNewDev(this.dNode);
            this.priKey = dn == null ? null : EntityUtils.transToBasPk(dn.getPriKey());
        }
    }

    public synchronized void connectWithRetry(int retryTimes) throws Exception {
        if (retryTimes > 0) {
            Exception re = null;
            for (int i = 0; i < retryTimes + 1; ++i) {
                try {
                    log.info("start to build conn the {}th times.", (Object)i);
                    this.connect();
                    log.info("start to build conn success.");
                    return;
                }
                catch (Exception e) {
                    re = e;
                    log.error("build conn error!", e);
                    this.sleepSomeTime(10000);
                    continue;
                }
            }
            log.info("start to rebuild conn failed.");
            throw re;
        }
        this.connect();
    }

    private void initSshParams() {
        if (!ApplicationContext.getInstance().isVerifySshHostKeyForStorage()) {
            log.info("the public key is not verified based on the configuration.");
            this.strictHostKeyChecking = STRICT_HOST_KEY_CHECKING_NO;
            return;
        }
        if (this.dNode != null && !this.dNode.isNotSshForward()) {
            log.info("SSH proxy. the public key information should not be verified.");
            this.strictHostKeyChecking = STRICT_HOST_KEY_CHECKING_NO;
            return;
        }
        if (this.shouldVerifyHostKeyByManager()) {
            log.info("the public key information from manager should be verified.");
            this.strictHostKeyChecking = STRICT_HOST_KEY_CHECKING_YES;
            this.knownHostsInfo = SshKnownHostsManager.getHostKeyInfo(this.dNode.getIp());
        } else if (this.shouldVerifyHostKeyByEnv()) {
            log.info("the public key information from env should be verified.");
            this.strictHostKeyChecking = STRICT_HOST_KEY_CHECKING_YES;
            this.knownHostsInfo = this.getSshHostKeyInfoFromEnv();
        } else {
            log.info("the public key information should not be verified.");
            this.strictHostKeyChecking = STRICT_HOST_KEY_CHECKING_NO;
        }
    }

    private boolean shouldVerifyHostKeyByEnv() {
        int devOrdinal = 1;
        String str = null;
        while (!VerifyUtil.isEmpty((String)(str = System.getenv("jsonDevEncode_" + devOrdinal++)))) {
            JSONObject jsonObject = new JSONObject(str);
            String ip = jsonObject.getString("devIp");
            if (this.dNode == null || !this.dNode.getIp().equals(ip)) continue;
            String hostKey = jsonObject.has("sshHostKey") ? AESEncrypt.decrypt((String)jsonObject.getString("sshHostKey")) : EMPTY;
            boolean isVerifyHostKey = jsonObject.has("isVerifySshHostKey") ? Boolean.valueOf(AESEncrypt.decrypt((String)jsonObject.getString("isVerifySshHostKey"))) : false;
            return isVerifyHostKey && !VerifyUtil.isEmpty((String)hostKey);
        }
        return false;
    }

    private String getSshHostKeyInfoFromEnv() {
        int devOrdinal = 1;
        String str = null;
        while (!VerifyUtil.isEmpty((String)(str = System.getenv("jsonDevEncode_" + devOrdinal++)))) {
            JSONObject jsonObject = new JSONObject(str);
            String ip = jsonObject.getString("devIp");
            if (this.dNode == null || !this.dNode.getIp().equals(ip)) continue;
            return AESEncrypt.decrypt((String)jsonObject.getString("sshHostKey"));
        }
        return EMPTY;
    }

    private boolean shouldVerifyHostKeyByManager() {
        return this.dNode != null && SshKnownHostsManager.isVerifySshHostKeyInfo(this.dNode.getIp()) && SshKnownHostsManager.isHostAdded(this.dNode.getIp());
    }

    protected void initSession() throws IOException, ToolException {
        Properties config = new Properties();
        this.client = SshUtils.getDefaultSshClient(this.isOnlySecurityAlgorithm());
        try {
            this.initSshParams();
            this.initSessionParams(config, this.client);
            CoreModuleProperties.IDLE_TIMEOUT.set((PropertyResolver)this.session, (Object)Duration.ofMinutes(30L));
            this.session.auth().verify(TIME_OUT, new CancelOption[0]);
            log.info("auth session success.");
            this.fillFingerPrint();
            this.connected = true;
        }
        catch (SshException e) {
            if (!SshErrParser.isSecurityAlgorithmExpired(e.getMessage())) {
                log.info("conn error throw exception...");
                throw new IOException(e);
            }
            if (this.isOnlySecurityAlgorithm()) {
                log.error("security algorithm conn error throw exception...", e);
                throw new ToolException("ssh.connect.security.algorithm.error", false);
            }
        }
        catch (IOException e1) {
            log.error("insecure algorithm connect error!", e1);
            throw new IOException(e1);
        }
    }

    private boolean isOnlySecurityAlgorithm() {
        return this.dNode != null && this.dNode.isOnlySecurityAlgorithm() && !LocalHostUtil.isRunInSvp();
    }

    private void initSessionParams(Properties config, SshClient client) throws IOException {
        client.setServerKeyVerifier(AcceptAllServerKeyVerifier.INSTANCE);
        this.setClientFactories(client);
        client.start();
        this.session = (ClientSession)((ConnectFuture)client.connect(this.username, this.hostName, this.hostPort).verify(TIME_OUT, new CancelOption[0])).getSession();
        if (!StringUtils.isNULLStr(this.getPassword())) {
            this.session.addPasswordIdentity(this.getPassword());
        }
        this.refreshPrivKeyIfNull();
        if (null != this.priKey) {
            SshUtils.setPublicKey(this.session, this.priKey);
        }
    }

    private void setClientFactories(SshClient client) {
        this.removeNoSafeAlgorithm(client);
        if (!this.isOnlySecurityAlgorithm()) {
            client.setCipherFactories(BuiltinFactory.setUpFactories((boolean)true, SshUtils.ALL_CIPHER_FACTORY_ALGORITHM));
            client.setMacFactories(BuiltinFactory.setUpFactories((boolean)true, SshUtils.ALL_MAC_FACTORY_ALGORITHM));
            client.setSignatureFactories(BuiltinFactory.setUpFactories((boolean)true, SshUtils.ALL_SIGNATURE_FACTORY_ALGORITHM));
            client.setKeyExchangeFactories(NamedFactory.setUpTransformedFactories((boolean)true, SshUtils.ALL_KEY_EXCHANGE_FACTORY_ALGORITHM, ClientBuilder.DH2KEX));
        }
        if (Objects.isNull(this.priKey)) {
            ArrayList<UserAuthFactory> userAuthFactories = new ArrayList<UserAuthFactory>();
            userAuthFactories.add(UserAuthPasswordFactory.INSTANCE);
            userAuthFactories.add(UserAuthKeyboardInteractiveFactory.INSTANCE);
            client.setUserAuthFactories(userAuthFactories);
        }
    }

    private void removeNoSafeAlgorithm(SshClient client) {
        client.getCipherFactories().remove(BuiltinCiphers.aes128cbc);
        client.getCipherFactories().remove(BuiltinCiphers.aes192cbc);
        client.getCipherFactories().remove(BuiltinCiphers.aes256cbc);
        client.getSignatureFactories().remove(BuiltinSignatures.rsa);
    }

    private void fillFingerPrint() {
        this.fingerPrint = SshUtils.getFingerPrint(this.session);
    }

    private void checkIsLogining(String ret) throws ToolException {
        if (null != this.getdNode() && !ItDeviceType.Storage.equals((Object)this.getdNode().getItDeviceType())) {
            ToolLoggerFactory.getLogger(this.getClass()).info("Node type is " + this.getdNode().getItDeviceType().toString() + ", no need to checkIsLogining");
            return;
        }
        if ((ret = ret.toLowerCase(Locale.ENGLISH).trim()).contains("already logged in") || ret.endsWith("is logining in!") || ret.indexOf("Already Online") != -1 || ret.indexOf("logining in") != -1 || ret.indexOf("logged in") != -1) {
            throw new ToolException("inspect.ssh.user.already.login");
        }
    }

    public void setProxyData(Proxy proxyData) {
        this.proxyData = proxyData;
    }

    public Proxy getProxyData() {
        return this.proxyData;
    }

    public String getHost() {
        return this.hostName;
    }

    public int getPort() {
        return this.hostPort;
    }

    public String toString() {
        return "ssh connection connet :" + this.getHost() + ":" + this.getPort();
    }

    public String getLoginMessage() {
        return this.logInMessage;
    }

    User getUser() {
        return new User(this.username, this.getPassword());
    }

    public ClientSession getSession() {
        return this.session;
    }

    @Deprecated
    public void setLogger(Logger logger) {
    }

    public String execCtrlPlusCCmd(int timeOutSecs) {
        StringBuilder sb = new StringBuilder();
        try {
            int loopNum = timeOutSecs * 1000 / 100;
            this.monitor.sendCmd(3);
            for (int i = 0; i < loopNum; ++i) {
                sb.append(this.monitor.getCurrentStdOut(false));
                if (this.isCommandFinished(sb.toString())) {
                    this.monitor.getCurrentStdOut(true);
                    break;
                }
                Thread.sleep(100L);
            }
        }
        catch (RuntimeException e) {
            log.error("Sending 'Ctr C' command runtime exception:", e);
            throw e;
        }
        catch (Exception e) {
            log.error("Sending 'Ctr C' command IOException exception:", e);
        }
        return sb.toString();
    }

    public static boolean isSwitchRoot(String echoCurrent) {
        if (StringUtils.isNULLStr(echoCurrent)) {
            return false;
        }
        String[] echos = echoCurrent.split("\\n");
        if (echos.length <= 1) {
            return false;
        }
        for (int i = 1; i < echos.length; ++i) {
            if (!"root".equalsIgnoreCase(echos[i].trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhoAmICommond(String echoCurrent) {
        if (StringUtils.isNULLStr(echoCurrent)) {
            return false;
        }
        String[] echos = echoCurrent.split("\\n");
        if (echos.length <= 1) {
            return false;
        }
        for (int i = 1; i < echos.length; ++i) {
            String commandResult = echos[i].trim().toLowerCase(Locale.ENGLISH);
            if (!commandResult.contains("not found") && !commandResult.contains("not-found") && !commandResult.contains("no such file or directory") && !commandResult.contains("not exist") && !commandResult.contains("\u4e0d\u5b58\u5728") && !commandResult.contains("\u6ca1\u6709\u90a3\u4e2a")) continue;
            return true;
        }
        return false;
    }

    public String execDbCmdNoLogTimout(String command, int timeout) throws ToolException {
        log.info("execute db command: {}", (Object)command);
        ICliConnection.SSHCmdParamEntity params = new ICliConnection.SSHCmdParamEntity();
        params.setParams(Collections.singletonMap("isDbSsh", true));
        String dbCmdResult = this.sendCmdAndGetResult(timeout, false, command, params);
        int lastEnterIndex = dbCmdResult.lastIndexOf(ToolConstants.ENTER) + 2;
        dbCmdResult = dbCmdResult.substring(lastEnterIndex) + dbCmdResult.substring(0, lastEnterIndex);
        if (dbCmdResult.contains("SP2-") || dbCmdResult.contains("ORA-")) {
            return dbCmdResult + "TOOLKIT_EXE_CMD_FAILED" + ToolConstants.ENTER;
        }
        return dbCmdResult;
    }

    @Override
    public void execSwitchRootCmd(com.huawei.ism.tool.framework.pubservice.entity.DevNode device) throws ToolException {
        SshConnection.switchToRootIfNeeded(EntityUtils.toOldDev(device), this);
    }

    @Override
    public Object execSql(String sql) {
        throw new EncapsulatedRuntimeException("method not implements.");
    }

    @Override
    public String execCtrlCmd(String ctrlCmd, int timeOut, List<String> endStrs) throws ToolException {
        try {
            int cmdInt = Integer.parseInt(ctrlCmd);
            return this.execCmdWithTimout(String.valueOf((char)cmdInt), timeOut, endStrs);
        }
        catch (NumberFormatException e) {
            log.error("cmd str [{}] not a CtrlCmd(integer).", (Object)ctrlCmd, (Object)e);
            return EMPTY;
        }
    }

    @Override
    public String execCmdWithNoCheckResult(String cmd, int timeOut) throws ToolException {
        log.info("Execute command line: {}", (Object)cmd);
        return this.sendCmdAndGetResult(timeOut, false, cmd, null);
    }

    @Override
    public String execCmdWithNoCheckResult(String cmd, int timeOut, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(cmd, timeOut, endStrs);
    }

    @Override
    public Map<String, String> getEchoValue() {
        return Collections.emptyMap();
    }

    public ISshJudge getSshEndJudgeIntf() {
        return this.sshEndJudgeIntf;
    }

    public void setStrictHostKeyChecking(String strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public void setKnownHostsInfo(String knownHostsInfo) {
        this.knownHostsInfo = knownHostsInfo;
    }

    public boolean isPwdWillExpireBreak() {
        return this.isPwdWillExpireBreak;
    }

    public void setPwdWillExpireBreak(boolean isPwdWillExpireBreak) {
        this.isPwdWillExpireBreak = isPwdWillExpireBreak;
    }

    public boolean isDeviceMgr() {
        return this.isDeviceMgr;
    }

    public void setDeviceMgr(boolean isDeviceMgr) {
        this.isDeviceMgr = isDeviceMgr;
    }

    public void setDoExtendHandleForResult(TriFunction<String, String, ICliConnection.SSHCmdParamEntity, String> doExtendHandleForResult) {
        this.doExtendHandleForResult = doExtendHandleForResult;
    }

    public void setDefaultCmdParamEntity(ICliConnection.SSHCmdParamEntity defaultCmdParamEntity) {
        this.defaultCmdParamEntity = defaultCmdParamEntity;
    }

    static {
        String timeoutValue = StringUtils.getToolConfig("app.ssh.timeout.default");
        TIME_OUT = StringUtils.isDigit(timeoutValue) ? Integer.parseInt(timeoutValue) * 1000 : 30000;
    }
}

