/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.support;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.constant.CmdConditions;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.HashMap;
import org.slf4j.Logger;

public class AsyncExecSSHCmdTask
implements Runnable {
    private static final Logger SSHLOGGER = ToolLoggerFactory.getLogger(AsyncExecSSHCmdTask.class);
    private SshConnection conn;
    private int timeout;
    private String commandLine;
    private ICliConnection.CliRtnEntity entity;
    private ICliConnection.SSHCmdParamEntity paramEntity;

    public AsyncExecSSHCmdTask(SshConnection conn, int timeout, String commandLine, ICliConnection.CliRtnEntity entity, ICliConnection.SSHCmdParamEntity paramEntity) {
        this(conn, timeout, commandLine, entity);
        this.paramEntity = paramEntity;
    }

    public AsyncExecSSHCmdTask(SshConnection conn, int timeout, String commandLine, ICliConnection.CliRtnEntity entity) {
        this.conn = conn;
        this.timeout = timeout;
        this.commandLine = commandLine;
        this.entity = entity;
    }

    @Override
    public void run() {
        try {
            if (this.paramEntity == null || this.paramEntity.isNeedLog()) {
                SSHLOGGER.info("Excuted command line return entity : {}", (Object)this.commandLine);
            } else {
                SSHLOGGER.info("execute not log command!!!");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("CMD_ENTITY", this.entity);
            params.put(CmdConditions.TIMEOUT.name(), this.timeout);
            if (this.paramEntity != null && null != this.paramEntity.getEndStrs()) {
                params.put("_SPEFIC_END_STRS", this.paramEntity.getEndStrs());
            }
            if (this.paramEntity == null) {
                this.paramEntity = new ICliConnection.SSHCmdParamEntity();
            }
            this.paramEntity.setParams(params);
            this.conn.execCmdWithTimout(this.commandLine, this.paramEntity);
        }
        catch (ToolException e) {
            SSHLOGGER.error("exec cmd error!", e);
        }
        catch (Exception e) {
            SSHLOGGER.error("exec cmd error!", e);
        }
    }
}

