/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity.enums;

import com.huawei.ism.tool.obase.entity.enums.DmeType;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Arrays;

public enum DmeNodeStatus {
    STORAGE_POWER_OFF(DmeType.STORAGE, "0", "dme.node.status.storage.0"),
    STORAGE_NORMAL(DmeType.STORAGE, "1", "dme.node.status.storage.1"),
    STORAGE_ERROR(DmeType.STORAGE, "2", "dme.node.status.storage.2"),
    STORAGE_LEVEL_DOWN(DmeType.STORAGE, "5", "dme.node.status.storage.5"),
    STORAGE_NO_MANAGE(DmeType.STORAGE, "9", "dme.node.status.storage.9"),
    ZONE_NORMAL(DmeType.ZONE, "NORMAL", "dme.node.status.zone.normal"),
    ZONE_ABNORMAL(DmeType.ZONE, "ABNORMAL", "dme.node.status.om.abnormal"),
    OM_NORMAL(DmeType.OM, "NORMAL", "dme.node.status.om.normal"),
    OM_ABNORMAL(DmeType.OM, "ABNORMAL", "dme.node.status.zone.abnormal"),
    UNKNOWN(DmeType.DME, "UNKNOWN", "dme.node.status.dme.unknown");

    private final DmeType type;
    private final String key;
    private final String desc;

    public static DmeNodeStatus of(DmeType type, String status) {
        return Arrays.stream(DmeNodeStatus.values()).filter(value -> value.key.equalsIgnoreCase(status) && value.type.equals((Object)type)).findFirst().orElse(UNKNOWN);
    }

    public String toString() {
        return ResourceUtil.getString(this.desc);
    }

    private DmeNodeStatus(DmeType type, String key, String desc) {
        this.type = type;
        this.key = key;
        this.desc = desc;
    }
}

