/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.chart.frame;

import com.huawei.ism.tool.obase.listener.IChassisLocationObserver;
import com.huawei.ism.tool.obase.ui.chart.frame.ChassisInfo;
import com.huawei.ism.tool.obase.ui.chart.frame.FrameChartPicturePanel;
import com.huawei.ism.tool.obase.ui.chart.frame.PictureComponent;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FrameChartPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension DIMS = new Dimension(40, 21);
    private static final int LEFT_SPACE = 24;
    private static final int TOP_SPACE = 23;
    private static final int BOTTOM_SPACE = 22;
    private static final int SINGLE_U_HEIGHT = 10;
    private static final int DEFAULT_SHELF_HEIGHT = 42;
    private static final int PANEL_HEIGHT = 108;
    private static final int PANEL_WIDTH = 461;
    private static final int NUM_458 = 458;
    private JPanel midPanel = null;
    private FrameChartPicturePanel chartPanel = null;
    private JButton btnMoveUp = UCD.createButton((ImageIcon)ResourceUtil.getImage("uparrow.gif"), (Dimension)DIMS);
    private JButton btnMoveAllUp = UCD.createButton((ImageIcon)ResourceUtil.getImage("sparedrive_upallarrow.gif"), (Dimension)DIMS);
    private JButton btnMoveAllDown = UCD.createButton((ImageIcon)ResourceUtil.getImage("sparedrive_downallarrow.gif"), (Dimension)DIMS);
    private JButton btnMoveDown = UCD.createButton((ImageIcon)ResourceUtil.getImage("downarrow.gif"), (Dimension)DIMS);
    private IChassisLocationObserver locationObserver = null;
    private String currentChassisSn = "";
    private int shelfHeight = 42;
    private List<PictureComponent> componentList = new ArrayList<PictureComponent>();
    private List<Integer> startUList = new ArrayList<Integer>();

    public FrameChartPanel(IChassisLocationObserver chassisLocationObserver, String currentChassisSn, int shelfHeight, List<ChassisInfo> infoList) {
        this.chartPanel = new FrameChartPicturePanel(shelfHeight);
        this.locationObserver = chassisLocationObserver;
        this.currentChassisSn = currentChassisSn;
        this.shelfHeight = shelfHeight;
        this.initLayout();
        this.initChassisLocation(infoList);
        this.initListener();
    }

    public FrameChartPanel(IChassisLocationObserver chassisLocationObserver, ChassisInfo info, int shelfType) {
        this.chartPanel = new FrameChartPicturePanel(shelfType);
        this.locationObserver = chassisLocationObserver;
        this.initLayout();
        this.addChassis(info);
        this.initListener();
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        this.chartPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.left = 24;
        gbc.insets.top = 23;
        gbc.insets.bottom = 22;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        this.midPanel = new JPanel();
        this.midPanel.setOpaque(false);
        this.midPanel.setMaximumSize(new Dimension(108, 461));
        this.midPanel.setPreferredSize(new Dimension(108, 461));
        this.midPanel.setMinimumSize(new Dimension(108, 461));
        this.midPanel.setLayout(null);
        this.chartPanel.add((Component)this.midPanel, gbc);
        JComponent btnComp = this.createBtnComp();
        JComponent hComp = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(4), btnComp});
        Box box = Box.createVerticalBox();
        box.add(hComp);
        hComp.setAlignmentY(0.5f);
        this.add((Component)this.chartPanel, "Center");
        this.add((Component)hComp, "East");
    }

    public void refreshChassisLocation(ChassisInfo hlChass, int height, List<ChassisInfo> infoList) {
        this.startUList.clear();
        this.componentList.clear();
        this.currentChassisSn = hlChass.getSn();
        this.chartPanel.setBayHeight(height);
        this.chartPanel.repaint();
        this.shelfHeight = height;
        this.midPanel.removeAll();
        this.midPanel.updateUI();
        this.refreshChassisLocation(hlChass, infoList);
    }

    private void refreshChassisLocation(ChassisInfo hlChass, List<ChassisInfo> infoList) {
        this.addChassis(hlChass);
        if (infoList.contains(hlChass)) {
            infoList.remove(hlChass);
        }
        for (ChassisInfo chassis : infoList) {
            this.addChassis(chassis);
        }
    }

    private void initChassisLocation(List<ChassisInfo> infoList) {
        if (null == infoList) {
            return;
        }
        for (ChassisInfo chassis : infoList) {
            if (!this.currentChassisSn.equals(chassis.getSn())) continue;
            this.addChassis(chassis);
            break;
        }
        for (ChassisInfo chassis : infoList) {
            if (this.currentChassisSn.equals(chassis.getSn())) continue;
            this.addChassis(chassis);
        }
    }

    private void addChassis(ChassisInfo chassis) {
        this.startUList.add(chassis.getStartU());
        PictureComponent component = new PictureComponent(chassis);
        if (this.currentChassisSn.equals(chassis.getSn())) {
            component.setHighLight(true);
        }
        this.componentList.add(component);
        component.setToolTipText(chassis.getSn());
        ChassisInfo chasIfo = component.getChassisInfo();
        int height = chasIfo.getHeight() * 10;
        int startU = chasIfo.getStartU();
        int yValue = 458 - height - 10 * startU;
        component.setBounds(0, yValue, 108, height);
        this.midPanel.add(component);
    }

    private Point calcNewLocation(PictureComponent component) {
        int picHeight = (int)this.chartPanel.getPreferredSize().getHeight() - 23 - 22;
        ChassisInfo chassis = component.getChassisInfo();
        int startU = chassis.getStartU();
        int chassisHeight = chassis.getHeight();
        int result = picHeight - (startU + chassisHeight) * 10;
        return new Point(component.getX(), result);
    }

    public void reLocateAllComp() {
        for (PictureComponent comp : this.componentList) {
            Point newLocation = this.calcNewLocation(comp);
            comp.setLocation(newLocation);
            comp.setBounds(0, (int)comp.getLocation().getY(), 108, comp.getHeight());
        }
    }

    private void initListener() {
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameChartPanel.this.moveUp();
            }
        });
        this.btnMoveAllUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameChartPanel.this.moveToTop();
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameChartPanel.this.moveDown();
            }
        });
        this.btnMoveAllDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameChartPanel.this.moveToBottom();
            }
        });
    }

    public PictureComponent getSelectComponent() {
        for (PictureComponent comp : this.componentList) {
            if (!comp.isHighLight()) continue;
            return comp;
        }
        return null;
    }

    public List<PictureComponent> getComponentList() {
        return this.componentList;
    }

    private void moveUp() {
        PictureComponent selectComp = this.getSelectComponent();
        if (null == selectComp || !selectComp.getChassisInfo().getSn().equals(this.currentChassisSn)) {
            return;
        }
        if (selectComp.getStartU() + selectComp.getChassisInfo().getHeight() >= this.shelfHeight) {
            return;
        }
        int newLocationY = selectComp.getY() - 10;
        selectComp.setLocation(selectComp.getX(), newLocationY);
        selectComp.setHighLight(true);
        ChassisInfo chassis = selectComp.getChassisInfo();
        chassis.setStartU(chassis.getStartU() + 1);
        this.locationObserver.fireChassisLocationChanged(chassis.getSn(), chassis.getBayId(), chassis.getStartU());
    }

    private void moveToTop() {
        PictureComponent selectComp = this.getSelectComponent();
        if (null == selectComp || !selectComp.getChassisInfo().getSn().equals(this.currentChassisSn)) {
            return;
        }
        if (selectComp.getStartU() + selectComp.getChassisInfo().getHeight() >= this.shelfHeight) {
            return;
        }
        ChassisInfo chassis = selectComp.getChassisInfo();
        int offsetU = this.shelfHeight - (chassis.getStartU() + chassis.getHeight());
        int newLocationY = selectComp.getY() - offsetU * 10;
        selectComp.setLocation(selectComp.getX(), newLocationY);
        selectComp.setHighLight(true);
        chassis.setStartU(chassis.getStartU() + offsetU);
        this.locationObserver.fireChassisLocationChanged(chassis.getSn(), chassis.getBayId(), chassis.getStartU());
    }

    private void moveDown() {
        PictureComponent selectComp = this.getSelectComponent();
        if (null == selectComp || !selectComp.getChassisInfo().getSn().equals(this.currentChassisSn)) {
            return;
        }
        if (selectComp.getStartU() <= 0) {
            return;
        }
        int newLocationY = selectComp.getY() + 10;
        selectComp.setLocation(selectComp.getX(), newLocationY);
        selectComp.setHighLight(true);
        ChassisInfo chassis = selectComp.getChassisInfo();
        chassis.setStartU(chassis.getStartU() - 1);
        this.locationObserver.fireChassisLocationChanged(chassis.getSn(), chassis.getBayId(), chassis.getStartU());
    }

    private void moveToBottom() {
        int offsetU = 0;
        PictureComponent selectComp = this.getSelectComponent();
        if (null == selectComp || !selectComp.getChassisInfo().getSn().equals(this.currentChassisSn)) {
            return;
        }
        if (selectComp.getStartU() <= 0) {
            return;
        }
        offsetU = selectComp.getStartU();
        int newLocationY = selectComp.getY() + offsetU * 10;
        selectComp.setLocation(selectComp.getX(), newLocationY);
        selectComp.setHighLight(true);
        ChassisInfo chassis = selectComp.getChassisInfo();
        chassis.setStartU(chassis.getStartU() - offsetU);
        this.locationObserver.fireChassisLocationChanged(chassis.getSn(), chassis.getBayId(), chassis.getStartU());
    }

    private JComponent createBtnComp() {
        Box box = Box.createVerticalBox();
        box.add(this.btnMoveAllUp);
        box.add(Box.createVerticalStrut(4));
        box.add(this.btnMoveUp);
        box.add(Box.createVerticalStrut(12));
        box.add(this.btnMoveDown);
        box.add(Box.createVerticalStrut(4));
        box.add(this.btnMoveAllDown);
        return box;
    }
}

