/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;

public final class ArrayUtils {
    private static final String APP_SCENE_MIDDLEEND_SUPPORT_SCENES = "app.scene.middleend.support.scenes";
    private static final String UNUSED_ENDSIGN = "\u2026\u2026%\uffe5#@";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ArrayUtils.class);
    public static final String UNSUPPORT_SIGN = "^";
    private static final String CRU = "cru";

    public static void clearCharArray(char[] charArray) {
        if (org.apache.commons.lang3.ArrayUtils.isEmpty((char[])charArray)) {
            return;
        }
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = '\u0000';
        }
    }

    public static boolean isEmpty(char[] charArray) {
        return null == charArray || charArray.length < 1;
    }

    public static void testUnsupportCommand(DevNode devNode, ICliConnection con) {
        if (ArrayUtils.isHostDevice(devNode) || devNode.getDeviceType().toString().matches("N[1-9]000")) {
            return;
        }
        String result = null;
        try {
            result = con.execCmd("testunsupportcmdxx");
            devNode.setUnSupportSign(result != null && result.contains(UNSUPPORT_SIGN) ? UNSUPPORT_SIGN : UNUSED_ENDSIGN);
        }
        catch (Exception e) {
            LOGGER.error("test unsupport cmd error!", e);
            return;
        }
    }

    public static boolean isHostDevice(DevNode devNode) {
        return ItDeviceType.Host.equals((Object)devNode.getItDeviceType()) || ItDeviceType.UltraPath.equals((Object)devNode.getItDeviceType()) || ItDeviceType.T3000.equals((Object)devNode.getItDeviceType()) || ItDeviceType.FUIONSTOR_EXP_NEW_NODE.equals((Object)devNode.getItDeviceType());
    }

    public static boolean isSwitchDevice(DevNode devNode) {
        return ItDeviceType.Switch.equals((Object)devNode.getItDeviceType());
    }

    public static boolean isDevSupportOutSvpAdd(DevNode devNode) {
        if (!DeviceTypeUtil.hasSVPModule(devNode)) {
            return true;
        }
        boolean isToolSupportOutSvpAdd = UserOpDataSaveUtil.getToolIniBoolProp((String)"isToolSupportHighEndDev");
        return LocalHostUtil.isRunInSvp() || isToolSupportOutSvpAdd;
    }

    public static boolean isHighEndDevOuterSvp(DevNode devNode) {
        return !LocalHostUtil.isRunInSvp() && DeviceTypeUtil.hasSVPModule(devNode);
    }

    public static boolean isHighEndDevSupportSvpAdd(String subScene) {
        String supportHendScenes = ApplicationContext.getInstance().getAppConfigNoExcept(APP_SCENE_MIDDLEEND_SUPPORT_SCENES);
        return !StringUtils.isNULLStr((String)supportHendScenes) && supportHendScenes.contains(subScene + ',');
    }

    public static boolean isSupportDomainUserAdd(String subScene) {
        String supportDomainUserScenes = ApplicationContext.getInstance().getAppConfigNoExcept("app.scene.domain.user.support.scenes");
        return StringUtils.isNULLStr((String)subScene) && !Objects.equals(UserOpDataSaveUtil.getToolIniProp((String)"tool.name"), CRU) || !StringUtils.isNULLStr((String)supportDomainUserScenes) && Arrays.asList(supportDomainUserScenes.split(",")).contains(subScene);
    }
}

