/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class IniReader {
    private Map<String, String> iniCache = new HashMap<String, String>();
    private String iniOriginalInfo = "";

    public IniReader(File file) {
        this(StreamUtils.readStringFormFile(file));
    }

    public IniReader(File file, String charset) {
        this(StreamUtils.readStringFormFile(file, charset));
    }

    public IniReader(InputStream inputstream) {
        this(StreamUtils.readStringFormInputStream(inputstream));
    }

    public IniReader(String iniInfo) {
        if (null == iniInfo) {
            throw new NullPointerException();
        }
        this.iniOriginalInfo = iniInfo;
        this.analyzeInfo();
    }

    private void analyzeInfo() {
        String[] lines;
        for (String line1 : lines = this.iniOriginalInfo.split("\n")) {
            if (";".startsWith(line1 = line1.trim()) || !line1.contains("=")) continue;
            int idx = line1.indexOf(61);
            this.iniCache.put(line1.substring(0, idx).trim(), line1.substring(idx + 1, line1.length()).trim());
        }
    }

    public String getString(String key) {
        String value = this.iniCache.get(key);
        if (StringUtils.isNULLStr(value)) {
            return "";
        }
        return value;
    }

    public boolean getBoolean(String key) {
        String value = this.iniCache.get(key);
        return Boolean.valueOf(value);
    }

    public int getInt(String key) {
        String value = this.iniCache.get(key);
        return StringUtils.str2Int(value);
    }
}

