/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.reflection.ReflectionUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UiMethod {
    private static final Logger log = LoggerFactory.getLogger(UiMethod.class);
    private static final int PWSL = 60;
    private static final Integer[] BUTTON_WIDTH_CHOICES = new Integer[]{50, 60, 70, 80, 90, 100, 110, 120, 130};
    private static final Integer ISM_SERVICE_TOOLTEXT_WIDTH = 14;
    private static final int COLOR_NUM = 16729404;
    private static ImageIcon blackRec = ResourceUtil.getImage("wizard_rectangle.jpg");
    private static final String NULLSTR = "";

    private UiMethod() {
    }

    public static void showProgressDialog(JDialog dialog, int seconds) {
        CloseProgressDialogThread thread = new CloseProgressDialogThread(dialog, seconds);
        thread.setUncaughtExceptionHandler((thd, throwable) -> log.error("thread {} execute error.", (Object)thread.getName(), (Object)throwable));
        thread.start();
        SwingUtilities.invokeLater(new ShowProgressDialogThread(dialog));
    }

    public static void setComponentSize(Dimension size, Component ... components) {
        for (Component comp : components) {
            comp.setPreferredSize(size);
            comp.setMinimumSize(size);
            comp.setMaximumSize(size);
        }
    }

    public static void setComponentProperty(String method, Object[] args, JComponent comps) {
        if (null == comps) {
            return;
        }
        ReflectionUtils.refInvoke(comps, method, args);
        Component[] components = comps.getComponents();
        if (null == components) {
            return;
        }
        for (Component comp : components) {
            ReflectionUtils.refInvoke(comp, method, args);
            if (!(comp instanceof JComponent)) continue;
            UiMethod.setComponentProperty(method, args, (JComponent)comp);
        }
    }

    public static void setBatchComponentProperty(String methodName, Object[] args, JComponent ... comps) {
        for (JComponent com : comps) {
            UiMethod.setComponentProperty(methodName, args, com);
        }
    }

    public static void setFont(JComponent jComponent, Font enFont, Font zhFont) {
        Locale loc = ApplicationContext.getInstance().getCurrentLanguage();
        if (loc.getLanguage().equals(Locale.CHINA.getLanguage())) {
            jComponent.setFont(zhFont);
        } else {
            jComponent.setFont(enFont);
        }
    }

    public static Dimension computeButtonPreferredSize(JButton button) {
        JButton tmpBtn = new JButton(button.getText());
        Dimension dim = tmpBtn.getPreferredSize();
        Integer[] widthChoices = BUTTON_WIDTH_CHOICES;
        int widthMultiple = 10;
        int height = 25;
        int preferredWidthIndex = UiMethod.findNearest(dim.width, widthChoices);
        dim.width = preferredWidthIndex >= 0 ? widthChoices[preferredWidthIndex] : (dim.width + widthMultiple / 2) / widthMultiple * widthMultiple;
        dim.height = height;
        return dim;
    }

    private static Integer findNearest(Integer width, Integer[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (width > array[i]) continue;
            return i;
        }
        return -1;
    }

    public static void putScreenCenter(Window window) {
        Dimension location = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation(location.width / 2 - window.getWidth() / 2, location.height / 2 - window.getHeight() / 2);
        window.setLocationRelativeTo(null);
    }

    public static GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gridBagC = new GridBagConstraints();
        gridBagC.gridx = 0;
        gridBagC.gridy = 0;
        gridBagC.insets = new Insets(12, 12, 12, 12);
        return gridBagC;
    }

    public static JPanel createImportTextPanel(String text, JTextComponent pathTextField, JButton btnBrowse) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = UiMethod.getGridBagConstraints();
        gbc.insets.left = 0;
        JLabel label = new JLabel(text);
        gbc.fill = 1;
        gbc.insets.top = 0;
        jPanel.add((Component)label, gbc);
        gbc.insets.bottom = 0;
        ++gbc.gridy;
        gbc.weightx = 100.0;
        gbc.weighty = 1.0;
        jPanel.add((Component)pathTextField, gbc);
        gbc.weighty = 0.0;
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.right = 0;
        jPanel.add((Component)btnBrowse, gbc);
        btnBrowse.setMnemonic('B');
        return jPanel;
    }

    public static JPanel createImportFilePanel(String borderTitle, String labelStr, JTextComponent filePath, JButton browseBtn) {
        JPanel jPanel = new JPanel();
        if (null != borderTitle) {
            TitledBorder border = new TitledBorder(borderTitle);
            jPanel.setBorder(border);
        }
        JLabel label = new JLabel(labelStr);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = UiMethod.getGridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets.left = 12;
        gbc.weightx = 0.0;
        jPanel.add((Component)label, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.insets.top = 0;
        jPanel.add((Component)filePath, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        jPanel.add((Component)browseBtn, gbc);
        return jPanel;
    }

    public static JComponent createImportFileBoxWithoutLbl(JTextComponent filePath, JButton browseBtn) {
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{filePath, browseBtn});
    }

    public static JComponent createImportFileBox(String borderTitle, String labelStr, JTextComponent filePath, JButton browseBtn) {
        TitledBorder titledBorder = null;
        if (null != borderTitle) {
            titledBorder = new TitledBorder(borderTitle);
        }
        JComponent label = UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)new JLabel(labelStr))});
        JComponent textAndBtn = UCD.buildHorizotalBox(null, (Component[])new Component[]{filePath, browseBtn});
        return UCD.buildVerticalBox((Border)titledBorder, (Component[])new Component[]{label, textAndBtn});
    }

    public static JLabel createHtmlLabel(String text1) {
        return UiMethod.createHtmlLabel(text1, 4);
    }

    public static JLabel createHtmlLabel(String text1, int fontSize) {
        return new JLabel("<html><font size=" + fontSize + ">" + text1 + "</font></html>");
    }

    public static void setCloseWhenEscKeyPressed(final JDialog jDialog) {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        jDialog.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        jDialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                jDialog.dispose();
            }
        });
    }

    public static void setButtonMnemonic(JButton button) {
        String textStr = button.getActionCommand();
        if (StringUtils.isChinese(textStr) && textStr.contains("(") && textStr.contains(")")) {
            String mnemonic = StringUtils.findMatchStr(textStr, "^.*\\((.*)\\).*$");
            button.setMnemonic(mnemonic.charAt(0));
        } else if (!StringUtils.isChinese(textStr)) {
            button.setMnemonic(textStr.charAt(0));
        }
    }

    public static void setBatchButtonMnemonic(JButton ... buttons) {
        for (JButton button : buttons) {
            UiMethod.setButtonMnemonic(button);
        }
    }

    public static Box createBtnBox(JButton btnConfirm, JButton btnCancel) {
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.add(Box.createHorizontalGlue());
        btnConfirm.setMnemonic(79);
        horizontalBox.add(btnConfirm);
        horizontalBox.add(Box.createHorizontalStrut(4));
        btnCancel.setMnemonic(67);
        Dimension btnSize = new Dimension(80, 25);
        UiMethod.setComponentSize(btnSize, btnCancel, btnConfirm);
        horizontalBox.add(btnCancel);
        return horizontalBox;
    }

    public static JComponent buildCompsLeft(Component ... comps) {
        return UCD.buildHorizontalBoxLeft((Component)UCD.buildHorizotalBox(null, (Component[])comps));
    }

    public static JComponent buildLeftLabel(String text) {
        JLabel jLabel = new JLabel(text);
        return UiMethod.buildCompsLeft(jLabel);
    }

    public static JComponent buildCompsLeft(int margin, Component ... comps) {
        return UCD.buildHorizontalBoxLeft((Component)UCD.buildHorizotalBox(null, (int)margin, (Component[])comps));
    }

    public static JComponent buildCompsRight(Component ... comps) {
        return UCD.buildHorizontalBoxRight((Component)UCD.buildHorizotalBox(null, (Component[])comps));
    }

    public static JComponent buildCompsRight(int margin, Component ... comps) {
        return UCD.buildHorizontalBoxRight((Component)UCD.buildHorizotalBox(null, (int)margin, (Component[])comps));
    }

    public static Box createHorizontalBox(Component ... components) {
        Box box = Box.createHorizontalBox();
        for (Component comp : components) {
            box.add(Box.createHorizontalStrut(12));
            box.add(comp);
            box.add(Box.createHorizontalStrut(12));
        }
        return box;
    }

    public static JPanel createHorizontalPanel(JLabel label, JComponent comp) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = UiMethod.getGridBagConstraints();
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jPanel.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.weightx = 100.0;
        gbc.fill = 2;
        gbc.anchor = 22;
        gbc.insets.left = 0;
        jPanel.add((Component)comp, gbc);
        return jPanel;
    }

    public static Box createVerticalBox(JComponent ... components) {
        Box box = Box.createVerticalBox();
        for (JComponent comp : components) {
            box.add(Box.createVerticalStrut(12));
            box.add(comp);
            box.add(Box.createVerticalStrut(12));
        }
        return box;
    }

    public static JButton createButton(String name) {
        JButton btn = new JButton(name);
        UiMethod.setButtonMnemonic(btn);
        return btn;
    }

    public static JButton createButton(String name, char mnemonic) {
        JButton btn = new JButton(name);
        btn.setMnemonic(mnemonic);
        UCD.formatMnemonicDisplay((AbstractButton)btn);
        return btn;
    }

    public static JButton createMenuButton(String btnName, final List<ToolAction> actions) {
        final JButton btn = new JButton(btnName){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics arg0) {
                super.paint(arg0);
                Icon arrow = UIManager.getIcon("Table.descendingSortIcon");
                int xWidth = this.getWidth() - arrow.getIconWidth() - 8;
                int yHeight = (this.getHeight() - arrow.getIconHeight()) / 2;
                arrow.paintIcon(this, arg0, xWidth, yHeight);
            }
        };
        btn.setToolTipText(btnName);
        btn.setFocusable(false);
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                JPopupMenu popmenu = new JPopupMenu();
                for (ToolAction action : actions) {
                    popmenu.add(action);
                    popmenu.setEnabled(action.isAvailable());
                }
                popmenu.show(event.getComponent(), 0, btn.getY() + btn.getHeight() - 3);
            }
        });
        Dimension dimension = UCD.computeButtonPreferredSize((AbstractButton)btn);
        dimension.height = 25;
        dimension.width += 12;
        btn.setMinimumSize(dimension);
        btn.setPreferredSize(dimension);
        btn.setMaximumSize(dimension);
        return btn;
    }

    public static JLabel createLabel(String text) {
        JLabel label = new JLabel(text + ":");
        return label;
    }

    public static void setComponentSameWidth(JComponent jComp1, JComponent jComp2) {
        double width2;
        double width1 = jComp1.getPreferredSize().getWidth();
        double width = width1 > (width2 = jComp2.getPreferredSize().getWidth()) ? width1 : width2;
        jComp2.setPreferredSize(new Dimension((int)width, jComp2.getHeight()));
        jComp2.setMinimumSize(new Dimension((int)width, jComp2.getHeight()));
        jComp1.setPreferredSize(new Dimension((int)width, jComp1.getHeight()));
        jComp1.setMinimumSize(new Dimension((int)width, jComp1.getHeight()));
    }

    public static void setComponentSameSize(JComponent ... comps) {
        Dimension size = null;
        for (JComponent comp : comps) {
            if (null == size) {
                size = comp.getMaximumSize();
            }
            UiMethod.setComponentSize(size, comp);
        }
    }

    public static void setComponentSameMaxWidthSize(JComponent ... comps) {
        Dimension size = null;
        for (JComponent comp : comps) {
            if (null == size) {
                size = comp.getMaximumSize();
            }
            if (size.width >= comp.getMaximumSize().width) continue;
            size = comp.getMaximumSize();
        }
        for (JComponent com : comps) {
            UiMethod.setComponentSize(size, com);
        }
    }

    public static JPanel createField(String label, JComponent component) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel(label));
        jPanel.add(component);
        return jPanel;
    }

    public static JEditorPane createLinkPane(String text) {
        JEditorPane jEditPane = UiMethod.createEditorPane();
        jEditPane.setText("<font face='' size='3'> <a href=\"\">" + text + "</a></font>");
        return jEditPane;
    }

    public static JEditorPane createEditorPane() {
        JEditorPane jEditPane = new JEditorPane();
        jEditPane.setContentType("text/html;charset=utf-8");
        jEditPane.setEditable(false);
        jEditPane.setFocusable(false);
        jEditPane.setEditable(false);
        jEditPane.setOpaque(false);
        return jEditPane;
    }

    public static JTextPane createTextPaneWithLeftIdent(String text, int leftIdent) {
        JTextPane textPane = new JTextPane();
        textPane.setFocusable(false);
        textPane.setEditable(false);
        textPane.setOpaque(false);
        textPane.setText(text);
        Style style = textPane.getStyle("default");
        StyleConstants.setFirstLineIndent(style, Float.valueOf(leftIdent).floatValue());
        return textPane;
    }

    public static JTextPane createTextPaneWithDefaultLeftIdent(String text) {
        return UiMethod.createTextPaneWithLeftIdent(text, 0);
    }

    public static JPanel createPanel(String panelBorderText) {
        JPanel jPanel = new JPanel();
        TitledBorder border = new TitledBorder(panelBorderText);
        jPanel.setBorder(border);
        return jPanel;
    }

    public static IsmTextField createDateTextField() {
        return IsmTextField.getNameTextField((String)"([0-9-:\\s])*", (String)NULLSTR, (int)22, (int)ISM_SERVICE_TOOLTEXT_WIDTH);
    }

    public static JComponent buildVerticalOppositionalPan(Component top, Component bottom) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(top, "North");
        panel.add(bottom, "South");
        return panel;
    }

    public static IsmTextField createIpv4TextField() {
        return IsmTextField.getNameTextField((String)"([0-9]|\\.)*", (String)NULLSTR, (int)15, (int)ISM_SERVICE_TOOLTEXT_WIDTH);
    }

    public static IsmTextField createIpv6TextField() {
        return IsmTextField.getNameTextField((String)"([a-fA-F0-9]|:)*", (String)NULLSTR, (int)45, (int)ISM_SERVICE_TOOLTEXT_WIDTH);
    }

    public static IsmTextField createIpv4v6TextField() {
        return IsmTextField.getNameTextField((String)"([a-fA-F0-9]|:|\\.)*", (String)NULLSTR, (int)45, (int)ISM_SERVICE_TOOLTEXT_WIDTH);
    }

    public static IsmTextField createEmailTextField() {
        return IsmTextField.getNameTextField((String)"([a-zA-Z0-9]|[-_@.])*", (String)NULLSTR, (int)128, (int)ISM_SERVICE_TOOLTEXT_WIDTH);
    }

    public static TaskResult asyncExecute(Window parent, ServiceTask serviceTask) {
        ProgressDialog progressDialog = new ProgressDialog(parent);
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        return taskExecutor.execute(serviceTask);
    }

    public static JPanel buildVerticalCheckboxPanel(JCheckBox ... box) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        for (JCheckBox cb : box) {
            jPanel.add(cb);
            jPanel.add(Box.createVerticalStrut(12));
        }
        jPanel.add(Box.createVerticalGlue());
        return jPanel;
    }

    public static IsmTextField getUsernameFiled() {
        IsmTextField username = IsmTextField.getNameTextField((String)"^[a-zA-Z_][0-9a-zA-Z_-]*", (String)NULLSTR, (int)60, (int)ISM_SERVICE_TOOLTEXT_WIDTH);
        return username;
    }

    public static IsmTextField getDomainFiled() {
        IsmTextField domain = IsmTextField.getNameTextField((String)"^[a-zA-Z][0-9a-zA-Z-\\._]*", (String)NULLSTR, (int)60, (int)ISM_SERVICE_TOOLTEXT_WIDTH);
        return domain;
    }

    public static IsmTextField getSshPortFiled() {
        IsmTextField port = IsmTextField.getNameTextField((String)"[0-9]{1,5}", (String)NULLSTR, (int)60, (int)ISM_SERVICE_TOOLTEXT_WIDTH);
        return port;
    }

    public static JComponent createTextWithPicture(String info, boolean ustextArea) {
        JLabel imgageLabel = new JLabel(blackRec);
        imgageLabel.setSize(blackRec.getIconWidth(), blackRec.getIconHeight());
        JComponent iconBox = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalStrut(6), imgageLabel, Box.createVerticalGlue()});
        JComponent comp = UiMethod.buildCompsLeft(0, iconBox, Box.createHorizontalStrut(6), ustextArea ? UiMethod.createJTextArea(info) : new JLabel(info));
        return comp;
    }

    public static JComponent createTextWithPicture(String info) {
        return UiMethod.createTextWithPicture(info, true);
    }

    public static JComponent createRequiredLabel(String labelStr, boolean required) {
        Box label = Box.createHorizontalBox();
        if (required) {
            label.add(UiMethod.createRequiredLabel());
        } else {
            label.add(UiMethod.createBlank2Label());
        }
        label.add(new JLabel(labelStr));
        return label;
    }

    public static JPanel createSquareLayoutPanel(JComponent[] leftCompList, JComponent[] rightCompList, int ... markRow) {
        int compSize = leftCompList.length;
        if (compSize != rightCompList.length) {
            throw new IllegalArgumentException("Left componenet is not equal with right component.");
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagC = UiMethod.getGridBagConstraints();
        gridBagC.gridy = 0;
        gridBagC.fill = 2;
        gridBagC.anchor = 18;
        gridBagC.insets.top = 4;
        for (int i = 0; i < compSize; ++i) {
            if (i == compSize - 1) {
                gridBagC.insets.bottom = 0;
            }
            gridBagC.insets.left = 0;
            gridBagC.gridx = 0;
            gridBagC.weightx = 0.0;
            JComponent leftComp = leftCompList[i];
            JComponent rightComp = rightCompList[i];
            gridBagC.insets.right = 12;
            panel.add((Component)leftComp, gridBagC);
            gridBagC.gridx = 1;
            gridBagC.weightx = 1.0;
            gridBagC.insets.right = 0;
            panel.add((Component)rightComp, gridBagC);
            UiMethod.addMarkStar(panel, gridBagC, i, markRow);
            ++gridBagC.gridy;
            gridBagC.insets.top = 0;
        }
        return panel;
    }

    private static void addMarkStar(JPanel panel, GridBagConstraints gridBagC, int index, int[] markRow) {
        if (null == markRow || markRow.length == 0) {
            return;
        }
        for (int row : markRow) {
            if (index != row) continue;
            JLabel starLabel = new JLabel("*");
            starLabel.setForeground(new Color(16729404));
            gridBagC.gridx = 2;
            gridBagC.weightx = 0.0;
            gridBagC.insets.left = 4;
            panel.add((Component)starLabel, gridBagC);
        }
    }

    public static JComponent buildCrossBox(Component ... comps) {
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i = 0; i < comps.length; ++i) {
            Box hView = null;
            int next = i + 1;
            hView = next < comps.length ? UCD.buildHorizontalBoxLeft((Component)UCD.buildHorizotalBox(null, (Component[])new Component[]{comps[i], comps[++i]})) : UCD.buildHorizontalBoxLeft((Component)UCD.buildHorizotalBox(null, (Component[])new Component[]{comps[i], Box.createGlue()}));
            lines.add(hView);
        }
        lines.add(Box.createVerticalGlue());
        return UCD.buildVerticalBox(null, (Component[])lines.toArray(new JComponent[lines.size()]));
    }

    public static JComponent buildCompSpace(JComponent jComp, Border border) {
        JComponent hComp = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), jComp, Box.createHorizontalStrut(0)});
        JComponent vComp = UCD.buildVerticalBox((Border)border, (Component[])new Component[]{hComp, Box.createVerticalStrut(0)});
        return vComp;
    }

    public static JComponent buildFrameSpace(JComponent jComp, int margin) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(margin));
        hBox.add(jComp);
        hBox.add(Box.createHorizontalStrut(margin));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(margin));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(margin));
        return vBox;
    }

    public static JLabel createColonLabel(String text) {
        return new JLabel(text + ":");
    }

    public static IsmPasswordField getPasswordFiled() {
        IsmPasswordField psd = new IsmPasswordField(ISM_SERVICE_TOOLTEXT_WIDTH.intValue(), 60);
        psd.getPasswordPopupInfo().removeAllInform();
        psd.setMaxValidRestrict(60);
        return psd;
    }

    public static IsmPasswordField getPasswordField(int len) {
        return UiMethod.getPasswordField(len, 60);
    }

    public static IsmPasswordField getPasswordField(int len, int column) {
        IsmPasswordField password = new IsmPasswordField(len, column);
        password.getPasswordPopupInfo().removeAllInform();
        return password;
    }

    public static JComponent buildOptionsPan(String ... infos) {
        Box boxs = Box.createVerticalBox();
        for (int i = 0; i < infos.length; ++i) {
            boxs.add(UiMethod.createTextWithPicture(infos[i]));
            if (i >= infos.length - 1) continue;
            boxs.add(Box.createVerticalStrut(8));
        }
        return boxs;
    }

    public static JTextArea createJTextArea(String pragraph) {
        JTextArea area = new JTextArea();
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setFocusable(false);
        area.setEditable(false);
        area.setOpaque(false);
        area.setBackground(UIManager.getColor("Panel.background"));
        area.setText(pragraph);
        return area;
    }

    public static boolean showInputDialog(JDialog parnet, String title, String desc, List<JComponent> comps) {
        InputDialog inputDialog = new InputDialog(parnet, title, desc, comps);
        inputDialog.toFront();
        inputDialog.setVisible(true);
        return !inputDialog.isCancelClose();
    }

    public static void addTableLinkCellCursorPatch(final IsmTable table) {
        table.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                int curRolloverRow = table.rowAtPoint(event.getPoint());
                if (-1 == curRolloverRow) {
                    table.setCursor(new Cursor(0));
                    return;
                }
                int curRolloverColumn = table.columnAtPoint(event.getPoint());
                Object cell = table.getValueAt(curRolloverRow, curRolloverColumn);
                boolean isActionValid = false;
                if (cell instanceof IsmTableCell.HyperlinkCell) {
                    isActionValid = true;
                }
                table.setCursor(new Cursor(isActionValid ? 12 : 0));
            }
        });
    }

    public static void addTableLinkCellCursor(final IsmTable ismTable) {
        ismTable.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                int curRolloverRow = ismTable.rowAtPoint(event.getPoint());
                if (-1 == curRolloverRow) {
                    ismTable.setCursor(new Cursor(0));
                    return;
                }
            }
        });
    }

    private static JLabel createRequiredLabel() {
        JLabel symbolLabel = new JLabel("* ");
        symbolLabel.setForeground(new Color(16729404));
        return symbolLabel;
    }

    private static JLabel createBlank2Label() {
        JLabel symbolLabel = new JLabel("   ");
        return symbolLabel;
    }

    public static void setColumnSize(JTable table, int i, int preferedWidth, int maxWidth, int minWidth) {
        TableColumnModel cm = table.getColumnModel();
        TableColumn column = cm.getColumn(i);
        column.setPreferredWidth(preferedWidth);
        column.setMaxWidth(maxWidth);
        column.setMinWidth(minWidth);
    }

    static class InputDialog
    extends PublicDialog {
        private static final long serialVersionUID = -4821923950621684350L;
        private boolean cancelClose = true;

        public InputDialog(JDialog parnet, String title, String desc, List<JComponent> comps) {
            super(parnet);
            this.setModal(true);
            this.setResizable(false);
            this.setTitle(title);
            this.initUI(desc, comps);
            this.initListener();
            this.pack();
            SwingUtil.putScreenCenter((Window)this);
        }

        private void initListener() {
            JButton okButton = this.getOkBtn();
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cancelClose = false;
                    this.dispose();
                }
            });
        }

        public boolean isCancelClose() {
            return this.cancelClose;
        }

        private void initUI(String desc, List<JComponent> component) {
            JTextPane descPan = UiMethod.createTextPaneWithDefaultLeftIdent(desc);
            JComponent inputComps = UiMethod.buildCrossBox(component.toArray(new JComponent[component.size()]));
            JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{descPan, inputComps});
            this.getContentPanel().setLayout(new BorderLayout());
            this.getContentPanel().add((Component)UiMethod.buildFrameSpace(view, 12), "North");
        }
    }

    private static class ShowProgressDialogThread
    implements Runnable {
        private JDialog dialog = null;

        public ShowProgressDialogThread(JDialog jDialog) {
            this.dialog = jDialog;
        }

        @Override
        public void run() {
            this.dialog.setVisible(true);
        }
    }

    private static class CloseProgressDialogThread
    extends Thread {
        private static final int NUM_1000 = 1000;
        private JDialog dialog = null;
        private int seconds = 0;

        public CloseProgressDialogThread(JDialog dialog, int seconds) {
            this.dialog = dialog;
            this.seconds = seconds;
        }

        @Override
        public void run() {
            try {
                Thread.sleep((long)this.seconds * 1000L);
            }
            catch (InterruptedException e) {
                ToolLoggerFactory.getLogger(this.getClass()).info("CloseProgressDialogThread sleep is interrupted." + e);
            }
            this.dialog.dispose();
        }
    }
}

