/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils.excel;

import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jetbrains.annotations.NotNull;

public class POIUtils {
    public static String getStringCellValue(Cell cell) {
        String value = "";
        if (null == cell) {
            return value;
        }
        if (cell.getCellType() != CellType.STRING) {
            cell.setCellType(CellType.STRING);
        }
        value = cell.getStringCellValue();
        return value;
    }

    public static HSSFCellStyle createTitleStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = POIUtils.getCellStyle(workbook, POIUtils.getFont(workbook), false);
        style.setFillForegroundColor(IndexedColors.AQUA.index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }

    public static HSSFCellStyle createContentStyle(HSSFWorkbook workbook) {
        return POIUtils.getCellStyle(workbook, POIUtils.getFont(workbook), true);
    }

    public static HSSFCellStyle createFailedStyle(HSSFWorkbook workbook) {
        Font font = POIUtils.getFont(workbook);
        font.setColor(IndexedColors.RED.index);
        return POIUtils.getCellStyle(workbook, font, true);
    }

    @NotNull
    private static HSSFCellStyle getCellStyle(HSSFWorkbook workbook, Font font, boolean wrapText) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(wrapText);
        style.setDataFormat(workbook.createDataFormat().getFormat("@"));
        style.setFont(font);
        return style;
    }

    @NotNull
    private static Font getFont(HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontName("Times New Roman");
        font.setFontHeightInPoints((short)11);
        font.setBold(false);
        font.setItalic(false);
        return font;
    }

    public static void mergeCells(Sheet sheet, int startCol, int startRow, int endCol, int endRow) {
        CellStyle style = sheet.getRow(startRow).getCell(startCol).getCellStyle();
        for (int i = startRow; i <= endRow; ++i) {
            Row row = sheet.getRow(i);
            if (null == row) {
                row = sheet.createRow(i);
            }
            for (int j = startCol; j <= endCol; ++j) {
                Cell cell = row.getCell(j);
                if (null == cell) {
                    cell = row.createCell(j);
                }
                cell.setCellStyle(style);
            }
        }
        sheet.addMergedRegion(new CellRangeAddress(startRow, endRow, startCol, endCol));
    }

    public static void setCellValue(Sheet sheet, int rowNum, int colNum, String newText, HSSFCellStyle style) {
        Cell cell;
        Row row = sheet.getRow(rowNum);
        if (null == row) {
            row = sheet.createRow(rowNum);
        }
        if (null == (cell = row.getCell(colNum))) {
            cell = row.createCell(colNum);
        }
        cell.setCellValue(newText);
        if (null != style) {
            cell.setCellStyle((CellStyle)style);
        }
    }

    public static boolean isBlankRow(Row row) {
        if (row == null) {
            return true;
        }
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            if (cell == null || CellType.BLANK == cell.getCellType()) continue;
            return false;
        }
        return true;
    }

    public static int getSheetNotEmptyRowNum(Sheet sheet) {
        int num = 0;
        for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            if (POIUtils.isBlankRow(sheet.getRow(rowNum))) continue;
            ++num;
        }
        return num;
    }

    public static int getWorkBookNotEmptyRowNum(Workbook book) {
        int notEmptyRowNum = 0;
        if (null != book) {
            for (int sheetIdx = 0; sheetIdx < book.getNumberOfSheets(); ++sheetIdx) {
                notEmptyRowNum += POIUtils.getSheetNotEmptyRowNum(book.getSheetAt(sheetIdx));
            }
        }
        return notEmptyRowNum;
    }

    public static boolean isExcelBookNumLegal(Workbook workbook, int maxNum) {
        return POIUtils.getWorkBookNotEmptyRowNum(workbook) > maxNum;
    }

    private POIUtils() {
    }
}

