/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion;

import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.scaleout.expansion.common.Constants;
import com.huawei.ism.tool.scaleout.expansion.common.Context;
import com.huawei.ism.tool.scaleout.expansion.parse.ProductInitiator;
import com.huawei.ism.tool.service.rest.handle.SmartKitSceneInterceptor;
import com.huawei.ism.tool.service.rest.util.CertsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication(scanBasePackages={"com.huawei.ism.tool.scaleout.expansion", "com.huawei.ism.tool.service.rest"})
public class SpringBootStarter {
    private static final Logger log = LoggerFactory.getLogger(SpringBootStarter.class);

    public static void main(String[] args) {
        SpringBootStarter.startApplication();
    }

    public static void startApplication() {
        SpringBootStarter.initProducts();
        CompletableFuture.runAsync(SpringBootStarter::startBrowser);
        CertsUtil.generateDefaultSelfSignedCerts();
        SpringApplication.run(SpringBootStarter.class, (String[])new String[0]);
    }

    private static void initProducts() {
        Context.INS.getSupportProducts().addAll(ProductInitiator.INS.initProductsPackage());
    }

    private static void startBrowser() {
        try {
            String scene = SecurityUtils.generatePassword((int)36);
            SmartKitSceneInterceptor.setScene((String)scene);
            String[] cmdArray = new String[]{Constants.WORK_PATH + File.separator + "electron\\ftd-browser.exe", "common route=zkexpansion"};
            String[] envs = new String[]{"scene=\"" + scene + "\""};
            Process exec = Runtime.getRuntime().exec(cmdArray, envs);
            log.info("stand out:{}", (Object)IOUtils.readLines((InputStream)exec.getInputStream(), (String)"gbk"));
            log.error("error out:{}", (Object)IOUtils.readLines((InputStream)exec.getErrorStream(), (String)"gbk"));
        }
        catch (IOException e) {
            log.error("start browser failed", (Throwable)e);
        }
    }
}

