/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.common;

import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.scaleout.expansion.common.Constants;
import com.huawei.ism.tool.scaleout.expansion.common.TaskContext;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Product;
import com.huawei.ism.tool.scaleout.expansion.enumeration.ModuleEnum;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
extends AbstractContext {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    public static final Context INS = new Context();
    private final ModuleEnum module = ModuleEnum.ZK;
    private List<Product> supportProducts = new ArrayList<Product>();

    public Optional<Product> findProduct(@NotNull DevNode devNode) {
        return this.getSupportProducts().stream().filter(product -> Objects.equals(product.getProductModel(), devNode.getDeviceType().toString())).filter(product -> devNode.getProductVersion().contains(product.getProductVersion())).findFirst();
    }

    public String getPyPath() {
        return String.join((CharSequence)File.separator, Constants.WORK_PATH, "packages", "scaleout_expansion_script", "py");
    }

    public void shutdown() {
        Executors.newSingleThreadScheduledExecutor().schedule(this::fireToolStopped, 1L, TimeUnit.SECONDS);
    }

    public String getResourcePath() {
        return Constants.WORK_PATH + File.separator + String.join((CharSequence)File.separator, "packages", "scaleout_expansion_script", "template", "data");
    }

    public String getTempPath() {
        return Constants.WORK_PATH + File.separator + "reportTemplate";
    }

    public String getTemplatePath() {
        return String.join((CharSequence)File.separator, "packages", "scaleout_expansion_script", "template");
    }

    public String getTempDumpPath(String taskId) {
        return Constants.WORK_PATH + File.separator + "temp" + File.separator + TaskContext.INS.getTempDumpDirectory().get(taskId);
    }

    private Context() {
    }

    public ModuleEnum getModule() {
        return this.module;
    }

    public List<Product> getSupportProducts() {
        return this.supportProducts;
    }
}

