/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.common;

import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionConfNode;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionDevNode;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.response.ControlClusterInfo;
import com.huawei.ism.tool.scaleout.expansion.exception.devnode.DevNodeNotExistsException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevNodeManager {
    private static final Logger log = LoggerFactory.getLogger(DevNodeManager.class);
    public static final DevNodeManager INS = new DevNodeManager();
    private Map<String, ExpansionDevNode> devNodeMap = new HashMap<String, ExpansionDevNode>();
    private Map<String, List<ExpansionConfNode>> expansionConfMap = new HashMap<String, List<ExpansionConfNode>>();
    private Map<String, ControlClusterInfo> controlClusterInfoMap = new HashMap<String, ControlClusterInfo>();

    public ExpansionDevNode findDevNode(String sn) throws DevNodeNotExistsException {
        if (!this.devNodeMap.containsKey(sn)) {
            throw new DevNodeNotExistsException(sn);
        }
        return this.devNodeMap.get(sn);
    }

    public List<ExpansionConfNode> getExpansionConfs(String deviceSn) {
        return this.expansionConfMap.get(deviceSn);
    }

    public boolean isExistConfNodes(String deviceSn) {
        return this.expansionConfMap.containsKey(deviceSn);
    }

    public void addConfNodes(String deviceSn, List<ExpansionConfNode> expansionConfNodes) {
        this.expansionConfMap.put(deviceSn, expansionConfNodes);
    }

    public void addControlCluster(String deviceSn, ControlClusterInfo controlClusterInfo) {
        this.controlClusterInfoMap.put(deviceSn, controlClusterInfo);
    }

    public boolean isExistControlInfo(String deviceSn) {
        return this.controlClusterInfoMap.containsKey(deviceSn);
    }

    public ControlClusterInfo getControlClusterInfo(String deviceSn) {
        return this.controlClusterInfoMap.get(deviceSn);
    }

    public void addDevNode(String deviceSn, ExpansionDevNode devNode) {
        this.devNodeMap.put(deviceSn, devNode);
    }

    public void removeDevNode(String deviceSn) {
        this.devNodeMap.remove(deviceSn);
    }

    public void removeConfs(String deviceSn) {
        this.expansionConfMap.remove(deviceSn);
    }

    private DevNodeManager() {
    }
}

