/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.entity.devnode;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.OmmAuthInfo;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Product;
import com.huawei.ism.tool.scaleout.expansion.enumeration.TaskStatus;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExpansionDevNode {
    private final BusinessDevice businessDevice;
    private final Product product;
    private OmmAuthInfo ommAuthInfo;
    private TaskStatus expansionDevNodeStatus = TaskStatus.WAIT_CONFIG;
    private List<String> expansionStrategies = new ArrayList<String>();
    private int progress = 0;
    private boolean allowModifyTactics = true;

    public String getId() {
        return this.getOriDevNode().getDeviceSerialNumber();
    }

    public DevNode getOriDevNode() {
        return this.businessDevice.getDevNode();
    }

    public boolean isOmmAuthPass() {
        return !Objects.isNull(this.ommAuthInfo) && this.ommAuthInfo.isAuthPass();
    }

    public boolean isAlreadyConfig() {
        return this.expansionDevNodeStatus == TaskStatus.ALREADY_CONFIG;
    }

    public BusinessDevice getBusinessDevice() {
        return this.businessDevice;
    }

    public Product getProduct() {
        return this.product;
    }

    public OmmAuthInfo getOmmAuthInfo() {
        return this.ommAuthInfo;
    }

    public TaskStatus getExpansionDevNodeStatus() {
        return this.expansionDevNodeStatus;
    }

    public List<String> getExpansionStrategies() {
        return this.expansionStrategies;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isAllowModifyTactics() {
        return this.allowModifyTactics;
    }

    public void setOmmAuthInfo(OmmAuthInfo ommAuthInfo) {
        this.ommAuthInfo = ommAuthInfo;
    }

    public void setExpansionDevNodeStatus(TaskStatus expansionDevNodeStatus) {
        this.expansionDevNodeStatus = expansionDevNodeStatus;
    }

    public void setExpansionStrategies(List<String> expansionStrategies) {
        this.expansionStrategies = expansionStrategies;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setAllowModifyTactics(boolean allowModifyTactics) {
        this.allowModifyTactics = allowModifyTactics;
    }

    public ExpansionDevNode(BusinessDevice businessDevice, Product product) {
        this.businessDevice = businessDevice;
        this.product = product;
    }
}

