/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.entity.pyitem;

import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.scaleout.expansion.common.ResourceConstants;
import com.huawei.ism.tool.scaleout.expansion.entity.config.BasicTaskConf;
import com.huawei.ism.tool.scaleout.expansion.entity.pyitem.PyItemResult;
import com.huawei.ism.tool.scaleout.expansion.enumeration.PyItemStatus;
import com.huawei.ism.tool.scaleout.expansion.task.TaskEnv;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyItem {
    private static final Logger log = LoggerFactory.getLogger(PyItem.class);
    private String itemId;
    private BasicTaskConf taskConf;
    private String scriptPath;
    private JythonExecuter jythonExecuter;
    private String executeMethod;
    private String rollbackMethod;
    private PyItemResult result;

    public PyItemResult execute(TaskEnv taskEnv) {
        return this.doExecuteOrRollback(this.getExecuteMethod(), taskEnv);
    }

    public PyItemResult rollback(TaskEnv taskEnv) {
        return this.doExecuteOrRollback(this.getRollbackMethod(), taskEnv);
    }

    private PyItemResult doExecuteOrRollback(String method, TaskEnv taskEnv) {
        try {
            this.getResult().init();
            this.getJythonExecuter().compileScript(new File(this.getScriptPath()));
            log.info("item id: {}, start execute method: {}", (Object)this.getItemId(), (Object)method);
            Object resultObj = this.getJythonExecuter().simpleInvokeFunction("execute", new Object[]{taskEnv, method});
            this.setResult(new PyItemResult((Map)resultObj, this.taskConf, taskEnv.getTaskId()));
        }
        catch (Exception e) {
            log.error("failed {} item: {}", new Object[]{method, this.getItemId(), e});
            this.setResult(this.getSysErrPyResult());
        }
        return this.getResult();
    }

    private PyItemResult getSysErrPyResult() {
        PyItemResult errResult = new PyItemResult();
        errResult.setItemStatus(PyItemStatus.NOT_PASS);
        errResult.setErrInfo(ResourceConstants.UNEXPECTED_ERROR_MSG);
        return errResult;
    }

    public static Logger getLogger() {
        return log;
    }

    private static PyItemResult $default$result() {
        return new PyItemResult();
    }

    PyItem(String itemId, BasicTaskConf taskConf, String scriptPath, JythonExecuter jythonExecuter, String executeMethod, String rollbackMethod, PyItemResult result) {
        this.itemId = itemId;
        this.taskConf = taskConf;
        this.scriptPath = scriptPath;
        this.jythonExecuter = jythonExecuter;
        this.executeMethod = executeMethod;
        this.rollbackMethod = rollbackMethod;
        this.result = result;
    }

    public static PyItemBuilder builder() {
        return new PyItemBuilder();
    }

    public String getItemId() {
        return this.itemId;
    }

    public BasicTaskConf getTaskConf() {
        return this.taskConf;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public JythonExecuter getJythonExecuter() {
        return this.jythonExecuter;
    }

    public String getExecuteMethod() {
        return this.executeMethod;
    }

    public String getRollbackMethod() {
        return this.rollbackMethod;
    }

    public PyItemResult getResult() {
        return this.result;
    }

    public void setResult(PyItemResult result) {
        this.result = result;
    }

    public static class PyItemBuilder {
        private String itemId;
        private BasicTaskConf taskConf;
        private String scriptPath;
        private JythonExecuter jythonExecuter;
        private String executeMethod;
        private String rollbackMethod;
        private boolean result$set;
        private PyItemResult result$value;

        PyItemBuilder() {
        }

        public PyItemBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public PyItemBuilder taskConf(BasicTaskConf taskConf) {
            this.taskConf = taskConf;
            return this;
        }

        public PyItemBuilder scriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
            return this;
        }

        public PyItemBuilder jythonExecuter(JythonExecuter jythonExecuter) {
            this.jythonExecuter = jythonExecuter;
            return this;
        }

        public PyItemBuilder executeMethod(String executeMethod) {
            this.executeMethod = executeMethod;
            return this;
        }

        public PyItemBuilder rollbackMethod(String rollbackMethod) {
            this.rollbackMethod = rollbackMethod;
            return this;
        }

        public PyItemBuilder result(PyItemResult result) {
            this.result$value = result;
            this.result$set = true;
            return this;
        }

        public PyItem build() {
            PyItemResult result$value = this.result$value;
            if (!this.result$set) {
                result$value = PyItem.$default$result();
            }
            return new PyItem(this.itemId, this.taskConf, this.scriptPath, this.jythonExecuter, this.executeMethod, this.rollbackMethod, result$value);
        }

        public String toString() {
            return "PyItem.PyItemBuilder(itemId=" + this.itemId + ", taskConf=" + this.taskConf + ", scriptPath=" + this.scriptPath + ", jythonExecuter=" + this.jythonExecuter + ", executeMethod=" + this.executeMethod + ", rollbackMethod=" + this.rollbackMethod + ", result$value=" + this.result$value + ")";
        }
    }
}

