/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.entity.pyitem;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.scaleout.expansion.common.TaskContext;
import com.huawei.ism.tool.scaleout.expansion.entity.config.BasicTaskConf;
import com.huawei.ism.tool.scaleout.expansion.enumeration.PyItemStatus;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyItemResult {
    private static final Logger log = LoggerFactory.getLogger(PyItemResult.class);
    private static final int MAX_DISPLAY_ROWS = 20;
    private static final String NEW_LINE = "\n";
    PyItemStatus itemStatus;
    String originInfo = "--";
    String errInfo = "--";
    String oriDumpPath = "--";

    public PyItemResult(Map<String, Object> resultMap, BasicTaskConf taskConf, String taskId) {
        this.itemStatus = PyItemStatus.getStatusByCode((Integer)resultMap.get("result"));
        this.originInfo = this.dumpSourceInfo((String)resultMap.get("ori_info"), taskConf, taskId);
        this.errInfo = (String)resultMap.get("err_info");
    }

    public String dumpSourceInfo(String oriInfo, BasicTaskConf taskConf, String taskId) {
        if (Objects.isNull(taskConf)) {
            return "";
        }
        log.info("Start dump original information, itemId : {} ", (Object)taskConf.getId());
        String[] split = oriInfo.split(NEW_LINE);
        String display = "";
        if (split.length < 20 || taskConf.isNeedConfirm()) {
            return oriInfo;
        }
        try {
            for (int index = 0; index < split.length; ++index) {
                display = String.join((CharSequence)NEW_LINE, display, split[index]);
                if (index != 20) continue;
                display = String.join((CharSequence)NEW_LINE, display, ResourceUtil.getString((String)"origin.info.too.much.remind"));
                break;
            }
            File file = this.creatOriginInfoFile(taskConf.getId(), taskId);
            StreamUtils.writeInfo2File((byte[])oriInfo.getBytes(StandardCharsets.UTF_8), (String)file.getCanonicalPath());
            log.info("Dump original information success, itemId : {} ", (Object)taskConf.getId());
            return display;
        }
        catch (IOException e) {
            log.error("Failed to dump the original information.");
            return "No available information.";
        }
    }

    @NotNull
    private File creatOriginInfoFile(String itemId, String taskId) {
        String tempDumpDirectoryName = "ControlRecord_" + taskId;
        TaskContext.INS.getTempDumpDirectory().put(taskId, tempDumpDirectoryName);
        File file = new File(ApplicationContext.getInstance().getWorkPath() + File.separator + "temp" + File.separator + tempDumpDirectoryName + File.separator + itemId + ".txt");
        if (file.exists()) {
            FileUtils.deleteFile((File)file);
        }
        if (!file.getParentFile().exists()) {
            FileUtils.createDir((String)file.getParent());
        }
        this.oriDumpPath = "\\record\\" + itemId + ".txt";
        return file;
    }

    public boolean isSuccess() {
        return this.itemStatus == PyItemStatus.PASS || this.itemStatus == PyItemStatus.NOT_INVOLVED;
    }

    public void init() {
        this.originInfo = "--";
        this.errInfo = "--";
    }

    public PyItemStatus getItemStatus() {
        return this.itemStatus;
    }

    public String getOriginInfo() {
        return this.originInfo;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public String getOriDumpPath() {
        return this.oriDumpPath;
    }

    public void setItemStatus(PyItemStatus itemStatus) {
        this.itemStatus = itemStatus;
    }

    public void setOriginInfo(String originInfo) {
        this.originInfo = originInfo;
    }

    public void setErrInfo(String errInfo) {
        this.errInfo = errInfo;
    }

    public void setOriDumpPath(String oriDumpPath) {
        this.oriDumpPath = oriDumpPath;
    }

    public PyItemResult() {
    }
}

