/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.entity.vo;

import com.huawei.ism.tool.scaleout.expansion.task.ItemTask;
import java.util.List;
import java.util.stream.Collectors;

public class ItemVO {
    private String id;
    private String name;
    private String beginTime;
    private String endTime;
    private int status;
    private String errInfo;
    private String oriInfo;
    private String errMsg;
    private List<ItemVO> subItems;
    private boolean supportRollback;
    private String description;
    private boolean needConfirm;
    private int progress;

    public ItemVO(ItemTask itemTask) {
        this.id = itemTask.getConf().getId();
        this.name = itemTask.getConf().getName();
        this.beginTime = itemTask.getBeginTimeStr();
        this.endTime = itemTask.getEndTimeStr();
        this.status = itemTask.getStatus().getCode();
        this.errInfo = itemTask.getPyItem().getResult().getErrInfo();
        this.oriInfo = itemTask.getPyItem().getResult().getOriginInfo();
        this.errMsg = itemTask.getErrMsg();
        this.supportRollback = itemTask.getConf().isOriSupportRollback();
        this.subItems = itemTask.getChildren().stream().map(ItemTask.class::cast).map(ItemVO::new).collect(Collectors.toList());
        this.description = itemTask.getConf().getDescription();
        this.needConfirm = itemTask.getConf().isNeedConfirm();
        this.progress = (int)itemTask.getProgress();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public String getOriInfo() {
        return this.oriInfo;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public List<ItemVO> getSubItems() {
        return this.subItems;
    }

    public boolean isSupportRollback() {
        return this.supportRollback;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isNeedConfirm() {
        return this.needConfirm;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setErrInfo(String errInfo) {
        this.errInfo = errInfo;
    }

    public void setOriInfo(String oriInfo) {
        this.oriInfo = oriInfo;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setSubItems(List<ItemVO> subItems) {
        this.subItems = subItems;
    }

    public void setSupportRollback(boolean supportRollback) {
        this.supportRollback = supportRollback;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNeedConfirm(boolean needConfirm) {
        this.needConfirm = needConfirm;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }
}

