/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.enumeration;

import java.util.Arrays;

public enum TaskStatus {
    WAIT_CONFIG(0, "wait_config"),
    ALREADY_CONFIG(1, "already_config"),
    WAITED(2, "waited"),
    PAUSED(3, "paused"),
    RUNNING(4, "running"),
    SUCCESS(5, "success"),
    FAILED(6, "failed"),
    NOT_INVOLVED(7, "not_involved"),
    IGNORED(8, "ignored"),
    ROLLBACK_ING(9, "rollback_ing"),
    ROLLBACK_SUCCESS(10, "rollback_success"),
    ROLLBACK_FAILED(11, "rollback_failed");

    private final int code;
    private final String desc;

    public static TaskStatus getStatusByCode(int code) {
        return Arrays.stream(TaskStatus.values()).filter(taskStatus -> taskStatus.getCode() == code).findFirst().orElse(WAIT_CONFIG);
    }

    private TaskStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

