/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.parse;

import com.huawei.ism.tool.scaleout.expansion.common.Constants;
import com.huawei.ism.tool.scaleout.expansion.common.Context;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Module;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Product;
import com.huawei.ism.tool.scaleout.expansion.entity.product.ProductsConf;
import com.huawei.ism.tool.scaleout.expansion.entity.product.SingleProducts;
import com.huawei.ism.tool.scaleout.expansion.exception.parse.ConfParseException;
import com.huawei.ism.tool.scaleout.expansion.parse.IParser;
import com.huawei.ism.tool.scaleout.expansion.parse.TaskConfInitiator;
import com.huawei.ism.tool.scaleout.expansion.parse.YamlParser;
import com.huawei.ism.tool.service.rest.model.entity.BaseProduct;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductInitiator {
    private static final Logger log = LoggerFactory.getLogger(ProductInitiator.class);
    public static final ProductInitiator INS = new ProductInitiator();
    private final IParser<ProductsConf> productParser = new YamlParser<ProductsConf>(ProductsConf.class);
    private TaskConfInitiator taskConfInitiator = TaskConfInitiator.INS;
    private Context context = Context.INS;

    public List<Product> initProductsPackage() {
        File pyRootDir = new File(this.getContext().getPyPath());
        File[] packageDirs = pyRootDir.listFiles();
        if (packageDirs == null) {
            log.error("py dir is empty. products is empty.");
            return Collections.emptyList();
        }
        return Arrays.stream(packageDirs).filter(this::isPackageDir).map(this::parsePackage).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private boolean isPackageDir(File packageDir) {
        File resDir = new File(packageDir, "res");
        File productFile = new File(packageDir, "products.yml");
        return packageDir.isDirectory() && resDir.exists() && productFile.exists();
    }

    public List<Product> parsePackage(File packageDir) {
        try {
            ProductsConf products = this.productParser.parse(packageDir + File.separator + "products.yml");
            return products.getSingleProductsList().stream().map(singleProducts -> this.parseProducts((SingleProducts)singleProducts, packageDir)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (ConfParseException e) {
            log.error("parse product failed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Product> parseProducts(SingleProducts singleProducts, File packageDir) {
        String model = singleProducts.getProductModel();
        List<Module> modules = singleProducts.getSupportModules();
        return singleProducts.getProductVersions().stream().map(version -> this.buildProduct((String)version, model, modules, packageDir)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Product> buildProduct(String version, String model, List<Module> modules, File packageDir) {
        try {
            PropertyResourceBundle resourceBundle = this.initRes(packageDir);
            this.getTaskConfInitiator().initModuleTaskConfig(modules, packageDir, resourceBundle);
            BaseProduct product = ((Product.ProductBuilder)((Product.ProductBuilder)((Product.ProductBuilder)((Product.ProductBuilder)Product.builder().productModel(model)).productVersion(version)).supportModules(modules).productRootPath(packageDir.getCanonicalPath())).resBundle(resourceBundle)).build();
            return Optional.of(product);
        }
        catch (IOException ex) {
            log.error("failed init package res", (Throwable)ex);
            return Optional.empty();
        }
    }

    private PropertyResourceBundle initRes(File productDir) throws IOException {
        try (FileReader fileReader = new FileReader(new File(productDir, "res" + File.separator + Constants.TASK_RES_FILE));){
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(fileReader);
            return propertyResourceBundle;
        }
    }

    private ProductInitiator() {
    }

    public TaskConfInitiator getTaskConfInitiator() {
        return this.taskConfInitiator;
    }

    public Context getContext() {
        return this.context;
    }
}

