/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.parse;

import com.huawei.ism.tool.scaleout.expansion.entity.config.BasicTaskConf;
import com.huawei.ism.tool.scaleout.expansion.entity.config.ExpansionTaskConfig;
import com.huawei.ism.tool.scaleout.expansion.entity.config.ItemTaskConfig;
import com.huawei.ism.tool.scaleout.expansion.entity.config.StepTaskConfig;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Module;
import com.huawei.ism.tool.scaleout.expansion.exception.parse.ConfParseException;
import com.huawei.ism.tool.scaleout.expansion.parse.IParser;
import com.huawei.ism.tool.scaleout.expansion.parse.YamlParser;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskConfInitiator {
    private static final Logger log = LoggerFactory.getLogger(TaskConfInitiator.class);
    public static final TaskConfInitiator INS = new TaskConfInitiator();
    private final IParser<ExpansionTaskConfig> expansionTaskConfigIParser = new YamlParser<ExpansionTaskConfig>(ExpansionTaskConfig.class);

    public void initModuleTaskConfig(List<Module> modules, File packageDir, PropertyResourceBundle bundle) {
        String packageDirPath;
        if (CollectionUtils.isEmpty(modules) || Objects.isNull(packageDir) || Objects.isNull(bundle)) {
            log.warn("empty task config parse param. do nothing.");
            return;
        }
        try {
            packageDirPath = packageDir.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("get packageDir file path failed", (Throwable)e);
            return;
        }
        for (Module module : modules) {
            this.parseExpansionTaskConfig(this.getProcessPath(packageDirPath, module), bundle).ifPresent(module::setExpansionTaskConfig);
        }
    }

    private String getProcessPath(String packageDirPath, Module module) {
        return packageDirPath + File.separator + module.getProcess();
    }

    private Optional<ExpansionTaskConfig> parseExpansionTaskConfig(String path, PropertyResourceBundle bundle) {
        try {
            ExpansionTaskConfig expansionTaskConfig = this.expansionTaskConfigIParser.parse(path);
            this.initPrepareAndFinallyItem(expansionTaskConfig);
            this.transferSupportRollback(expansionTaskConfig);
            this.initTaskConfigRes(expansionTaskConfig, bundle);
            return Optional.of(expansionTaskConfig);
        }
        catch (ConfParseException e) {
            log.error("module conf parse failed.", (Throwable)e);
            return Optional.empty();
        }
    }

    private void initPrepareAndFinallyItem(ExpansionTaskConfig expanTaskConf) {
        this.initPrepareItem(expanTaskConf);
        this.initFinallyItem(expanTaskConf);
    }

    private void initPrepareItem(ExpansionTaskConfig expanTaskConf) {
        expanTaskConf.getSteps().stream().findFirst().map(StepTaskConfig::getItems).ifPresent(items -> items.add(0, new ItemTaskConfig(expanTaskConf.getPrepareScript())));
    }

    private void initFinallyItem(ExpansionTaskConfig expanTaskConf) {
        expanTaskConf.getSteps().stream().reduce((first, second) -> second).map(StepTaskConfig::getItems).ifPresent(items -> items.add(new ItemTaskConfig(expanTaskConf.getFinallyScript())));
    }

    private void transferSupportRollback(ExpansionTaskConfig expanTaskConf) {
        expanTaskConf.setOriSupportRollback(expanTaskConf.isSupportRollback());
        expanTaskConf.getSteps().stream().peek(stepTaskConfig -> this.transferSupportRollback((BasicTaskConf)stepTaskConfig, expanTaskConf.isSupportRollback())).forEach(stepTaskConfig -> this.transferItemSupportRollback(stepTaskConfig.isSupportRollback(), stepTaskConfig.getItems()));
    }

    private void transferItemSupportRollback(boolean isSupportRollback, List<ItemTaskConfig> itemTaskConfigs) {
        itemTaskConfigs.stream().peek(itemTaskConfig -> this.transferSupportRollback((BasicTaskConf)itemTaskConfig, isSupportRollback)).forEach(itemTaskConfig -> this.transferItemSupportRollback(itemTaskConfig.isSupportRollback(), itemTaskConfig.getSubItems()));
    }

    private void transferSupportRollback(BasicTaskConf childConf, boolean isParentSupport) {
        childConf.setOriSupportRollback(childConf.isSupportRollback());
        if (isParentSupport) {
            childConf.setSupportRollback(true);
        }
    }

    private void initTaskConfigRes(ExpansionTaskConfig expansionTaskConfig, PropertyResourceBundle bundle) {
        expansionTaskConfig.getSteps().forEach(stepConfig -> this.initStepConfRes((StepTaskConfig)stepConfig, bundle));
    }

    private void initStepConfRes(StepTaskConfig stepConf, PropertyResourceBundle bundle) {
        stepConf.setName(this.getResStr(bundle, "step", stepConf.getId(), "name"));
        stepConf.setDescription(this.getResStr(bundle, "step", stepConf.getId(), "description"));
        stepConf.getItems().forEach(itemConfig -> this.initItemConfRes((ItemTaskConfig)itemConfig, bundle));
    }

    private void initItemConfRes(ItemTaskConfig itemConf, PropertyResourceBundle bundle) {
        itemConf.setName(this.getResStr(bundle, "item", itemConf.getId(), "name"));
        itemConf.setDescription(this.getResStr(bundle, "item", itemConf.getId(), "description"));
        itemConf.getSubItems().forEach(subItemConfig -> this.initItemConfRes((ItemTaskConfig)subItemConfig, bundle));
    }

    private String getResStr(PropertyResourceBundle bundle, String pre, String id, String end) {
        String key = String.join((CharSequence)".", pre, id, end);
        return bundle.containsKey(key) ? bundle.getString(key) : "--";
    }

    private TaskConfInitiator() {
    }
}

