/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.parse;

import com.huawei.ism.tool.scaleout.expansion.exception.parse.ConfParseException;
import com.huawei.ism.tool.scaleout.expansion.parse.IParser;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.ConstructorException;

public class YamlParser<T>
implements IParser<T> {
    private static final Logger log = LoggerFactory.getLogger(YamlParser.class);
    private final Class<T> entityClass;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T parse(String filePath) throws ConfParseException {
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            T t = new Yaml().loadAs(fileInputStream, this.entityClass);
            return t;
        }
        catch (IOException exception) {
            log.error("cant find conf file, parse conf failed.");
            throw new ConfParseException("cant find conf file.");
        }
        catch (ConstructorException e) {
            log.error("file constructor error.", (Throwable)e);
            throw new ConfParseException("file constructor error.");
        }
    }

    public YamlParser(Class<T> entityClass) {
        this.entityClass = entityClass;
    }
}

