/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.report;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.scaleout.expansion.common.Context;
import com.huawei.ism.tool.scaleout.expansion.exception.report.ReportFailedException;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateFactory {
    private static final Logger log = LoggerFactory.getLogger(TemplateFactory.class);
    private static final String UTF8ENCODE = "UTF-8";
    private static final Configuration CONFIGURATION = new Configuration();
    private static final int MAX = 200;

    public static void processorFtl(String ftlPath, Object data, String outHtmlFilePath) throws ReportFailedException {
        File file = new File(outHtmlFilePath);
        FileUtils.createDir((String)file.getParent());
        try (FileOutputStream fos = new FileOutputStream(outHtmlFilePath);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, ApplicationContext.APP_CHARSET);
             BufferedWriter writer = new BufferedWriter(osw);){
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            log.error("build freemarker template failed. path is :{}", (Object)ftlPath, (Object)e);
            throw new ReportFailedException("creat result file error");
        }
    }

    static {
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(TemplateFactory.class, File.separator + Context.INS.getTemplatePath());
        MultiTemplateLoader loader = new MultiTemplateLoader(new TemplateLoader[]{classTemplateLoader});
        CONFIGURATION.setCacheStorage((CacheStorage)new MruCacheStorage(10, 200));
        CONFIGURATION.setLocale(Locale.getDefault());
        CONFIGURATION.clearEncodingMap();
        CONFIGURATION.setEncoding(Locale.CHINESE, UTF8ENCODE);
        CONFIGURATION.setTemplateLoader((TemplateLoader)loader);
    }
}

