/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.report;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.HtmlResUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.scaleout.expansion.common.Context;
import com.huawei.ism.tool.scaleout.expansion.entity.report.ExecuteResult;
import com.huawei.ism.tool.scaleout.expansion.entity.report.ExpansionDevice;
import com.huawei.ism.tool.scaleout.expansion.exception.report.ReportFailedException;
import com.huawei.ism.tool.scaleout.expansion.report.TemplateFactory;
import com.huawei.ism.tool.scaleout.expansion.report.TreeNode;
import com.huawei.ism.tool.service.common.DevInfoUtil;
import com.huawei.json.JSONArray;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeViewResultBuilder {
    private static final Logger log = LoggerFactory.getLogger(TreeViewResultBuilder.class);
    private static final String FILE_PREFIX_NAME = "ControlCluster";
    private static final String ZIP_SUFFIX = ".zip";
    private static final String DATA = "data";
    private Context context = Context.INS;

    public void builtReport(ExpansionDevice expansionDevice, String resultDir) throws ReportFailedException {
        try {
            log.info("Start export control cluster expansion report.......");
            String tempDir = this.getContext().getTempPath();
            if (new File(tempDir).exists()) {
                com.huawei.ism.tool.obase.utils.FileUtils.clearDir((String)tempDir);
            }
            FileUtils.copyDir(this.getContext().getResourcePath(), String.join((CharSequence)File.separator, tempDir, DATA));
            FileUtils.copyDir(this.getContext().getTempDumpPath(expansionDevice.getTaskId()), String.join((CharSequence)File.separator, tempDir, DATA, "record"));
            this.buildResultFile(expansionDevice, new File(tempDir + File.separator + DATA));
            File targetZipFile = this.buildResultFileName(resultDir);
            log.info("export result to {}", (Object)resultDir);
            this.exportReport(targetZipFile.getCanonicalPath(), tempDir);
        }
        catch (ReportFailedException | IOException exp) {
            log.error("export result file failed", (Throwable)exp);
            throw new ReportFailedException("");
        }
        finally {
            com.huawei.ism.tool.obase.utils.FileUtils.clearDir((String)this.getContext().getTempPath());
        }
    }

    private void buildLeftTree(File devTreeFile) throws ReportFailedException, IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        JSONArray zTreeNodes = new JSONArray();
        TreeNode coverNode = new TreeNode(HtmlResUtils.getString("lefttree.nodeone")).setUrl("head/cover.html").setOpen(true);
        TreeNode summaryNode = new TreeNode(HtmlResUtils.getString("lefttree.nodetwo")).setUrl("summary/summaryInformation.html");
        TreeNode detailNode = new TreeNode(HtmlResUtils.getString("lefttree.nodef")).setUrl("summary/details.html");
        zTreeNodes.put((Object)coverNode).put((Object)summaryNode).put((Object)detailNode);
        data.put("treeNodes", zTreeNodes.toString());
        TemplateFactory.processorFtl("leftTree.html", data, devTreeFile.getCanonicalPath());
    }

    public void buildResultFile(ExpansionDevice expansionNode, File resultFolder) throws IOException {
        String basePath = resultFolder.getCanonicalPath();
        this.buildIndexPage(resultFolder);
        File devTreeFile = new File(basePath + File.separator + "leftTree.html");
        this.buildLeftTree(devTreeFile);
        File coverFile = new File(basePath + File.separator + "head" + File.separator + "cover.html");
        this.buildCover(coverFile);
        File summaryFolder = new File(basePath + File.separator + "summary" + File.separator + "summaryInformation.html");
        this.buildSummary(expansionNode, summaryFolder);
        File detail = new File(basePath + File.separator + "summary" + File.separator + "details.html");
        this.buildDetail(expansionNode, detail);
    }

    private void buildSummary(ExpansionDevice expansionDevice, File summaryFolder) throws ReportFailedException, IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("device", expansionDevice);
        data.put("productVersion", DevInfoUtil.getCompleteDevVersion((DevNode)expansionDevice.getDevNode()));
        data.put("zookeeperNode", expansionDevice.getZookeeperNode());
        data.put("newNode", expansionDevice.getNewNode());
        data.put("title", HtmlResUtils.getString("zk.expansion.title"));
        data.put("clusterDiskType", expansionDevice.getMetaDiskType());
        data.put("oriNodeNum", expansionDevice.getZookeeperNode().size());
        data.put("newZkNodeNum", expansionDevice.getNewNode().size() + expansionDevice.getZookeeperNode().size());
        List<ExecuteResult> executeResults = expansionDevice.getExecuteResults();
        List<ExecuteResult> preCheck = this.extracted(executeResults, "preCheck");
        List<ExecuteResult> execute = this.extracted(executeResults, "executeExpansion");
        List<ExecuteResult> afterCheck = this.extracted(executeResults, "postCheck");
        data.put("expansionRate", this.passRate(preCheck));
        data.put("executeRate", this.passRate(execute));
        data.put("afterRate", this.passRate(afterCheck));
        data.put("totalRate", this.passRate(executeResults));
        data.put("evaluationFlag", this.isAllPass(preCheck));
        data.put("executeFlag", this.isAllPass(execute));
        data.put("afterExpansion", this.isAllPass(afterCheck));
        data.put("totalFlag", this.isAllPass(executeResults));
        TemplateFactory.processorFtl("summaryInformation.html", data, summaryFolder.getCanonicalPath());
    }

    private List<ExecuteResult> extracted(List<ExecuteResult> executeResults, String parentItemId) {
        return executeResults.stream().filter(result -> parentItemId.equals(result.getParentItemId())).collect(Collectors.toList());
    }

    private String passRate(List<ExecuteResult> executeResults) {
        return executeResults.stream().filter(result -> result.getStatus() == 1).count() + "/" + executeResults.size();
    }

    private int isAllPass(List<ExecuteResult> executeResults) {
        return executeResults.stream().allMatch(result -> result.getStatus() == 0) ? 0 : 1;
    }

    private void buildCover(File coverFile) throws ReportFailedException, IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("title", HtmlResUtils.getString("index.title"));
        data.put("logo", "huaweilogo.jpg");
        data.put("copyright", HtmlResUtils.getString("cover.system.copyright"));
        data.put("company", HtmlResUtils.getString("cover.company"));
        data.put("genneratedate", this.dealDateStr(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss 'GMT'Z")));
        data.put("toolversion", UserOpDataSaveUtil.getToolIniProp("tool.version"));
        data.put("toolkitversion", UserOpDataSaveUtil.getToolBoxIniProp("app.version"));
        data.put("date", UserOpDataSaveUtil.getToolIniProp("date"));
        TemplateFactory.processorFtl("cover.html", data, coverFile.getCanonicalPath());
    }

    private void buildDetail(ExpansionDevice expansionDevice, File detailFile) throws ReportFailedException, IOException {
        HashMap<String, List<ExecuteResult>> data = new HashMap<String, List<ExecuteResult>>();
        data.put("executeResults", expansionDevice.getExecuteResults());
        TemplateFactory.processorFtl("details.html", data, detailFile.getCanonicalPath());
    }

    private String dealDateStr(String dateStr) {
        String temp = ":" + dateStr.substring(dateStr.length() - 2, dateStr.length());
        StringBuffer str = new StringBuffer(dateStr);
        str.replace(dateStr.length() - 2, dateStr.length(), temp);
        return str.toString();
    }

    private void buildIndexPage(File resultFolder) throws ReportFailedException, IOException {
        File indexFile = new File(resultFolder.getParent(), "index.html");
        TemplateFactory.processorFtl("index.html", new HashMap(0), indexFile.getCanonicalPath());
    }

    private void exportReport(String zipFile, String tempDir) throws ReportFailedException {
        if (!ZipUtils.compressFile(zipFile, tempDir)) {
            log.error("compress result dir failed");
            throw new ReportFailedException("");
        }
    }

    private File buildResultFileName(String path) throws ReportFailedException {
        File file = Paths.get(path, "ControlCluster_" + StringUtils.getDateFormat((String)"yyyyMMddHHmmss") + ZIP_SUFFIX).toFile();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            log.error("creat result dir failed");
            throw new ReportFailedException("");
        }
        return file;
    }

    public Context getContext() {
        return this.context;
    }
}

