/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.rest.controller;

import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.enums.SandboxStatus;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.scaleout.expansion.common.Context;
import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.common.ResourceConstants;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionConfNode;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Product;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ModifyDeviceStepReq;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ModifyExpansionConfReq;
import com.huawei.ism.tool.scaleout.expansion.entity.request.OmmAuthReq;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.ClusterZKDiskVO;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.DiskVO;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.ExpansionDeviceVO;
import com.huawei.ism.tool.scaleout.expansion.service.IExpansionConfService;
import com.huawei.ism.tool.scaleout.expansion.service.IOmmAuthService;
import com.huawei.ism.tool.service.rest.common.Constants;
import com.huawei.ism.tool.service.rest.controller.BaseDeviceController;
import com.huawei.ism.tool.service.rest.model.entity.AuthClusterNode;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.rest.model.entity.vo.ClusterNodeVO;
import com.huawei.ism.tool.service.rest.model.entity.vo.DevNodeVO;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/device"})
@RestController
public class ExpansionDeviceController
extends BaseDeviceController {
    private static final Object REMOVE_ADD_DEVICE_LOCK = new Object();
    DevNodeManager devNodeManager = DevNodeManager.INS;
    IOmmAuthService ommAuthService;
    IExpansionConfService confService;
    Context context = Context.INS;

    public ExpansionDeviceController(INodeSupport support, INodeObserver nodeObserver, IOmmAuthService ommAuthService, IExpansionConfService expansionConfService) {
        super(support, nodeObserver);
        this.ommAuthService = ommAuthService;
        this.confService = expansionConfService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<List<? extends DevNodeVO>> queryAddedDevice() {
        Object object = REMOVE_ADD_DEVICE_LOCK;
        synchronized (object) {
            List expansionDeviceVOS = ((List)super.queryAddedDevice().getData()).stream().map(DevNodeVO.class::cast).map(this::copyDevNodeVO2ExpansionDeviceVO).collect(Collectors.toList());
            return Response.success(expansionDeviceVOS);
        }
    }

    private ExpansionDeviceVO copyDevNodeVO2ExpansionDeviceVO(DevNodeVO devNodeVO) {
        ExpansionDeviceVO expansionDeviceVO = new ExpansionDeviceVO();
        BeanUtils.copyProperties((Object)devNodeVO, (Object)((Object)expansionDeviceVO));
        expansionDeviceVO.fillInfo(this.devNodeManager.findDevNode(devNodeVO.getSn()));
        return expansionDeviceVO;
    }

    @PutMapping(value={"/ommAuth"})
    public Response<Void> ommAuth(@RequestBody OmmAuthReq ommAuthInfo) {
        this.ommAuthService.ommAuth(ommAuthInfo.getDeviceSn(), ommAuthInfo.getOmmPassword());
        return Response.success();
    }

    @GetMapping(value={"/expansionConfNodes"})
    public Response<List<ExpansionConfNode>> queryExpansionConfNodes(String deviceSn) {
        return Response.success(this.confService.queryExpansionConfNodes(deviceSn));
    }

    @PutMapping(value={"/expansionConfNodes"})
    public Response<List<ExpansionConfNode>> modifyExpansionConf(@RequestBody ModifyExpansionConfReq modifyExpansionConfReq) {
        return Response.success(this.confService.modifyExpansionConf(modifyExpansionConfReq));
    }

    @GetMapping(value={"/nodes/disks"})
    public Response<List<DiskVO>> queryNodeDisks(String deviceSn, int nodeId) {
        List disks = this.confService.queryDisks(deviceSn, nodeId).stream().map(DiskVO::new).collect(Collectors.toList());
        List sysDisks = this.confService.querySysDisks(deviceSn, nodeId).stream().map(DiskVO::new).collect(Collectors.toList());
        disks.addAll(sysDisks);
        return Response.success(disks);
    }

    @GetMapping(value={"/zkdisk"})
    public Response<ClusterZKDiskVO> queryClusterZkDiskInfo(String deviceSn) {
        return Response.success((Object)new ClusterZKDiskVO(this.confService.queryZKDiskInfo(deviceSn)));
    }

    @PutMapping(value={"/step"})
    public Response<Void> modifyDeviceStep(@RequestBody ModifyDeviceStepReq modifyDeviceStepReq) {
        this.confService.modifyDeviceStep(modifyDeviceStepReq);
        return Response.success();
    }

    @GetMapping(value={"/products"})
    public Response<List<Product>> getProducts() {
        return Response.success(this.context.getSupportProducts());
    }

    public Response<List<ClusterNodeVO>> queryClusterNodesInfo(@PathVariable(value="sn") String sn) {
        Optional businessDeviceOpt = BusinessDeviceUtil.INS.findBusinessDev(sn);
        if (!businessDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Device.NODE_NOT_EXIST);
        }
        BusinessDevice businessDevice = (BusinessDevice)businessDeviceOpt.get();
        List clusterNodes = businessDevice.getAuthClusterNodes();
        if (CollectionUtil.isEmpty((Collection)clusterNodes)) {
            return this.queryClusterNod(sn, businessDevice);
        }
        this.updateOsAuthBySandboxStatus(businessDevice);
        return Response.success((Object)ClusterNodeVO.getClusterNodes((BusinessDevice)businessDevice));
    }

    private void updateOsAuthBySandboxStatus(BusinessDevice businessDevice) {
        AuthClusterNode.AuthStatusInfo osAuthStatusInfo = new AuthClusterNode.AuthStatusInfo(ResourceConstants.SANDBOX_AUTH_FAILED, Status.FAILED);
        Map sandboxStatusMap = this.sandBoxService.queryServersSandboxStatus(businessDevice.getDevNode());
        businessDevice.getAuthClusterNodes().stream().filter(node -> !Status.WAITING.equals((Object)node.getOsAuthStatusInfo().getAuthStatus())).filter(node -> SandboxStatus.OPEN.equals(sandboxStatusMap.get(node.getNode().getManagementIp()))).forEach(node -> node.setOsAuthStatusInfo(osAuthStatusInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Response<List<ClusterNodeVO>> queryClusterNod(String sn, BusinessDevice businessDevice) {
        Object object = REMOVE_ADD_DEVICE_LOCK;
        synchronized (object) {
            this.removeDevice(businessDevice.getDevNode().getDeviceSerialNumber());
            TaskResult taskResult = this.service.addDeviceByRest(businessDevice.getDevNode(), DeviceOpr.UPDATE);
            return Response.buildResultFromTaskResult((TaskResult)taskResult, (Object)ClusterNodeVO.getClusterNodes((BusinessDevice)BusinessDeviceUtil.INS.findBusinessDev(sn).orElseGet(BusinessDevice::new)));
        }
    }
}

