/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.rest.controller;

import com.huawei.ism.tool.scaleout.expansion.entity.request.ItemIndexReq;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ReportParam;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.ItemVO;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.StepVO;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.TaskVO;
import com.huawei.ism.tool.scaleout.expansion.service.IReportService;
import com.huawei.ism.tool.scaleout.expansion.service.ITaskService;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task"})
public class TaskController {
    private final ITaskService taskService;
    private final IReportService reportService;

    @GetMapping(value={""})
    public Response<TaskVO> queryTask(String taskId) {
        return Response.success((Object)this.taskService.queryTask(taskId));
    }

    @GetMapping(value={"/steps"})
    public Response<List<StepVO>> queryTaskSteps(String taskId) {
        return Response.success(this.taskService.queryTaskSteps(taskId));
    }

    @GetMapping(value={"/items"})
    public Response<List<ItemVO>> queryStepItems(String taskId, String stepId) {
        return Response.success(this.taskService.queryStepItems(taskId, stepId));
    }

    @PostMapping(value={"/start/{deviceSn}"})
    public Response<String> execTask(@PathVariable(value="deviceSn") String deviceSn) {
        return Response.success((Object)this.taskService.startTask(deviceSn));
    }

    @PostMapping(value={"/item/rollback"})
    public Response<Void> rollbackItem(@RequestBody ItemIndexReq itemIndexInfo) {
        this.taskService.rollback(itemIndexInfo);
        return Response.success();
    }

    @PostMapping(value={"/item/retry"})
    public Response<Void> retryItem(@RequestBody ItemIndexReq itemIndexInfo) {
        this.taskService.retryTask(itemIndexInfo);
        return Response.success();
    }

    @PostMapping(value={"/item/continue/{taskId}"})
    public Response<Void> continueItem(@PathVariable(value="taskId") String taskId) {
        this.taskService.continueTask(taskId);
        return Response.success();
    }

    @GetMapping(value={"/ids"})
    public Response<List<String>> getTaskId(String deviceSn) {
        return Response.success(this.taskService.queryTaskIds(deviceSn));
    }

    @PostMapping(value={"/report"})
    public Response<Void> exportReport(@RequestBody ReportParam reportParam) {
        this.reportService.export(reportParam);
        return Response.success();
    }

    public TaskController(ITaskService taskService, IReportService reportService) {
        this.taskService = taskService;
        this.reportService = reportService;
    }
}

