/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.gson.JsonParseException;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.response.ControlClusterInfo;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.response.NodeDisks;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.response.SysDisks;
import com.huawei.ism.tool.scaleout.expansion.exception.devnode.QueryDeviceRestFailedException;
import com.huawei.ism.tool.scaleout.expansion.service.IDeviceRestService;
import com.huawei.json.JSONUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceRestServiceImpl
implements IDeviceRestService {
    private static final Logger log = LoggerFactory.getLogger(DeviceRestServiceImpl.class);
    private final DevNodeManager devNodeManager = DevNodeManager.INS;

    protected RestConnection getRestConnection(@NotNull DevNode devNode) throws ToolException {
        RestConnection restConn = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (Objects.isNull(restConn)) {
            log.error("rest conn is null: {}", (Object)devNode.getDeviceSerialNumber());
            throw new QueryDeviceRestFailedException("rest conn is null.");
        }
        return restConn;
    }

    private ResponseInfo getSuccessResponse(ResponseInfo responseInfo) {
        if (StringUtils.isEmpty((CharSequence)responseInfo.getContent())) {
            log.error("connection is closed, response: {}", (Object)responseInfo);
            throw new QueryDeviceRestFailedException("execute get failed.");
        }
        if (!responseInfo.isSuccess() || !Objects.equals(JSON.parseObject((String)responseInfo.getContent()).getString("result"), "0")) {
            log.error("execute rest failed, response: {}", (Object)responseInfo);
            throw new QueryDeviceRestFailedException("execute get failed.");
        }
        return responseInfo;
    }

    private ResponseInfo doExecGet(@NotNull DevNode devNode, String url, Map<String, Object> param) throws ToolException {
        RestConnection restConn = this.getRestConnection(devNode);
        ResponseInfo responseInfo = Objects.isNull(param) ? restConn.execGet(url) : restConn.execGet(url, param);
        return this.getSuccessResponse(responseInfo);
    }

    private ResponseInfo doExecPost(@NotNull DevNode devNode, String url, Map<String, Object> param) throws ToolException {
        RestConnection restConn = this.getRestConnection(devNode);
        ResponseInfo responseInfo = restConn.execPost(url, param);
        return this.getSuccessResponse(responseInfo);
    }

    @Override
    public ControlClusterInfo queryDeviceControlCluster(String deviceSn) throws QueryDeviceRestFailedException {
        DevNode devNode = this.getDevNodeManager().findDevNode(deviceSn).getOriDevNode();
        try {
            ResponseInfo responseInfo = this.doExecGet(devNode, RestUtil.getControlClusterUri((DevNode)devNode), null);
            ControlClusterInfo controlClusterInfo = (ControlClusterInfo)JSONUtils.jsonToBean((String)responseInfo.getContent(), ControlClusterInfo.class);
            return controlClusterInfo;
        }
        catch (JsonParseException | ToolException e) {
            log.error("query control cluster failed.", e);
            throw new QueryDeviceRestFailedException("query control cluster failed.");
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    @Override
    public List<NodeDisks.Disk> queryNodeDisk(String deviceSn, int nodeId) throws QueryDeviceRestFailedException {
        DevNode devNode = this.getDevNodeManager().findDevNode(deviceSn).getOriDevNode();
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("ip", this.findNodeIp(devNode, nodeId));
            ResponseInfo responseInfo = this.doExecGet(devNode, RestUtil.getNodeDiskInfoUri((DevNode)devNode), param);
            List<NodeDisks.Disk> list = ((NodeDisks)JSON.toJavaObject((JSON)JSON.parseObject((String)responseInfo.getContent()), NodeDisks.class)).getDisks();
            return list;
        }
        catch (JsonParseException | ToolException e) {
            log.error("query node disks failed.", e);
            throw new QueryDeviceRestFailedException("query node disks failed.");
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SysDisks.SysDisk> queryNodeSysDisk(String deviceSn, int nodeId) {
        DevNode devNode = this.getDevNodeManager().findDevNode(deviceSn).getOriDevNode();
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("nodeIpList", new String[]{this.findNodeIp(devNode, nodeId)});
            ResponseInfo responseInfo = this.doExecPost(devNode, RestUtil.querySysDiskInfoUri((DevNode)devNode), param);
            List<SysDisks.SysDisk> sysDisks = ((SysDisks)JSONUtils.jsonToBean((String)responseInfo.getContent(), SysDisks.class)).getServers().get(this.findNodeIp(devNode, nodeId));
            if (CollectionUtil.isEmpty(sysDisks)) {
                List<SysDisks.SysDisk> list = Collections.singletonList(this.buildDefaultSysDisk());
                return list;
            }
            List<SysDisks.SysDisk> list = sysDisks;
            return list;
        }
        catch (JsonParseException | ToolException e) {
            log.error("query sys disks failed.", e);
            List<SysDisks.SysDisk> list = Collections.singletonList(this.buildDefaultSysDisk());
            return list;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    private SysDisks.SysDisk buildDefaultSysDisk() {
        SysDisks.SysDisk sysDisk = new SysDisks.SysDisk();
        sysDisk.setHealth(0);
        sysDisk.setPhyDevEsn("sys_disk");
        return sysDisk;
    }

    private String findNodeIp(DevNode devNode, int nodeId) {
        return devNode.getClusterNodes().stream().filter(clusterNode -> clusterNode.getId() == nodeId).findFirst().map(ClusterNode::getManagementIp).orElseThrow(() -> new QueryDeviceRestFailedException(String.format(Locale.ENGLISH, "cant find match clusterNode of %s in device %s", nodeId, devNode.getDeviceSerialNumber())));
    }

    public DevNodeManager getDevNodeManager() {
        return this.devNodeManager;
    }
}

