/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.service.impl;

import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionConfNode;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionDevNode;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.response.ControlClusterInfo;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.response.NodeDisks;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.response.SysDisks;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.response.ZKDisk;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ModifyDeviceStepReq;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ModifyExpansionConfReq;
import com.huawei.ism.tool.scaleout.expansion.enumeration.ExpansionNodeConfType;
import com.huawei.ism.tool.scaleout.expansion.enumeration.TaskStatus;
import com.huawei.ism.tool.scaleout.expansion.exception.devnode.QueryDeviceRestFailedException;
import com.huawei.ism.tool.scaleout.expansion.exception.task.InvalidModifyParamException;
import com.huawei.ism.tool.scaleout.expansion.service.IDeviceRestService;
import com.huawei.ism.tool.scaleout.expansion.service.IExpansionConfService;
import com.huawei.ism.tool.scaleout.expansion.task.TaskManager;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExpansionConfNodeServiceImpl
implements IExpansionConfService {
    private static final Logger log = LoggerFactory.getLogger(ExpansionConfNodeServiceImpl.class);
    private static final List<TaskStatus> CAN_MODIFY_STATUS_LIST = Arrays.asList(TaskStatus.WAIT_CONFIG, TaskStatus.ALREADY_CONFIG);
    final IDeviceRestService deviceRestService;
    DevNodeManager devNodeManager = DevNodeManager.INS;
    TaskManager taskManager = TaskManager.INS;

    @Override
    public List<ExpansionConfNode> queryExpansionConfNodes(String deviceSn) {
        if (this.detectedControlClusterChanged(deviceSn) || !this.devNodeManager.isExistConfNodes(deviceSn)) {
            ControlClusterInfo controlClusterInfo = this.devNodeManager.getControlClusterInfo(deviceSn);
            this.devNodeManager.addControlCluster(deviceSn, controlClusterInfo);
            List<ExpansionConfNode> expansionConfNodes = this.initExpansionConfNodes(deviceSn, controlClusterInfo);
            this.devNodeManager.addConfNodes(deviceSn, expansionConfNodes);
        }
        return this.devNodeManager.getExpansionConfs(deviceSn);
    }

    private List<ExpansionConfNode> initExpansionConfNodes(String deviceSn, ControlClusterInfo controlClusterInfo) {
        return this.devNodeManager.findDevNode(deviceSn).getOriDevNode().getClusterNodes().stream().map(clusterNode -> this.tran2ExpansionDevNode((ClusterNode)clusterNode, controlClusterInfo)).collect(Collectors.toList());
    }

    private ExpansionConfNode tran2ExpansionDevNode(ClusterNode clusterNode, ControlClusterInfo controlClusterInfo) {
        ExpansionConfNode expansionConfNode = new ExpansionConfNode(clusterNode);
        Optional<ControlClusterInfo.NodeInfo> nodeInfoOptional = this.getMatchControlNode(controlClusterInfo, clusterNode.getManagementIp());
        if (nodeInfoOptional.isPresent()) {
            expansionConfNode.setExpansionType(ExpansionNodeConfType.IN_CONTROL_CLUSTER.getCode());
            expansionConfNode.setMetaDisk(nodeInfoOptional.get().getDiskInfo().getDiskSn());
            return expansionConfNode;
        }
        if (clusterNode.includedStorageService()) {
            expansionConfNode.setExpansionType(ExpansionNodeConfType.SUPPORT_EXPANSION.getCode());
            return expansionConfNode;
        }
        expansionConfNode.setExpansionType(ExpansionNodeConfType.ELSE.getCode());
        return expansionConfNode;
    }

    private Optional<ControlClusterInfo.NodeInfo> getMatchControlNode(ControlClusterInfo controlClusterInfo, String nodeIp) {
        return controlClusterInfo.getNodeInfo().stream().filter(node -> node.getNodeMgrIp().equals(nodeIp)).findFirst();
    }

    @Override
    public List<ExpansionConfNode> modifyExpansionConf(ModifyExpansionConfReq modifyConfReq) {
        if (modifyConfReq.getNodeIds().size() > 1 && !StringUtils.isNULLStr((String)modifyConfReq.getMetaDisk())) {
            log.error("invalid param with more than one node but single metaDisk.");
            throw new InvalidModifyParamException("invalid modify param.");
        }
        this.devNodeManager.getExpansionConfs(modifyConfReq.getDeviceSn()).stream().filter(expansionConfNode -> modifyConfReq.getNodeIds().contains(expansionConfNode.getId())).forEach(node -> this.modifyExpansionConf((ExpansionConfNode)node, modifyConfReq.getType(), modifyConfReq.getMetaDisk()));
        return this.devNodeManager.getExpansionConfs(modifyConfReq.getDeviceSn());
    }

    @Override
    public void modifyDeviceStep(ModifyDeviceStepReq modifyDeviceStepReq) throws InvalidModifyParamException {
        if (!CAN_MODIFY_STATUS_LIST.contains((Object)TaskStatus.getStatusByCode(modifyDeviceStepReq.getStatus()))) {
            log.error("invalid modify param, modify status: {}", (Object)modifyDeviceStepReq.getStatus());
            throw new InvalidModifyParamException("invalid modify param.");
        }
        ExpansionDevNode expansionDevNode = this.devNodeManager.findDevNode(modifyDeviceStepReq.getDeviceSn());
        expansionDevNode.setExpansionStrategies(modifyDeviceStepReq.getStrategies());
        log.info("device {} modify expansion strategy to {}", (Object)expansionDevNode.getId(), expansionDevNode.getExpansionStrategies());
        expansionDevNode.setExpansionDevNodeStatus(TaskStatus.getStatusByCode(modifyDeviceStepReq.getStatus()));
    }

    @Override
    public List<NodeDisks.Disk> queryDisks(String deviceSn, int nodeId) {
        return this.deviceRestService.queryNodeDisk(deviceSn, nodeId);
    }

    @Override
    public List<SysDisks.SysDisk> querySysDisks(String deviceSn, int nodeId) {
        return this.deviceRestService.queryNodeSysDisk(deviceSn, nodeId);
    }

    @Override
    public ZKDisk queryZKDiskInfo(String deviceSn) {
        ControlClusterInfo.NodeInfo nodeInfo = this.queryFirstControlNode(deviceSn);
        if (Objects.equals(nodeInfo.getDiskInfo().getDiskType(), "sys_disk")) {
            List<SysDisks.SysDisk> sysDisks = this.deviceRestService.queryNodeSysDisk(deviceSn, nodeInfo.getNodeId());
            return CollectionUtils.isEmpty(sysDisks) ? new ZKDisk(new SysDisks.SysDisk()) : new ZKDisk(sysDisks.get(0));
        }
        List<NodeDisks.Disk> nodeDisks = this.deviceRestService.queryNodeDisk(deviceSn, nodeInfo.getNodeId());
        return nodeDisks.stream().filter(disk -> disk.getDiskSn().equals(nodeInfo.getDiskInfo().getDiskSn())).map(ZKDisk::new).findFirst().orElse(new ZKDisk(new NodeDisks.Disk()));
    }

    private ControlClusterInfo.NodeInfo queryFirstControlNode(String deviceSn) {
        return (ControlClusterInfo.NodeInfo)this.queryControlCluster(deviceSn).getNodeInfo().stream().findFirst().orElseThrow(() -> new QueryDeviceRestFailedException("failed to query control node of " + deviceSn));
    }

    private void modifyExpansionConf(ExpansionConfNode expansionConfNode, int type, String metaDisk) {
        expansionConfNode.setExpansionType(type);
        expansionConfNode.setMetaDisk(metaDisk);
        log.info("device {} modify expansion disk to {}", (Object)expansionConfNode.getId(), (Object)metaDisk);
    }

    @Override
    public ControlClusterInfo queryControlCluster(String deviceSn) {
        this.detectedControlClusterChanged(deviceSn);
        return this.devNodeManager.getControlClusterInfo(deviceSn);
    }

    private boolean detectedControlClusterChanged(String deviceSn) {
        ControlClusterInfo curControlClusterInfo = this.deviceRestService.queryDeviceControlCluster(deviceSn);
        ControlClusterInfo cacheControlClusterInfo = this.devNodeManager.getControlClusterInfo(deviceSn);
        if (Objects.isNull(cacheControlClusterInfo) || curControlClusterInfo.getNodeInfo().size() != cacheControlClusterInfo.getNodeInfo().size()) {
            this.devNodeManager.addControlCluster(deviceSn, curControlClusterInfo);
            return true;
        }
        return false;
    }

    public ExpansionConfNodeServiceImpl(IDeviceRestService deviceRestService) {
        this.deviceRestService = deviceRestService;
    }
}

