/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.service.impl;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.scaleout.expansion.common.Context;
import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionDevNode;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Product;
import com.huawei.ism.tool.service.rest.common.DeviceObs;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExpansionNodeObserverImpl
implements INodeObserver {
    private static final Logger log = LoggerFactory.getLogger(ExpansionNodeObserverImpl.class);

    public void fireNodeAdd(DevNode dev) {
        String sn = dev.getDeviceSerialNumber();
        BusinessDevice businessDevice = (BusinessDevice)DeviceObs.INS.getSn2BusinessDevMap().get(sn);
        this.initProductModel(businessDevice.getDevNode());
        Optional<Product> product = Context.INS.findProduct(dev);
        if (!product.isPresent()) {
            log.error("dev[{}]: productVersio[{}] productModel[{}] deviceType[{}] can not find product", new Object[]{dev.getDeviceSerialNumber(), dev.getProductVersion(), dev.getProductModel(), dev.getDeviceType()});
            return;
        }
        DevNodeManager.INS.addDevNode(dev.getDeviceSerialNumber(), new ExpansionDevNode(businessDevice, product.get()));
    }

    private void initProductModel(DevNode node) {
        if (node.getDeviceType() == null) {
            log.warn("node {} type is null", (Object)StringUtils.getCleanMessage(node.getIp()));
            node.setProductModel("");
            return;
        }
        node.setProductModel(node.getDeviceType().toString());
    }

    public void fireNodeDelete(DevNode dev) {
        DevNodeManager.INS.removeDevNode(dev.getDeviceSerialNumber());
    }

    public void fireNodeModify(DevNode dev) {
    }
}

