/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.service.impl;

import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.enums.FsmRole;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionDevNode;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.OmmAuthInfo;
import com.huawei.ism.tool.scaleout.expansion.exception.devnode.FsmAuthNotSuccessException;
import com.huawei.ism.tool.scaleout.expansion.exception.devnode.OmmAuthFailedException;
import com.huawei.ism.tool.scaleout.expansion.service.IOmmAuthService;
import com.huawei.ism.tool.service.rest.model.entity.AuthClusterNode;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OmmAuthServiceImpl
implements IOmmAuthService {
    private static final Logger log = LoggerFactory.getLogger(OmmAuthServiceImpl.class);
    private static final String OMM_AUTH_CMD = "source /opt/dsware/tools/ops_tool/tool_kit/get_db_common_info.sh 2 && getDBPasswd && su - ommdba -s /bin/bash -c \"gsql -U omm -d omm -p 21600 -W %s -v schema_name=OMM_1\"";
    private static final String OMM_END_STR = "OMM=>";
    private static final List<String> OMM_END_STR_LIST = Collections.singletonList("OMM=>");
    private static final int OMM_AUTH_TIMEOUT = 10;
    private final DevNodeManager devNodeManager = DevNodeManager.INS;

    @Override
    public void ommAuth(String deviceSn, String ommPassword) {
        ExpansionDevNode expansionDevNode = this.devNodeManager.findDevNode(deviceSn);
        this.doOmmAuth(BusinessDeviceUtil.INS.buildOsNode(this.getFsmAuthClusterNode(expansionDevNode)), ommPassword);
        expansionDevNode.setOmmAuthInfo(new OmmAuthInfo(ommPassword, true));
    }

    private AuthClusterNode getFsmAuthClusterNode(ExpansionDevNode expansionDevNode) {
        return expansionDevNode.getBusinessDevice().getAuthClusterNodes().stream().filter(authClusterNode -> authClusterNode.getNode().getFsmRole() == FsmRole.ACTIVE).findFirst().filter(authClusterNode -> authClusterNode.getOsAuthStatusInfo().isAuthSuccess()).orElseThrow(() -> new FsmAuthNotSuccessException("fsm master not auth success"));
    }

    private void doOmmAuth(DevNode osNode, String ommPassword) {
        try {
            SshConnection sshConn = (SshConnection)SshConnectionManager.getSshConnection((DevNode)osNode);
            String responseInfo = sshConn.execCmdNoLogTimout(String.format(OMM_AUTH_CMD, ommPassword.replaceAll("[~!@#$%^&*()\\-_=+|\\[{}\\];:,<.>/?]", "\\\\$0")), 10, OMM_END_STR_LIST);
            if (!responseInfo.contains(OMM_END_STR)) {
                log.error("om auth failed, response : {}", (Object)responseInfo.replace(ommPassword, "*****"));
                throw new OmmAuthFailedException("omm auth failed");
            }
        }
        catch (ToolException e) {
            log.error("can not conn ssh.", (Throwable)e);
            throw new OmmAuthFailedException("can not conn ssh.");
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)osNode);
        }
    }
}

